/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.worldgen.blockTransformers;

import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.math.IvVecMathHelper;
import ivorius.ivtoolkit.tools.IvWorldData;
import ivorius.reccomplex.worldgen.blockTransformers.BlockTransformer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class BlockTransformerNatural
implements BlockTransformer {
    public static final double NATURAL_EXPANSION_DISTANCE = 4.0;
    public static final double NATURAL_DISTANCE_RANDOMIZATION = 6.0;
    public Block sourceBlock;
    public int sourceMetadata;

    public BlockTransformerNatural(Block sourceBlock, int sourceMetadata) {
        this.sourceBlock = sourceBlock;
        this.sourceMetadata = sourceMetadata;
    }

    @Override
    public boolean matches(Block block, int metadata) {
        return block == this.sourceBlock && (metadata < 0 || metadata == this.sourceMetadata);
    }

    @Override
    public void apply(World world, Random random, BlockTransformer.Phase phase, BlockCoord coord, Block sourceBlock, int sourceMetadata, IvWorldData worldData) {
        BiomeGenBase biome = world.func_72807_a(coord.x, coord.z);
        Block topBlock = biome.field_76752_A;
        Block fillerBlock = biome.field_76753_B;
        Block mainBlock = world.field_73011_w.field_76574_g == -1 ? Blocks.field_150424_aL : (world.field_73011_w.field_76574_g == 1 ? Blocks.field_150377_bs : Blocks.field_150348_b);
        boolean useStoneBlock = this.hasBlockAbove(world, coord.x, coord.y, coord.z, mainBlock);
        if (phase == BlockTransformer.Phase.BEFORE) {
            ArrayList currentList = new ArrayList();
            ArrayList<int[]> nextList = new ArrayList<int[]>();
            nextList.add(new int[]{coord.x, coord.z});
            for (int currentY = coord.y; nextList.size() > 0 && currentY > 1; --currentY) {
                ArrayList cachedList = currentList;
                currentList = nextList;
                nextList = cachedList;
                while (currentList.size() > 0) {
                    boolean replaceable;
                    int[] currentPos = (int[])currentList.remove(0);
                    int currentX = currentPos[0];
                    int currentZ = currentPos[1];
                    Block curBlock = world.func_147439_a(currentX, currentY, currentZ);
                    boolean bl = replaceable = currentY == coord.y || curBlock.isReplaceable((IBlockAccess)world, currentX, currentY, currentZ);
                    if (replaceable) {
                        Block setBlock = useStoneBlock ? mainBlock : (this.isTopBlock(world, currentX, currentY, currentZ) ? topBlock : fillerBlock);
                        world.func_147449_b(currentX, currentY, currentZ, setBlock);
                    }
                    if (!replaceable) continue;
                    double yForDistance = (double)coord.y * 0.3 + (double)currentY * 0.7;
                    double distToOrigSQ = IvVecMathHelper.distanceSQ(new double[]{coord.x, coord.y, coord.z}, new double[]{currentX, yForDistance, currentZ});
                    double add = (random.nextDouble() - random.nextDouble()) * 6.0;
                    double d = add < 0.0 ? -(add * add) : add * add;
                    if (!((distToOrigSQ += d) < 16.0)) continue;
                    this.addIfNew(nextList, currentX, currentZ);
                    this.addIfNew(nextList, currentX - 1, currentZ);
                    this.addIfNew(nextList, currentX + 1, currentZ);
                    this.addIfNew(nextList, currentX, currentZ - 1);
                    this.addIfNew(nextList, currentX, currentZ + 1);
                }
            }
        } else {
            Block setBlock = useStoneBlock ? mainBlock : (this.isTopBlock(world, coord.x, coord.y, coord.z) ? topBlock : fillerBlock);
            world.func_147449_b(coord.x, coord.y, coord.z, setBlock);
        }
    }

    private void addIfNew(List<int[]> list, int ... object) {
        if (!list.contains(object)) {
            list.add(object);
        }
    }

    private boolean hasBlockAbove(World world, int x, int y, int z, Block blockType) {
        int origY = y;
        while (y < world.func_72800_K() && y < origY + 60) {
            if (world.func_147439_a(x, y, z) == blockType) {
                return true;
            }
            ++y;
        }
        return false;
    }

    private boolean isTopBlock(World world, int x, int y, int z) {
        return !world.func_147445_c(x, y + 1, z, false);
    }

    @Override
    public String displayString() {
        return "Natural: " + this.sourceBlock.func_149732_F();
    }

    @Override
    public boolean generatesInPhase(BlockTransformer.Phase phase) {
        return phase == BlockTransformer.Phase.AFTER || phase == BlockTransformer.Phase.BEFORE;
    }
}

