/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.worldgen.blockTransformers;

import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.math.IvVecMathHelper;
import ivorius.ivtoolkit.tools.IvWorldData;
import ivorius.reccomplex.worldgen.blockTransformers.BlockTransformer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class BlockTransformerNaturalAir
implements BlockTransformer {
    public static final double NATURAL_EXPANSION_DISTANCE = 4.0;
    public static final double NATURAL_DISTANCE_RANDOMIZATION = 10.0;
    public Block sourceBlock;
    public int sourceMetadata;

    public BlockTransformerNaturalAir(Block sourceBlock, int sourceMetadata) {
        this.sourceBlock = sourceBlock;
        this.sourceMetadata = sourceMetadata;
    }

    @Override
    public boolean matches(Block block, int metadata) {
        return block == this.sourceBlock && (metadata < 0 || metadata == this.sourceMetadata);
    }

    @Override
    public void apply(World world, Random random, BlockTransformer.Phase phase, BlockCoord coord, Block sourceBlock, int sourceMetadata, IvWorldData worldData) {
        BiomeGenBase biome = world.func_72807_a(coord.x, coord.z);
        Block topBlock = biome.field_76752_A;
        Block fillerBlock = biome.field_76753_B;
        coord = coord.subtract(0, 4, 0);
        ArrayList currentList = new ArrayList();
        ArrayList<int[]> nextList = new ArrayList<int[]>();
        nextList.add(new int[]{coord.x, coord.z});
        int worldHeight = world.func_72800_K();
        for (int currentY = coord.y; nextList.size() > 0 && currentY < worldHeight; ++currentY) {
            ArrayList cachedList = currentList;
            currentList = nextList;
            nextList = cachedList;
            while (currentList.size() > 0) {
                boolean replaceable;
                int currentZ;
                int[] currentPos = (int[])currentList.remove(0);
                int currentX = currentPos[0];
                Block curBlock = world.func_147439_a(currentX, currentY, currentZ = currentPos[1]);
                boolean isFoliage = curBlock.isFoliage((IBlockAccess)world, currentX, currentY, currentZ) || curBlock.func_149688_o() == Material.field_151584_j || curBlock.func_149688_o() == Material.field_151585_k || curBlock.func_149688_o() == Material.field_151575_d;
                boolean isCommon = curBlock == Blocks.field_150348_b || curBlock == Blocks.field_150346_d || curBlock == Blocks.field_150354_m || curBlock == Blocks.field_150406_ce || curBlock == Blocks.field_150351_n;
                boolean bl = replaceable = currentY == coord.y || curBlock == topBlock || curBlock == fillerBlock || curBlock.isReplaceable((IBlockAccess)world, currentX, currentY, currentZ) || isCommon || isFoliage;
                if (replaceable) {
                    world.func_147468_f(currentX, currentY, currentZ);
                }
                if (!replaceable && curBlock.func_149688_o() != Material.field_151579_a) continue;
                double distToOrigSQ = IvVecMathHelper.distanceSQ(new double[]{coord.x, coord.y, coord.z}, new double[]{currentX, currentY, currentZ});
                double add = (random.nextDouble() - random.nextDouble()) * 10.0;
                double d = add < 0.0 ? -(add * add) : add * add;
                if (!((distToOrigSQ += d) < 16.0)) continue;
                this.addIfNew(nextList, currentX, currentZ);
                this.addIfNew(nextList, currentX - 1, currentZ);
                this.addIfNew(nextList, currentX + 1, currentZ);
                this.addIfNew(nextList, currentX, currentZ - 1);
                this.addIfNew(nextList, currentX, currentZ + 1);
            }
        }
    }

    private void addIfNew(List<int[]> list, int ... object) {
        if (!list.contains(object)) {
            list.add(object);
        }
    }

    @Override
    public String displayString() {
        return "Natural Air: " + this.sourceBlock.func_149732_F();
    }

    @Override
    public boolean generatesInPhase(BlockTransformer.Phase phase) {
        return phase == BlockTransformer.Phase.BEFORE;
    }
}

