/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.maze;

import ivorius.ivtoolkit.maze.Maze;
import ivorius.ivtoolkit.maze.MazeComponent;
import ivorius.ivtoolkit.maze.MazeComponentPosition;
import ivorius.ivtoolkit.maze.MazePath;
import ivorius.ivtoolkit.maze.MazeRoom;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import net.minecraft.util.WeightedRandom;

public class MazeGeneratorWithComponents {
    public static List<MazeComponentPosition> generatePaths(Random rand, Maze maze, List<MazeComponent> mazeComponents) {
        ArrayList<MazeComponentPosition> positions = new ArrayList<MazeComponentPosition>();
        Stack<MazeRoom> positionStack = new Stack<MazeRoom>();
        for (MazePath path : maze.allPaths()) {
            if (maze.get(path) != 3) continue;
            positionStack.push(path.getSourceRoom());
            positionStack.push(path.getDestinationRoom());
        }
        ArrayList<MazeComponentPosition> validComponents = new ArrayList<MazeComponentPosition>();
        while (!positionStack.empty()) {
            MazeRoom position = (MazeRoom)positionStack.pop();
            if (maze.get(position) != 0) continue;
            validComponents.clear();
            for (MazeComponent component : mazeComponents) {
                for (MazeRoom attachedRoom : component.getRooms()) {
                    MazeRoom componentPosition = position.sub(attachedRoom);
                    if (!MazeGeneratorWithComponents.canComponentBePlaced(maze, new MazeComponentPosition(component, componentPosition))) continue;
                    validComponents.add(new MazeComponentPosition(component, componentPosition));
                }
            }
            if (validComponents.size() == 0) {
                System.out.println("Did not find fitting component for maze!");
                continue;
            }
            boolean allZero = true;
            for (MazeComponentPosition component : validComponents) {
                if (component.getComponent().field_76292_a <= 0) continue;
                allZero = false;
                break;
            }
            MazeComponentPosition generatingComponent = allZero ? (MazeComponentPosition)((Object)validComponents.get(rand.nextInt(validComponents.size()))) : (MazeComponentPosition)WeightedRandom.func_76271_a((Random)rand, validComponents);
            for (MazeRoom room : generatingComponent.getComponent().getRooms()) {
                MazePath[] neighbors;
                MazeRoom roomInMaze = generatingComponent.getPositionInMaze().add(room);
                maze.set((byte)3, roomInMaze);
                for (MazePath neighbor : neighbors = Maze.getNeighborPaths(maze.dimensions.length, roomInMaze)) {
                    if (maze.get(neighbor) != 0) continue;
                    maze.set((byte)2, neighbor);
                }
            }
            for (MazePath exit : generatingComponent.getComponent().getExitPaths()) {
                MazePath exitInMaze = exit.add(generatingComponent.getPositionInMaze());
                MazeRoom destRoom = exitInMaze.getDestinationRoom();
                MazeRoom srcRoom = exitInMaze.getSourceRoom();
                if (maze.get(destRoom) == 0) {
                    positionStack.push(destRoom);
                }
                if (maze.get(srcRoom) == 0) {
                    positionStack.push(srcRoom);
                }
                maze.set((byte)3, exitInMaze);
            }
            positions.add(generatingComponent);
        }
        return positions;
    }

    public static boolean canComponentBePlaced(Maze maze, MazeComponentPosition component) {
        for (MazeRoom room : component.getComponent().getRooms()) {
            MazePath[] roomNeighborPaths;
            MazeRoom roomInMaze = room.add(component.getPositionInMaze());
            byte curValue = maze.get(roomInMaze);
            if (curValue != 0) {
                return false;
            }
            for (MazePath roomNeighborPath : roomNeighborPaths = Maze.getNeighborPaths(maze.dimensions.length, roomInMaze)) {
                byte neighborValue = maze.get(roomNeighborPath);
                if (neighborValue != 3 || component.getComponent().getExitPaths().contains(roomNeighborPath.sub(component.getPositionInMaze()))) continue;
                return false;
            }
        }
        for (MazePath exit : component.getComponent().getExitPaths()) {
            byte curValue = maze.get(exit.add(component.getPositionInMaze()));
            if (curValue == 3 || curValue == 0 || curValue == 1) continue;
            return false;
        }
        return true;
    }
}

