/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.maze;

import ivorius.ivtoolkit.math.IvVecMathHelper;
import ivorius.ivtoolkit.maze.MazeCoordinate;
import ivorius.ivtoolkit.maze.MazeRoom;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class MazePath
implements MazeCoordinate,
Cloneable {
    public final MazeRoom sourceRoom;
    public int pathDimension;
    public boolean pathGoesUp;

    public MazePath(MazeRoom sourceRoom, int pathDimension, boolean pathGoesUp) {
        this.sourceRoom = sourceRoom;
        this.pathDimension = pathDimension;
        this.pathGoesUp = pathGoesUp;
    }

    public MazePath(int pathDimension, boolean pathGoesUp, int ... roomCoordinates) {
        this(new MazeRoom(roomCoordinates), pathDimension, pathGoesUp);
    }

    public MazePath(NBTTagCompound compound) {
        this.sourceRoom = new MazeRoom(compound.func_74775_l("source"));
        this.pathDimension = compound.func_74762_e("pathDimension");
        this.pathGoesUp = compound.func_74767_n("pathGoesUp");
    }

    public static MazePath pathFromSourceAndDest(MazeRoom source, MazeRoom dest) {
        for (int i = 0; i < source.coordinates.length; ++i) {
            if (source.coordinates[i] == dest.coordinates[i]) continue;
            return new MazePath(source, i, source.coordinates[i] < dest.coordinates[i]);
        }
        return null;
    }

    public MazePath invertPath() {
        return new MazePath(this.getDestinationRoom(), this.pathDimension, !this.pathGoesUp);
    }

    public int[] getPathDirection() {
        int[] direction = new int[this.sourceRoom.coordinates.length];
        direction[this.pathDimension] = this.pathGoesUp ? 1 : -1;
        return direction;
    }

    public MazeRoom getSourceRoom() {
        return this.sourceRoom;
    }

    public MazeRoom getDestinationRoom() {
        return new MazeRoom(IvVecMathHelper.add(this.sourceRoom.getCoordinates(), this.getPathDirection()));
    }

    public MazePath add(MazeRoom room) {
        return new MazePath(this.sourceRoom.add(room), this.pathDimension, this.pathGoesUp);
    }

    public MazePath sub(MazeRoom room) {
        return new MazePath(this.sourceRoom.sub(room), this.pathDimension, this.pathGoesUp);
    }

    protected MazePath clone() {
        return new MazePath(this.sourceRoom.clone(), this.pathDimension, this.pathGoesUp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MazePath mazePath = (MazePath)o;
        return this.pathDimension == mazePath.pathDimension && this.pathGoesUp == mazePath.pathGoesUp ? this.sourceRoom.equals(mazePath.sourceRoom) : this.invertPath().sourceRoom.equals(mazePath.sourceRoom);
    }

    public int hashCode() {
        int result = this.sourceRoom.hashCode();
        result = 31 * result + this.pathDimension;
        result = 31 * result + (this.pathGoesUp ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.getSourceRoom().toString() + " -> " + this.getDestinationRoom();
    }

    @Override
    public int[] getMazeCoordinates() {
        int[] coords = this.sourceRoom.getMazeCoordinates();
        int n = this.pathDimension;
        coords[n] = coords[n] + (this.pathGoesUp ? 1 : -1);
        return coords;
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("source", (NBTBase)this.sourceRoom.writeToNBT());
        compound.func_74768_a("pathDimension", this.pathDimension);
        compound.func_74757_a("pathGoesUp", this.pathGoesUp);
        return compound;
    }
}

