/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.rendering;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.vector.Matrix;
import org.lwjgl.util.vector.Matrix2f;
import org.lwjgl.util.vector.Matrix3f;
import org.lwjgl.util.vector.Matrix4f;

public class IvShaderInstance {
    public Logger logger;
    private int shaderID = 0;
    private int vertShader;
    private int fragShader = 0;
    private boolean shaderActive = false;
    private Map<String, Integer> uniformLocations = new HashMap<String, Integer>();

    public int getShaderID() {
        return this.shaderID;
    }

    public int getVertShader() {
        return this.vertShader;
    }

    public int getFragShader() {
        return this.fragShader;
    }

    public IvShaderInstance(Logger logger) {
        this.logger = logger;
    }

    public void trySettingUpShader(String vertexShaderFile, String fragmentShaderFile) {
        if (this.shaderID <= 0) {
            this.registerShader(vertexShaderFile, fragmentShaderFile);
        }
    }

    public void registerShader(String vertexShaderCode, String fragmentShaderCode) {
        this.deleteShader();
        try {
            if (vertexShaderCode != null) {
                this.vertShader = this.createShader(vertexShaderCode, 35633);
            }
            if (fragmentShaderCode != null) {
                this.fragShader = this.createShader(fragmentShaderCode, 35632);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return;
        }
        this.shaderID = ARBShaderObjects.glCreateProgramObjectARB();
        if (this.vertShader > 0) {
            ARBShaderObjects.glAttachObjectARB((int)this.shaderID, (int)this.vertShader);
        }
        if (this.fragShader > 0) {
            ARBShaderObjects.glAttachObjectARB((int)this.shaderID, (int)this.fragShader);
        }
        ARBShaderObjects.glLinkProgramARB((int)this.shaderID);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)this.shaderID, (int)35714) == 0) {
            this.logger.error(this.getLogInfo(this.shaderID));
            return;
        }
        ARBShaderObjects.glValidateProgramARB((int)this.shaderID);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)this.shaderID, (int)35715) == 0) {
            this.logger.error(this.getLogInfo(this.shaderID));
            return;
        }
    }

    private int createShader(String shaderCode, int shaderType) throws Exception {
        int shader = 0;
        try {
            shader = ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)shaderCode);
            ARBShaderObjects.glCompileShaderARB((int)shader);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35713) == 0) {
                throw new RuntimeException("Error creating shader: " + this.getLogInfo(shader));
            }
            return shader;
        }
        catch (Exception exc) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
            throw exc;
        }
    }

    public boolean useShader() {
        if (this.shaderID <= 0 && !this.shaderActive) {
            return false;
        }
        this.shaderActive = true;
        ARBShaderObjects.glUseProgramObjectARB((int)this.shaderID);
        return true;
    }

    public void stopUsingShader() {
        if (this.shaderID <= 0 && this.shaderActive) {
            return;
        }
        ARBShaderObjects.glUseProgramObjectARB((int)0);
        this.shaderActive = false;
    }

    public boolean isShaderActive() {
        return this.shaderActive;
    }

    public boolean setUniformInts(String key, int ... ints) {
        return this.setUniformIntsOfType(key, ints.length, ints);
    }

    public boolean setUniformIntsOfType(String key, int typeLength, int ... ints) {
        if (this.shaderID <= 0 || !this.shaderActive) {
            return false;
        }
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)ints.length);
        intBuffer.put(ints);
        intBuffer.position(0);
        if (typeLength == 1) {
            ARBShaderObjects.glUniform1ARB((int)this.getUniformLocation(key), (IntBuffer)intBuffer);
        } else if (typeLength == 2) {
            ARBShaderObjects.glUniform2ARB((int)this.getUniformLocation(key), (IntBuffer)intBuffer);
        } else if (typeLength == 3) {
            ARBShaderObjects.glUniform3ARB((int)this.getUniformLocation(key), (IntBuffer)intBuffer);
        } else if (typeLength == 4) {
            ARBShaderObjects.glUniform4ARB((int)this.getUniformLocation(key), (IntBuffer)intBuffer);
        } else {
            throw new IllegalArgumentException();
        }
        return true;
    }

    public boolean setUniformFloats(String key, float ... floats) {
        return this.setUniformFloatsOfType(key, floats.length, floats);
    }

    public boolean setUniformFloatsOfType(String key, int typeLength, float ... floats) {
        if (this.shaderID <= 0 || !this.shaderActive) {
            return false;
        }
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer((int)floats.length);
        floatBuffer.put(floats);
        floatBuffer.position(0);
        if (typeLength == 1) {
            ARBShaderObjects.glUniform1ARB((int)this.getUniformLocation(key), (FloatBuffer)floatBuffer);
        } else if (typeLength == 2) {
            ARBShaderObjects.glUniform2ARB((int)this.getUniformLocation(key), (FloatBuffer)floatBuffer);
        } else if (typeLength == 3) {
            ARBShaderObjects.glUniform3ARB((int)this.getUniformLocation(key), (FloatBuffer)floatBuffer);
        } else if (typeLength == 4) {
            ARBShaderObjects.glUniform4ARB((int)this.getUniformLocation(key), (FloatBuffer)floatBuffer);
        } else {
            throw new IllegalArgumentException();
        }
        return true;
    }

    public boolean setUniformMatrix(String key, Matrix matrix) {
        int width;
        if (this.shaderID <= 0 || !this.shaderActive) {
            return false;
        }
        if (matrix instanceof Matrix2f) {
            width = 2;
        } else if (matrix instanceof Matrix3f) {
            width = 3;
        } else if (matrix instanceof Matrix4f) {
            width = 4;
        } else {
            throw new IllegalArgumentException();
        }
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer((int)(width * width));
        matrix.store(floatBuffer);
        floatBuffer.position(0);
        switch (width) {
            case 2: {
                ARBShaderObjects.glUniformMatrix2ARB((int)this.getUniformLocation(key), (boolean)false, (FloatBuffer)floatBuffer);
                break;
            }
            case 3: {
                ARBShaderObjects.glUniformMatrix3ARB((int)this.getUniformLocation(key), (boolean)false, (FloatBuffer)floatBuffer);
                break;
            }
            default: {
                ARBShaderObjects.glUniformMatrix4ARB((int)this.getUniformLocation(key), (boolean)false, (FloatBuffer)floatBuffer);
            }
        }
        return true;
    }

    public Integer getUniformLocation(String key) {
        if (this.shaderID <= 0) {
            return 0;
        }
        if (!this.uniformLocations.containsKey(key)) {
            this.uniformLocations.put(key, ARBShaderObjects.glGetUniformLocationARB((int)this.shaderID, (CharSequence)key));
        }
        return this.uniformLocations.get(key);
    }

    private String getLogInfo(int obj) {
        return ARBShaderObjects.glGetInfoLogARB((int)obj, (int)ARBShaderObjects.glGetObjectParameteriARB((int)obj, (int)35716));
    }

    public void deleteShader() {
        if (this.shaderActive) {
            this.stopUsingShader();
        }
        if (this.fragShader > 0) {
            ARBShaderObjects.glDetachObjectARB((int)this.shaderID, (int)this.fragShader);
            ARBShaderObjects.glDeleteObjectARB((int)this.fragShader);
            this.fragShader = 0;
        }
        if (this.vertShader > 0) {
            ARBShaderObjects.glDetachObjectARB((int)this.shaderID, (int)this.vertShader);
            ARBShaderObjects.glDeleteObjectARB((int)this.vertShader);
            this.vertShader = 0;
        }
        if (this.shaderID > 0) {
            ARBShaderObjects.glDeleteObjectARB((int)this.shaderID);
            this.shaderID = 0;
        }
        this.uniformLocations.clear();
    }

    public static void outputShaderInfo(Logger logger) {
        String majorVersion;
        String minorVersion;
        String glslVersion;
        ContextCapabilities cap = GLContext.getCapabilities();
        String renderer = GL11.glGetString((int)7937);
        String vendor = GL11.glGetString((int)7936);
        String version = GL11.glGetString((int)7938);
        boolean fboSupported = cap.GL_EXT_framebuffer_object;
        try {
            glslVersion = GL11.glGetString((int)35724);
        }
        catch (Exception ex) {
            glslVersion = "? (No GL20)";
        }
        try {
            minorVersion = "" + GL11.glGetInteger((int)33308);
            majorVersion = "" + GL11.glGetInteger((int)33307);
        }
        catch (Exception ex) {
            minorVersion = "?";
            majorVersion = "? (No GL 30)";
        }
        IvShaderInstance.printAlignedInfo("Vendor", vendor, logger);
        IvShaderInstance.printAlignedInfo("Renderer", renderer, logger);
        IvShaderInstance.printAlignedInfo("Version", version, logger);
        IvShaderInstance.printAlignedInfo("Versions", IvShaderInstance.getGLVersions(cap), logger);
        IvShaderInstance.printAlignedInfo("Version Range", String.format("%s - %s", minorVersion, majorVersion), logger);
        IvShaderInstance.printAlignedInfo("GLSL Version", glslVersion, logger);
        IvShaderInstance.printAlignedInfo("Frame buffer object", fboSupported ? "Supported" : "Unsupported", logger);
    }

    private static void printAlignedInfo(String category, String info, Logger logger) {
        logger.info(String.format("%-20s: %s", category, info));
    }

    private static String getGLVersions(ContextCapabilities cap) {
        String versions = "";
        try {
            if (cap.OpenGL11) {
                versions = versions + ":11";
            }
            if (cap.OpenGL12) {
                versions = versions + ":12";
            }
            if (cap.OpenGL13) {
                versions = versions + ":13";
            }
            if (cap.OpenGL14) {
                versions = versions + ":14";
            }
            if (cap.OpenGL15) {
                versions = versions + ":15";
            }
        }
        catch (Throwable throwable) {
            versions = versions + ":lwjgl-Error-1";
        }
        try {
            if (cap.OpenGL20) {
                versions = versions + ":20";
            }
            if (cap.OpenGL21) {
                versions = versions + ":21";
            }
        }
        catch (Throwable throwable) {
            versions = versions + ":lwjgl-Error-2";
        }
        try {
            if (cap.OpenGL30) {
                versions = versions + ":30";
            }
            if (cap.OpenGL31) {
                versions = versions + ":31";
            }
            if (cap.OpenGL32) {
                versions = versions + ":32";
            }
            if (cap.OpenGL33) {
                versions = versions + ":33";
            }
        }
        catch (Throwable throwable) {
            versions = versions + ":lwjgl-Error-3";
        }
        if (versions.length() > 0) {
            versions = versions.substring(1);
        }
        return versions;
    }
}

