/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.blocks;

import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.tools.IvCollections;
import ivorius.reccomplex.blocks.GeneratingTileEntity;
import ivorius.reccomplex.worldgen.StructureHandler;
import ivorius.reccomplex.worldgen.StructureInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityStructureGenerator
extends TileEntity
implements GeneratingTileEntity {
    private List<String> structureNames = new ArrayList<String>();
    private BlockCoord structureShift = new BlockCoord(0, 0, 0);
    private Integer structureRotation;
    private Boolean structureMirror;

    public List<String> getStructureNames() {
        return Collections.unmodifiableList(this.structureNames);
    }

    public void setStructureNames(List<String> structureNames) {
        IvCollections.setContentsOfList(this.structureNames, structureNames);
    }

    public BlockCoord getStructureShift() {
        return this.structureShift;
    }

    public void setStructureShift(BlockCoord structureShift) {
        this.structureShift = structureShift;
    }

    public Integer getStructureRotation() {
        return this.structureRotation;
    }

    public void setStructureRotation(Integer structureRotation) {
        this.structureRotation = structureRotation;
    }

    public Boolean getStructureMirror() {
        return this.structureMirror;
    }

    public void setStructureMirror(Boolean structureMirror) {
        this.structureMirror = structureMirror;
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.readStructureDataFromNBT(nbtTagCompound);
    }

    public void readStructureDataFromNBT(NBTTagCompound nbtTagCompound) {
        IvCollections.setContentsOfList(this.structureNames, TileEntityStructureGenerator.generatorsFromNBT(nbtTagCompound));
        this.structureShift = BlockCoord.readCoordFromNBT("structureShift", nbtTagCompound);
        this.structureRotation = nbtTagCompound.func_74764_b("structureRotation") ? Integer.valueOf(nbtTagCompound.func_74762_e("structureRotation")) : null;
        this.structureMirror = nbtTagCompound.func_74764_b("structureMirror") ? Boolean.valueOf(nbtTagCompound.func_74767_n("structureMirror")) : null;
    }

    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        this.writeStructureDataToNBT(nbtTagCompound);
    }

    public void writeStructureDataToNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList structureNBTList = new NBTTagList();
        for (String struc : this.structureNames) {
            structureNBTList.func_74742_a((NBTBase)new NBTTagString(struc));
        }
        nbtTagCompound.func_74782_a("structures", (NBTBase)structureNBTList);
        BlockCoord.writeCoordToNBT("structureShift", this.structureShift, nbtTagCompound);
        if (this.structureRotation != null) {
            nbtTagCompound.func_74768_a("structureRotation", this.structureRotation.intValue());
        }
        if (this.structureMirror != null) {
            nbtTagCompound.func_74757_a("structureMirror", this.structureMirror.booleanValue());
        }
    }

    @Override
    public void generate(World world, Random random, AxisAlignedTransform2D transform, int layer) {
        String structure;
        StructureInfo structureInfo;
        world.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.structureNames.size() > 0 && (structureInfo = StructureHandler.getStructure(structure = this.structureNames.get(random.nextInt(this.structureNames.size())))) != null) {
            int strucRotation;
            int n = structureInfo.isRotatable() ? (this.structureRotation != null ? transform.getRotation() + this.structureRotation : random.nextInt(4)) : (strucRotation = 0);
            boolean strucMirror = structureInfo.isMirrorable() && (this.structureMirror != null ? transform.isMirrorX() != this.structureMirror.booleanValue() : random.nextBoolean());
            AxisAlignedTransform2D strucTransform = AxisAlignedTransform2D.transform(strucRotation, strucMirror);
            structureInfo.generate(world, random, new BlockCoord(this.field_145851_c + this.structureShift.x, this.field_145848_d + this.structureShift.y, this.field_145849_e + this.structureShift.z), strucTransform, layer);
        }
    }

    public static List<String> generatorsFromNBT(NBTTagCompound nbtTagCompound) {
        ArrayList<String> list = new ArrayList<String>();
        NBTTagList structureNBTList = nbtTagCompound.func_150295_c("structures", 8);
        for (int i = 0; i < structureNBTList.func_74745_c(); ++i) {
            list.add(structureNBTList.func_150307_f(i));
        }
        return list;
    }
}

