/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editmazeblock;

import ivorius.ivtoolkit.maze.MazeComponent;
import ivorius.ivtoolkit.maze.MazePath;
import ivorius.ivtoolkit.maze.MazeRoom;
import ivorius.ivtoolkit.tools.IvCollections;
import ivorius.reccomplex.gui.GuiValidityStateIndicator;
import ivorius.reccomplex.gui.editmazeblock.TableDataSourceMazePath;
import ivorius.reccomplex.gui.editmazeblock.TableDataSourceMazeRoom;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementButton;
import ivorius.reccomplex.gui.table.TableElementInteger;
import ivorius.reccomplex.gui.table.TableElementPropertyDefault;
import ivorius.reccomplex.gui.table.TableElementPropertyListener;
import ivorius.reccomplex.gui.table.TableElementString;
import ivorius.reccomplex.gui.table.TableElementTitle;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.worldgen.StructureHandler;
import java.util.Arrays;

public class TableDataSourceMazeComponent
extends TableDataSourceSegmented
implements TableElementPropertyListener,
TableElementButton.Listener {
    private MazeComponent mazeComponent;
    private TableDelegate tableDelegate;
    private TableNavigator tableNavigator;

    public TableDataSourceMazeComponent(MazeComponent mazeComponent, TableDelegate tableDelegate, TableNavigator tableNavigator) {
        this.mazeComponent = mazeComponent;
        this.tableDelegate = tableDelegate;
        this.tableNavigator = tableNavigator;
    }

    public MazeComponent getMazeComponent() {
        return this.mazeComponent;
    }

    public void setMazeComponent(MazeComponent mazeComponent) {
        this.mazeComponent = mazeComponent;
    }

    public TableDelegate getTableDelegate() {
        return this.tableDelegate;
    }

    public void setTableDelegate(TableDelegate tableDelegate) {
        this.tableDelegate = tableDelegate;
    }

    public TableNavigator getTableNavigator() {
        return this.tableNavigator;
    }

    public void setTableNavigator(TableNavigator tableNavigator) {
        this.tableNavigator = tableNavigator;
    }

    @Override
    public int numberOfSegments() {
        return 7;
    }

    @Override
    public int sizeOfSegment(int segment) {
        if (segment == 0) {
            return 2;
        }
        if (segment == 1 || segment == 3 || segment == 4 || segment == 6) {
            return 1;
        }
        if (segment == 2) {
            return this.mazeComponent.getRooms().size();
        }
        if (segment == 5) {
            return this.mazeComponent.getExitPaths().size();
        }
        return 0;
    }

    @Override
    public TableElement elementForIndexInSegment(GuiTable table, int index, int segment) {
        if (segment == 0) {
            if (index == 0) {
                TableElementString element = new TableElementString("structure", "Structure", this.mazeComponent.getIdentifier());
                element.addPropertyListener(this);
                element.setShowsValidityState(true);
                element.setValidityState(this.currentComponentIDState());
                return element;
            }
            if (index == 1) {
                TableElementInteger element = new TableElementInteger("weight", "Weight", this.mazeComponent.field_76292_a, 0, 500);
                element.addPropertyListener(this);
                return element;
            }
        } else {
            if (segment == 1) {
                return new TableElementTitle("roomsTitle", "", "Rooms");
            }
            if (segment == 2) {
                MazeRoom room = this.mazeComponent.getRooms().get(index);
                boolean canEdit = index > 0 || room.coordinates[0] != 0 || room.coordinates[1] != 0 || room.coordinates[2] != 0;
                String title = "Room " + Arrays.toString(room.coordinates);
                TableElementButton element = new TableElementButton("room" + index, title, new TableElementButton.Action("edit", "Edit", canEdit), new TableElementButton.Action("delete", "Delete", canEdit));
                element.addListener(this);
                return element;
            }
            if (segment == 3) {
                TableElementButton element = new TableElementButton("addRoom", "Add Room", new TableElementButton.Action("add", "Add"));
                element.addListener(this);
                return element;
            }
            if (segment == 4) {
                return new TableElementTitle("exitsTitle", "", "Exits");
            }
            if (segment == 5) {
                MazePath exit = this.mazeComponent.getExitPaths().get(index);
                String title = "Exit " + Arrays.toString(exit.getDestinationRoom().coordinates);
                TableElementButton element = new TableElementButton("exit" + index, title, new TableElementButton.Action("edit", "Edit"), new TableElementButton.Action("delete", "Delete"));
                element.addListener(this);
                return element;
            }
            if (segment == 6) {
                TableElementButton element = new TableElementButton("addExit", "Add Exit", new TableElementButton.Action("add", "Add"));
                element.addListener(this);
                return element;
            }
        }
        return null;
    }

    @Override
    public void valueChanged(TableElementPropertyDefault element) {
        if ("structure".equals(element.getID())) {
            this.mazeComponent.setIdentifier((String)element.getPropertyValue());
            ((TableElementString)element).setValidityState(this.currentComponentIDState());
        } else if ("weight".equals(element.getID())) {
            this.mazeComponent.field_76292_a = (Integer)element.getPropertyValue();
        }
    }

    private GuiValidityStateIndicator.State currentComponentIDState() {
        return StructureHandler.getAllStructureNames().contains(this.mazeComponent.getIdentifier()) ? GuiValidityStateIndicator.State.VALID : GuiValidityStateIndicator.State.INVALID;
    }

    @Override
    public void actionPerformed(TableElementButton tableElementButton, String actionID) {
        if ("addRoom".equals(tableElementButton.getID())) {
            MazeRoom newRoom = new MazeRoom(0, 0, 0);
            this.mazeComponent.setRooms(IvCollections.modifiableCopyWith(this.mazeComponent.getRooms(), newRoom));
            this.tableDelegate.reloadData();
            this.tableNavigator.pushTable(new GuiTable(this.tableDelegate, new TableDataSourceMazeRoom(newRoom)));
        } else if ("addExit".equals(tableElementButton.getID())) {
            MazePath newExit = new MazePath(0, false, 0, 0, 0);
            this.mazeComponent.setExitPaths(IvCollections.modifiableCopyWith(this.mazeComponent.getExitPaths(), newExit));
            this.tableDelegate.reloadData();
            this.tableNavigator.pushTable(new GuiTable(this.tableDelegate, new TableDataSourceMazePath(newExit)));
        } else if (tableElementButton.getID().startsWith("room")) {
            int index = Integer.valueOf(tableElementButton.getID().substring(4));
            if (actionID.equals("edit")) {
                this.tableNavigator.pushTable(new GuiTable(this.tableDelegate, new TableDataSourceMazeRoom(this.mazeComponent.getRooms().get(index))));
            } else if (actionID.equals("delete")) {
                this.mazeComponent.setRooms(IvCollections.modifiableCopyWithout(this.mazeComponent.getRooms(), index));
                this.tableDelegate.reloadData();
            }
        } else if (tableElementButton.getID().startsWith("exit")) {
            int index = Integer.valueOf(tableElementButton.getID().substring(4));
            if (actionID.equals("edit")) {
                this.tableNavigator.pushTable(new GuiTable(this.tableDelegate, new TableDataSourceMazePath(this.mazeComponent.getExitPaths().get(index))));
            } else if (actionID.equals("delete")) {
                this.mazeComponent.setExitPaths(IvCollections.modifiableCopyWithout(this.mazeComponent.getExitPaths(), index));
                this.tableDelegate.reloadData();
            }
        }
    }
}

