/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure;

import ivorius.reccomplex.gui.editstructure.TableDataSourceBTNatural;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementInteger;
import ivorius.reccomplex.gui.table.TableElementPropertyDefault;
import ivorius.reccomplex.gui.table.TableElementPropertyListener;
import ivorius.reccomplex.gui.table.TableElementString;
import ivorius.reccomplex.worldgen.blockTransformers.BlockTransformerReplace;
import java.util.ArrayList;
import net.minecraft.block.Block;

public class TableDataSourceBTReplace
implements TableDataSource,
TableElementPropertyListener {
    private BlockTransformerReplace blockTransformer;

    public TableDataSourceBTReplace(BlockTransformerReplace blockTransformer) {
        this.blockTransformer = blockTransformer;
    }

    public BlockTransformerReplace getBlockTransformer() {
        return this.blockTransformer;
    }

    public void setBlockTransformer(BlockTransformerReplace blockTransformer) {
        this.blockTransformer = blockTransformer;
    }

    @Override
    public boolean has(GuiTable table, int index) {
        return index >= 0 && index < 4;
    }

    @Override
    public TableElement elementForIndex(GuiTable table, int index) {
        if (index == 0) {
            TableElementString element = new TableElementString("sourceID", "Source Block", Block.field_149771_c.func_148750_c((Object)this.blockTransformer.sourceBlock));
            element.setShowsValidityState(true);
            TableDataSourceBTNatural.setStateForBlockTextfield(element);
            element.addPropertyListener(this);
            return element;
        }
        if (index == 1) {
            TableElementInteger element = new TableElementInteger("sourceMeta", "Source Metadata", this.blockTransformer.sourceMetadata, 0, 16);
            element.addPropertyListener(this);
            return element;
        }
        if (index == 2) {
            TableElementString element = new TableElementString("destID", "Dest Block", Block.field_149771_c.func_148750_c((Object)this.blockTransformer.destBlock));
            element.setShowsValidityState(true);
            TableDataSourceBTNatural.setStateForBlockTextfield(element);
            element.addPropertyListener(this);
            return element;
        }
        if (index == 3) {
            TableElementString element = new TableElementString("destMeta", "Dest Metadatas (Hex)", TableDataSourceBTReplace.byteArrayToHexString(this.blockTransformer.destMetadata));
            element.addPropertyListener(this);
            return element;
        }
        return null;
    }

    public static String byteArrayToHexString(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (byte aByte : bytes) {
            builder.append(String.format("%01X", aByte));
        }
        return builder.toString();
    }

    public static byte[] hexStringToByteArray(String string) {
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        for (int i = 0; i < string.length(); ++i) {
            char aChar = string.charAt(i);
            byte aByte = (byte)Character.digit(aChar, 16);
            if (aByte < 0) continue;
            bytes.add(aByte);
        }
        byte[] byteArray = new byte[bytes.size()];
        for (int i = 0; i < bytes.size(); ++i) {
            byteArray[i] = (Byte)bytes.get(i);
        }
        return byteArray;
    }

    @Override
    public void valueChanged(TableElementPropertyDefault element) {
        if ("sourceID".equals(element.getID())) {
            this.blockTransformer.sourceBlock = (Block)Block.field_149771_c.func_82594_a(element.getPropertyValue());
            TableDataSourceBTNatural.setStateForBlockTextfield((TableElementString)element);
        } else if ("sourceMeta".equals(element.getID())) {
            this.blockTransformer.sourceMetadata = (Integer)element.getPropertyValue();
        } else if ("destID".equals(element.getID())) {
            this.blockTransformer.destBlock = (Block)Block.field_149771_c.func_82594_a(element.getPropertyValue());
            TableDataSourceBTNatural.setStateForBlockTextfield((TableElementString)element);
        } else if ("destMeta".equals(element.getID())) {
            String propValue = (String)element.getPropertyValue();
            this.blockTransformer.destMetadata = TableDataSourceBTReplace.hexStringToByteArray(propValue);
            String newString = TableDataSourceBTReplace.byteArrayToHexString(this.blockTransformer.destMetadata);
            if (!propValue.equalsIgnoreCase(newString)) {
                element.setPropertyValue(newString);
            }
        }
    }
}

