/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure;

import ivorius.reccomplex.gui.GuiValidityStateIndicator;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementBoolean;
import ivorius.reccomplex.gui.table.TableElementInteger;
import ivorius.reccomplex.gui.table.TableElementPropertyDefault;
import ivorius.reccomplex.gui.table.TableElementPropertyListener;
import ivorius.reccomplex.gui.table.TableElementString;
import ivorius.reccomplex.worldgen.genericStructures.BiomeGenerationInfo;
import net.minecraft.world.biome.BiomeGenBase;

public class TableDataSourceBiomeGen
implements TableDataSource,
TableElementPropertyListener {
    private BiomeGenerationInfo generationInfo;
    private TableDelegate tableDelegate;

    public TableDataSourceBiomeGen(BiomeGenerationInfo generationInfo, TableDelegate tableDelegate) {
        this.generationInfo = generationInfo;
        this.tableDelegate = tableDelegate;
    }

    @Override
    public boolean has(GuiTable table, int index) {
        return index >= 0 && index < 3;
    }

    @Override
    public TableElement elementForIndex(GuiTable table, int index) {
        if (index == 0) {
            TableElementString element = new TableElementString("biomeID", "Biome ID", this.generationInfo.getBiomeID());
            element.setShowsValidityState(true);
            element.setValidityState(this.currentBiomeIDState());
            element.addPropertyListener(this);
            return element;
        }
        if (index == 1) {
            TableElementBoolean element = new TableElementBoolean("defaultWeight", "Use Default Weight", this.generationInfo.hasDefaultWeight());
            element.addPropertyListener(this);
            return element;
        }
        if (index == 2) {
            TableElementInteger element = new TableElementInteger("weight", "Weight", this.generationInfo.getActiveGenerationWeight(), 0, 500);
            element.setEnabled(!this.generationInfo.hasDefaultWeight());
            element.addPropertyListener(this);
            return element;
        }
        return null;
    }

    @Override
    public void valueChanged(TableElementPropertyDefault element) {
        if ("biomeID".equals(element.getID())) {
            this.generationInfo.setBiomeID((String)element.getPropertyValue());
            ((TableElementString)element).setValidityState(this.currentBiomeIDState());
        } else if ("defaultWeight".equals(element.getID())) {
            boolean useDefault = (Boolean)element.getPropertyValue();
            this.generationInfo.setGenerationWeight(useDefault ? null : Integer.valueOf(this.generationInfo.getActiveGenerationWeight()));
            this.tableDelegate.reloadData();
        } else if ("weight".equals(element.getID())) {
            this.generationInfo.setGenerationWeight((Integer)element.getPropertyValue());
        }
    }

    private GuiValidityStateIndicator.State currentBiomeIDState() {
        BiomeGenBase[] biomes;
        if (this.generationInfo.getBiomeTypes() != null) {
            return GuiValidityStateIndicator.State.VALID;
        }
        String biomeID = this.generationInfo.getBiomeID();
        for (BiomeGenBase biome : biomes = BiomeGenBase.func_150565_n()) {
            if (biome == null || !biome.field_76791_y.equals(biomeID)) continue;
            return GuiValidityStateIndicator.State.VALID;
        }
        return biomeID.trim().length() > 0 ? GuiValidityStateIndicator.State.SEMI_VALID : GuiValidityStateIndicator.State.INVALID;
    }
}

