/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table;

import ivorius.reccomplex.gui.table.Bounds;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableElementButton;
import ivorius.reccomplex.gui.table.TableElementDefault;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiButton;

public class TableElementPresetAction
extends TableElementDefault {
    private GuiButton changePresetButton;
    private GuiButton runActionButton;
    private String currentActionID;
    private String actionTitle;
    private TableElementButton.Action[] actions;
    private List<Listener> listeners = new ArrayList<Listener>();

    public TableElementPresetAction(String id, String title, String actionTitle, TableElementButton.Action ... actions) {
        super(id, title);
        this.actionTitle = actionTitle;
        this.actions = actions;
        this.currentActionID = actions[0].id;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public List<Listener> listeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public TableElementButton.Action[] getActions() {
        return this.actions;
    }

    @Override
    public void initGui(GuiTable screen) {
        super.initGui(screen);
        Bounds bounds = this.bounds();
        int curIndex = this.currentActionIndex();
        String title = curIndex >= 0 ? this.actions[curIndex].title : this.currentActionID;
        this.changePresetButton = new GuiButton(-1, bounds.getMinX(), bounds.getMinY() + (bounds.getHeight() - 20) / 2, bounds.getWidth() / 2 - 2, 20, title);
        this.changePresetButton.field_146125_m = !this.isHidden();
        screen.addButton(this, 0, this.changePresetButton);
        this.runActionButton = new GuiButton(-1, bounds.getCenterX(), bounds.getMinY() + (bounds.getHeight() - 20) / 2, bounds.getWidth() / 2, 20, this.actionTitle);
        this.runActionButton.field_146125_m = !this.isHidden();
        screen.addButton(this, 1, this.runActionButton);
        this.setActionButtonActive();
    }

    @Override
    public void setHidden(boolean hidden) {
        super.setHidden(hidden);
        if (this.changePresetButton != null) {
            boolean bl = this.changePresetButton.field_146125_m = !hidden;
        }
        if (this.runActionButton != null) {
            this.runActionButton.field_146125_m = !hidden;
        }
    }

    @Override
    public void buttonClicked(int buttonID) {
        super.buttonClicked(buttonID);
        if (buttonID == 0) {
            TableElementButton.Action newAction = this.actions[(this.currentActionIndex() + 1) % this.actions.length];
            this.currentActionID = newAction.id;
            this.changePresetButton.field_146126_j = newAction.title;
            this.setActionButtonActive();
        } else if (buttonID == 1) {
            for (Listener listener : this.listeners) {
                listener.actionPerformed(this, this.currentActionID);
            }
        }
    }

    private int currentActionIndex() {
        int currentIndex = -1;
        for (int i = 0; i < this.actions.length; ++i) {
            TableElementButton.Action action = this.actions[i];
            if (!action.id.equals(this.currentActionID)) continue;
            currentIndex = i;
        }
        return currentIndex;
    }

    private void setActionButtonActive() {
        if (this.runActionButton != null) {
            int currentActionIndex = this.currentActionIndex();
            this.runActionButton.field_146124_l = currentActionIndex >= 0 && this.actions[currentActionIndex].enabled;
        }
    }

    public static interface Listener {
        public void actionPerformed(TableElementPresetAction var1, String var2);
    }
}

