/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.random;

import com.google.common.io.LineReader;
import ivorius.ivtoolkit.tools.IvFileHelper;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.random.Person;
import ivorius.reccomplex.random.Place;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public class Poem {
    public static final List<String> sentencePatterns = Arrays.asList("As the <10> are, the <10> <4> <7>.", "All the <10> <3> <6>, so <5> the <10>.", "<9>! We <4> the <1> and the <2>, why not <5>?", "What is the <6> <2> to <7> <3> the <1>?", "To <3>, we <4>. To <3>, we <4>.", "With <2>, one can <5> oh so <7>...", "Why do the <10> <3> <2> so <7>?", "They <3> to <3>.", "Is <2> really <6> like <2>?", "Could you <3> it so <7>?", "The <2> of <lownum> <10>", "We <4> to <3>.", "When <1> <4>,", "Sometimes <6> and always <6>.", "<9>! <2>, the <6> <2>.", "The <6> <1> <7> <3>s a <1>.", "<7> <6>, <10> <7> <3> a <6> <1>.", "<10> <4> the <1> <8> the <6> <2>, <7> but <7>.", "<1> and <1>, <9>, <9>! <10> like the <2>.", "<10> <5> and <8> them <2> <5>s!", "Only the <1> <5>s as a <6> <1>.", "<10> -- <6> <10>!", "<2> is a <6> <1> <8> <2> and <2>.", "<9> <10>...", "<9>!", "We <5>, but only for a while,", "<7>, <7>, <7>.", "And <5> <7>, ", "I will <3> <8> the <10>", "But when the <10> <5>", "When do <10> become <10>?", "<7>, <10> <5>", "Count the <10>, <3> the <2>.", "How does the <1> not <5>?", "Although it's now more <6> and less <6>.", "Yet there's <2> <8> the <2>s and the <10>.", "<10> <4> <10> like <6> <10> <5>.", "Why did the <1> <3> it, to <3> the <2>?", "<2>, <2>, and ever <2>.", "Where was the <6> <2> then?", "<2> like <highnum> <10>", "Where did our <2> go? When did we lose the <2>?", "<10>, <10>, <10> - Those are our true <2>.", "<8> or <8>, how <2> <5>s on.", "<5> <7> like a <6> <1> <8> <2>.", "Where is the <6> <1>, the <6> <2> now?", "What is <2> after all...", "They never <3> the <10> nor the <10>, with <2>.", "<5 r>, <name>! <5 r>!", "No <1> is <6>, no <1> is <6>.", "Oh so <6>", "<name>", "<name> is <6>", "Ever to <3> a <1>, it <4> a <1>.", "<name> is <6 r>, oh so <6 r>", "So <6>", "<name>!", "<name r>! Oh, <name r>!", "<name>! It is you!", "<5>, <name>!", "We <4> the <place> before we <4> <2>.", "<3> the <place> <8> you, <name>!", "<9>, how the <place> <7> <5>s", "<lownum> <10>", "<highnum> <10>", "<hugenum> <10>", "<lownum> <10> <5> <7>", "<highnum> <10> <5> <7>", "<hugenum> <10> <5> <7>");
    public static final Map<String, Theme> themes = new HashMap<String, Theme>();
    private String title;
    private String text;

    public Poem(String title, String text) {
        this.title = title;
        this.text = text;
    }

    public static void registerThemes(String modid, String ... themeNames) {
        for (String name : themeNames) {
            Theme theme = Theme.themeFromMod(new ResourceLocation(modid, "poemThemes/" + name + ".txt"));
            if (theme == null) continue;
            themes.put(name, theme);
        }
    }

    public static Poem randomPoem(Random random) {
        return Poem.randomPoem(random, Poem.getRandomElementFrom(Arrays.asList(themes.values().toArray(new Theme[themes.size()])), random));
    }

    public static Poem randomPoem(Random random, Theme theme) {
        PoemContext poemContext = new PoemContext();
        while (poemContext.add(random, poemContext.names, 0.3f, Person.randomHuman(random, random.nextBoolean()).getFirstName())) {
        }
        while (poemContext.add(random, poemContext.places, 0.3f, Place.randomPlace(random).getFullPlaceType())) {
        }
        String title = Poem.getRandomPhrase(random, theme, sentencePatterns, poemContext).trim();
        char titleLastChar = title.charAt(title.length() - 1);
        if (titleLastChar == '.' || titleLastChar == ',' || titleLastChar == ';') {
            title = title.substring(0, title.length() - 1);
        }
        StringBuilder poem = new StringBuilder();
        int verses = random.nextInt(5) + 1;
        for (int verse = 0; verse < verses; ++verse) {
            int lines = random.nextInt(10) + 1;
            for (int line = 0; line < lines; ++line) {
                char phraseLastChar;
                String phrase = Poem.getRandomPhrase(random, theme, sentencePatterns, poemContext);
                if (line == lines - 1 && ((phraseLastChar = phrase.charAt(phrase.length() - 1)) == ',' || phraseLastChar == ';')) {
                    phrase = phrase.substring(0, phrase.length() - 1) + ".";
                }
                poem.append(phrase).append("\n");
            }
            poem.append("\n");
        }
        return new Poem(title, poem.toString());
    }

    private static String getRandomPhrase(Random random, Theme theme, List<String> sentencePatterns, PoemContext poemContext) {
        return Poem.firstCharUppercase(Poem.replaceAllWords(random, Poem.getRandomElementFrom(sentencePatterns, random), theme, poemContext));
    }

    private static String replaceAllWords(Random random, String text, Theme theme, PoemContext poemContext) {
        StringBuilder builder = new StringBuilder(text);
        Poem.replaceAll(random, builder, "10", theme.concreteNounsPlural);
        Poem.replaceAll(random, builder, "1", theme.concreteNouns);
        Poem.replaceAll(random, builder, "2", theme.abstractNouns);
        Poem.replaceAll(random, builder, "3", theme.transitivePresentVerbs);
        Poem.replaceAll(random, builder, "4", theme.transitivePastVerbs);
        Poem.replaceAll(random, builder, "5", theme.intransitivePresentVerbs);
        Poem.replaceAll(random, builder, "6", theme.adjectives);
        Poem.replaceAll(random, builder, "7", theme.adverbs);
        Poem.replaceAll(random, builder, "8", theme.prepositions);
        Poem.replaceAll(random, builder, "9", theme.interjections);
        Poem.replaceAll(random, builder, "name", poemContext.names);
        Poem.replaceAll(random, builder, "place", poemContext.places);
        Poem.replaceAllWithNums(random, builder, "lownum", 2, 10, 1);
        Poem.replaceAllWithNums(random, builder, "highnum", 2, 10, 10);
        Poem.replaceAllWithNums(random, builder, "hugenum", 1, 10, 1000);
        return builder.toString();
    }

    private static void replaceAll(Random random, StringBuilder builder, String tag, List<String> words) {
        int index;
        String repeatWord = null;
        while ((index = builder.indexOf("<" + tag)) >= 0) {
            int endIndex = builder.indexOf(">", index);
            if (builder.charAt(endIndex - 1) == 'r') {
                if (repeatWord == null) {
                    repeatWord = Poem.getRandomElementFrom(words, random);
                }
                builder.replace(index, endIndex + 1, repeatWord);
                continue;
            }
            builder.replace(index, endIndex + 1, Poem.getRandomElementFrom(words, random));
        }
    }

    private static void replaceAllWithNums(Random random, StringBuilder builder, String tag, int min, int max, int mul) {
        int index;
        String repeatWord = null;
        while ((index = builder.indexOf("<" + tag)) >= 0) {
            int endIndex = builder.indexOf(">", index);
            if (builder.charAt(endIndex - 1) == 'r') {
                if (repeatWord == null) {
                    repeatWord = String.valueOf((random.nextInt(max - min + 1) + min) * mul);
                }
                builder.replace(index, endIndex + 1, repeatWord);
                continue;
            }
            builder.replace(index, endIndex + 1, String.valueOf((random.nextInt(max - min + 1) + min) * mul));
        }
    }

    private static String firstCharUppercase(String name) {
        return Character.toString(name.charAt(0)).toUpperCase() + name.substring(1);
    }

    private static <O> O getRandomElementFrom(List<O> list, Random random) {
        return list.get(random.nextInt(list.size()));
    }

    public String getTitle() {
        return this.title;
    }

    public String getText() {
        return this.text;
    }

    private static class PoemContext {
        public List<String> names = new ArrayList<String>();
        public List<String> places = new ArrayList<String>();

        private PoemContext() {
        }

        public boolean add(Random random, List<String> list, float continueChance, String value) {
            list.add(value);
            return random.nextFloat() < continueChance;
        }
    }

    public static class Theme {
        public List<String> concreteNouns = new ArrayList<String>();
        public List<String> concreteNounsPlural = new ArrayList<String>();
        public List<String> abstractNouns = new ArrayList<String>();
        public List<String> transitivePresentVerbs = new ArrayList<String>();
        public List<String> transitivePastVerbs = new ArrayList<String>();
        public List<String> intransitivePresentVerbs = new ArrayList<String>();
        public List<String> adjectives = new ArrayList<String>();
        public List<String> adverbs = new ArrayList<String>();
        public List<String> prepositions = new ArrayList<String>();
        public List<String> interjections = new ArrayList<String>();

        public static Theme themeFromMod(ResourceLocation resourceLocation) {
            try {
                return Theme.themeFromFile(IOUtils.toString((InputStream)IvFileHelper.inputStreamFromResourceLocation(resourceLocation), (String)"UTF-8"));
            }
            catch (IOException e) {
                RecurrentComplex.logger.error((Object)e);
                return null;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static Theme themeFromFile(String fileContents) {
            Theme theme = new Theme();
            LineReader reader = new LineReader((Readable)new StringReader(fileContents));
            List<String> currentList = null;
            try {
                String line;
                block26: while ((line = reader.readLine()) != null) {
                    if (line.startsWith("***")) {
                        String tag;
                        switch (tag = line.substring(4).trim()) {
                            case "Concrete Nouns": {
                                currentList = theme.concreteNouns;
                                continue block26;
                            }
                            case "Concrete Nouns Plural": {
                                currentList = theme.concreteNounsPlural;
                                continue block26;
                            }
                            case "Abstract Nouns": {
                                currentList = theme.abstractNouns;
                                continue block26;
                            }
                            case "Present Transitive Verbs": {
                                currentList = theme.transitivePresentVerbs;
                                continue block26;
                            }
                            case "Past Transitive Verbs": {
                                currentList = theme.transitivePastVerbs;
                                continue block26;
                            }
                            case "Present Intransitive Verbs": {
                                currentList = theme.intransitivePresentVerbs;
                                continue block26;
                            }
                            case "Adjectives": {
                                currentList = theme.adjectives;
                                continue block26;
                            }
                            case "Adverbs": {
                                currentList = theme.adverbs;
                                continue block26;
                            }
                            case "Prepositions": {
                                currentList = theme.prepositions;
                                continue block26;
                            }
                            case "Interjections": {
                                currentList = theme.interjections;
                                continue block26;
                            }
                        }
                        currentList = null;
                        continue;
                    }
                    String word = line.trim();
                    if (word.length() <= 0 || currentList == null) continue;
                    currentList.add(word);
                }
            }
            catch (IOException e) {
                RecurrentComplex.logger.error((Object)e);
            }
            Theme.assertContents(theme.concreteNouns);
            Theme.assertContents(theme.abstractNouns);
            Theme.assertContents(theme.transitivePresentVerbs);
            Theme.assertContents(theme.transitivePastVerbs);
            Theme.assertContents(theme.intransitivePresentVerbs);
            Theme.assertContents(theme.adjectives);
            Theme.assertContents(theme.adverbs);
            Theme.assertContents(theme.prepositions);
            Theme.assertContents(theme.interjections);
            return theme;
        }

        private static void assertContents(List<String> list) {
            if (list.size() == 0) {
                list.add("MISSING");
            }
        }
    }
}

