/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.worldgen;

import ivorius.ivtoolkit.tools.IvFileHelper;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.worldgen.StructureHandler;
import ivorius.reccomplex.worldgen.genericStructures.GenericStructureInfo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FilenameUtils;

public class StructureSaveHandler {
    private static List<String> importedGenerators = new ArrayList<String>();

    public static void reloadAllCustomStructures() {
        while (!importedGenerators.isEmpty()) {
            StructureHandler.removeStructure(importedGenerators.remove(0));
        }
        File structuresFile = IvFileHelper.getValidatedFolder(RecurrentComplex.proxy.getBaseFolderFile("structures"));
        if (structuresFile != null) {
            File silentStructuresFile;
            File genericStructuresFile = IvFileHelper.getValidatedFolder(structuresFile, "genericStructures");
            if (genericStructuresFile != null) {
                StructureSaveHandler.addAllStructuresInFolder(genericStructuresFile, true);
            }
            if ((silentStructuresFile = IvFileHelper.getValidatedFolder(structuresFile, "silentStructures")) != null) {
                StructureSaveHandler.addAllStructuresInFolder(silentStructuresFile, false);
            }
        }
    }

    public static void addAllStructuresInFolder(File folder, boolean generating) {
        File[] strucFiles = folder.listFiles();
        if (strucFiles != null) {
            for (File strucFile : strucFiles) {
                String[] structureNamePointer = new String[1];
                GenericStructureInfo genericStructureInfo = StructureSaveHandler.readGenericStructure(strucFile, structureNamePointer);
                if (genericStructureInfo == null) continue;
                StructureHandler.registerStructure(genericStructureInfo, structureNamePointer[0], generating);
                importedGenerators.add(structureNamePointer[0]);
            }
        }
    }

    public static boolean saveGenericStructure(GenericStructureInfo info, String structureName) {
        File structuresFolder = RecurrentComplex.proxy.getBaseFolderFile("structures");
        File parent = IvFileHelper.getValidatedFolder(structuresFolder, "silentStructures");
        if (parent != null) {
            String json = StructureHandler.createJSONFromStructure(info);
            File newFile = new File(parent, structureName + ".zip");
            boolean failed = false;
            try {
                ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(newFile));
                ZipEntry jsonEntry = new ZipEntry("structure.json");
                zipOutputStream.putNextEntry(jsonEntry);
                byte[] jsonBytes = json.getBytes();
                jsonEntry.setSize(jsonBytes.length);
                zipOutputStream.write(jsonBytes);
                zipOutputStream.closeEntry();
                ZipEntry worldDataEntry = new ZipEntry("worldData.nbt");
                zipOutputStream.putNextEntry(worldDataEntry);
                byte[] worldDataBytes = CompressedStreamTools.func_74798_a((NBTTagCompound)info.worldDataCompound);
                worldDataEntry.setSize(worldDataBytes.length);
                zipOutputStream.write(worldDataBytes);
                zipOutputStream.closeEntry();
                zipOutputStream.close();
            }
            catch (Exception ex) {
                RecurrentComplex.logger.error("Could not write structure to zip file", (Throwable)ex);
                failed = true;
            }
            return !failed && newFile.exists();
        }
        return false;
    }

    public static GenericStructureInfo readGenericStructure(File file, String[] structureNamePointer) {
        String fullFileName = file.getName();
        if (structureNamePointer != null) {
            structureNamePointer[0] = FilenameUtils.getBaseName((String)fullFileName);
        }
        String ext = FilenameUtils.getExtension((String)fullFileName);
        if (file.isFile() && "zip".equals(ext)) {
            ZipInputStream zipInputStream = null;
            try {
                zipInputStream = new ZipInputStream(new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            if (zipInputStream != null) {
                return StructureSaveHandler.structureInfoFromZip(zipInputStream, fullFileName);
            }
        }
        return null;
    }

    public static GenericStructureInfo structureInfoFromResource(ResourceLocation resourceLocation) {
        try {
            return StructureSaveHandler.structureInfoFromZip(new ZipInputStream(IvFileHelper.inputStreamFromResourceLocation(resourceLocation)), resourceLocation.toString());
        }
        catch (Exception ex) {
            RecurrentComplex.logger.error("Could not read generic structure " + resourceLocation.toString(), (Throwable)ex);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GenericStructureInfo structureInfoFromZip(ZipInputStream zipInputStream, String fullFileName) {
        String json = null;
        NBTTagCompound worldData = null;
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                byte[] bytes = StructureSaveHandler.completeByteArray(zipInputStream);
                if (bytes != null) {
                    if ("structure.json".equals(zipEntry.getName())) {
                        json = new String(bytes);
                    } else if ("worldData.nbt".equals(zipEntry.getName())) {
                        worldData = CompressedStreamTools.func_152457_a((byte[])bytes, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
                    }
                }
                zipInputStream.closeEntry();
            }
            zipInputStream.close();
            if (json != null) {
                GenericStructureInfo genericStructureInfo = StructureHandler.createStructureFromJSON(json);
                if (worldData != null) {
                    genericStructureInfo.worldDataCompound = worldData;
                }
                if (genericStructureInfo.worldDataCompound != null) return genericStructureInfo;
                RecurrentComplex.logger.error("Structure file '" + fullFileName + "' does not contain worldData.nbt");
                return null;
            } else {
                RecurrentComplex.logger.error("Structure file '" + fullFileName + "' does not contain structure.json");
            }
            return null;
        }
        catch (Exception ex) {
            RecurrentComplex.logger.error("Could not read structure from zip file", (Throwable)ex);
        }
        return null;
    }

    public static byte[] completeByteArray(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int aByte;
            while ((aByte = inputStream.read()) >= 0) {
                byteArrayOutputStream.write(aByte);
            }
        }
        catch (Exception ignored) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }
}

