/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.worldgen.genericStructures;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.tools.IvGsonHelper;
import ivorius.reccomplex.json.JsonUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeGenerationInfo {
    private String biomeID;
    private Integer generationWeight;

    public BiomeGenerationInfo(String biomeID, Integer generationWeight) {
        this.biomeID = biomeID;
        this.generationWeight = generationWeight;
    }

    public static List<BiomeGenerationInfo> overworldBiomeGenerationList() {
        return Arrays.asList(new BiomeGenerationInfo("Type:NETHER", 0), new BiomeGenerationInfo("Type:END", 0), new BiomeGenerationInfo("Type:WATER", 0), new BiomeGenerationInfo("Type:PLAINS", null), new BiomeGenerationInfo("Type:FOREST", null), new BiomeGenerationInfo("Type:MOUNTAIN", null), new BiomeGenerationInfo("Type:HILLS", null), new BiomeGenerationInfo("Type:SWAMP", null), new BiomeGenerationInfo("Type:SANDY", null), new BiomeGenerationInfo("Type:MESA", null), new BiomeGenerationInfo("Type:SAVANNA", null), new BiomeGenerationInfo("Type:WASTELAND", null), new BiomeGenerationInfo("Type:MUSHROOM", null), new BiomeGenerationInfo("Type:JUNGLE", null));
    }

    public static List<BiomeGenerationInfo> undergroundBiomeGenerationList() {
        return Arrays.asList(new BiomeGenerationInfo("Type:NETHER", 0), new BiomeGenerationInfo("Type:END", 0), new BiomeGenerationInfo("Type:PLAINS", null), new BiomeGenerationInfo("Type:FOREST", null), new BiomeGenerationInfo("Type:MOUNTAIN", null), new BiomeGenerationInfo("Type:HILLS", null), new BiomeGenerationInfo("Type:SWAMP", null), new BiomeGenerationInfo("Type:SANDY", null), new BiomeGenerationInfo("Type:MESA", null), new BiomeGenerationInfo("Type:SAVANNA", null), new BiomeGenerationInfo("Type:RIVER", null), new BiomeGenerationInfo("Type:OCEAN", null), new BiomeGenerationInfo("Type:WASTELAND", null), new BiomeGenerationInfo("Type:MUSHROOM", null), new BiomeGenerationInfo("Type:JUNGLE", null));
    }

    public static List<BiomeGenerationInfo> oceanBiomeGenerationList() {
        return Arrays.asList(new BiomeGenerationInfo("Type:NETHER", 0), new BiomeGenerationInfo("Type:END", 0), new BiomeGenerationInfo("Type:OCEAN,SNOWY", 0), new BiomeGenerationInfo("Type:OCEAN", null));
    }

    public String getBiomeID() {
        return this.biomeID;
    }

    public void setBiomeID(String biomeID) {
        this.biomeID = biomeID;
    }

    public Integer getGenerationWeight() {
        return this.generationWeight;
    }

    public void setGenerationWeight(Integer generationWeight) {
        this.generationWeight = generationWeight;
    }

    public int getActiveGenerationWeight() {
        return this.generationWeight != null ? this.generationWeight : 100;
    }

    public boolean hasDefaultWeight() {
        return this.generationWeight == null;
    }

    public List<BiomeDictionary.Type> getBiomeTypes() {
        if (this.biomeID.startsWith("Type:")) {
            String[] typeIDs = this.biomeID.substring(5).split(",");
            ArrayList<BiomeDictionary.Type> types = new ArrayList<BiomeDictionary.Type>(typeIDs.length);
            for (String typeID : typeIDs) {
                BiomeDictionary.Type type = (BiomeDictionary.Type)IvGsonHelper.enumForNameIgnoreCase((String)typeID, (Enum[])BiomeDictionary.Type.values());
                if (type == null) {
                    return null;
                }
                types.add(type);
            }
            return types;
        }
        return null;
    }

    public static Set<BiomeGenBase> gatherAllBiomes() {
        HashSet<BiomeGenBase> set = new HashSet<BiomeGenBase>();
        for (BiomeGenBase biomeGenBase : BiomeGenBase.func_150565_n()) {
            if (biomeGenBase == null) continue;
            set.add(biomeGenBase);
        }
        for (BiomeGenBase biomeGenBase : BiomeDictionary.Type.values()) {
            Collections.addAll(set, BiomeDictionary.getBiomesForType((BiomeDictionary.Type)biomeGenBase));
        }
        return set;
    }

    public static class Serializer
    implements JsonDeserializer<BiomeGenerationInfo>,
    JsonSerializer<BiomeGenerationInfo> {
        public BiomeGenerationInfo deserialize(JsonElement jsonElement, Type par2Type, JsonDeserializationContext context) {
            JsonObject jsonobject = JsonUtils.getJsonElementAsJsonObject(jsonElement, "generationInfo");
            String biomeID = JsonUtils.getJsonObjectStringFieldValue(jsonobject, "biome");
            Integer weight = jsonobject.has("weight") ? Integer.valueOf(JsonUtils.getJsonObjectIntegerFieldValue(jsonobject, "weight")) : null;
            return new BiomeGenerationInfo(biomeID, weight);
        }

        public JsonElement serialize(BiomeGenerationInfo generationInfo, Type par2Type, JsonSerializationContext context) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("biome", generationInfo.getBiomeID());
            Integer weight = generationInfo.getGenerationWeight();
            if (weight != null) {
                jsonobject.addProperty("weight", (Number)weight);
            }
            return jsonobject;
        }
    }
}

