/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.worldgen.genericStructures;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import cpw.mods.fml.common.Loader;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.tools.IvWorldData;
import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.blocks.GeneratingTileEntity;
import ivorius.reccomplex.blocks.RCBlocks;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.json.NbtToJson;
import ivorius.reccomplex.worldgen.MCRegistrySpecial;
import ivorius.reccomplex.worldgen.StructureHandler;
import ivorius.reccomplex.worldgen.StructureInfo;
import ivorius.reccomplex.worldgen.blockTransformers.BlockTransformer;
import ivorius.reccomplex.worldgen.blockTransformers.BlockTransformerNatural;
import ivorius.reccomplex.worldgen.blockTransformers.BlockTransformerNaturalAir;
import ivorius.reccomplex.worldgen.blockTransformers.BlockTransformerNegativeSpace;
import ivorius.reccomplex.worldgen.genericStructures.BiomeGenerationInfo;
import ivorius.reccomplex.worldgen.genericStructures.GenerationYSelector;
import ivorius.reccomplex.worldgen.inventory.InventoryGenerationHandler;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.RecurrentComplexEntityAccessor;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class GenericStructureInfo
implements StructureInfo,
Cloneable {
    public static final int LATEST_VERSION = 1;
    public static final int MAX_GENERATING_LAYERS = 30;
    public NBTTagCompound worldDataCompound;
    public List<BiomeGenerationInfo> generationWeights = new ArrayList<BiomeGenerationInfo>();
    public List<BlockTransformer> blockTransformers = new ArrayList<BlockTransformer>();
    public GenerationYSelector ySelector;
    public boolean rotatable;
    public boolean mirrorable;
    public String generationCategory;
    public List<String> dependencies = new ArrayList<String>();

    public static GenericStructureInfo createDefaultStructure() {
        GenericStructureInfo genericStructureInfo = new GenericStructureInfo();
        genericStructureInfo.generationWeights.addAll(BiomeGenerationInfo.overworldBiomeGenerationList());
        genericStructureInfo.generationCategory = "decoration";
        genericStructureInfo.ySelector = new GenerationYSelector(GenerationYSelector.SelectionMode.SURFACE, 0, 0);
        genericStructureInfo.rotatable = false;
        genericStructureInfo.mirrorable = false;
        genericStructureInfo.blockTransformers.add(new BlockTransformerNaturalAir(RCBlocks.negativeSpace, 1));
        genericStructureInfo.blockTransformers.add(new BlockTransformerNegativeSpace(RCBlocks.negativeSpace, 0));
        genericStructureInfo.blockTransformers.add(new BlockTransformerNatural(RCBlocks.naturalFloor, 0));
        return genericStructureInfo;
    }

    @Override
    public int generationY(World world, Random random, int x, int z) {
        return this.ySelector.generationY(world, random, x, z, this.structureBoundingBox());
    }

    @Override
    public int[] structureBoundingBox() {
        IvBlockCollection collection = new IvWorldData((NBTTagCompound)this.worldDataCompound, null, (MCRegistry)MCRegistrySpecial.INSTANCE).blockCollection;
        return new int[]{collection.width, collection.height, collection.length};
    }

    @Override
    public boolean isRotatable() {
        return this.rotatable;
    }

    @Override
    public boolean isMirrorable() {
        return this.mirrorable;
    }

    @Override
    public void generate(World world, Random random, BlockCoord coord, AxisAlignedTransform2D transform, int layer) {
        this.generate(world, random, coord, layer, transform, false);
    }

    @Override
    public void generateSource(World world, Random random, BlockCoord coord, int layer, AxisAlignedTransform2D transform) {
        this.generate(world, random, coord, layer, transform, true);
    }

    private void generate(World world, Random random, BlockCoord origin, int layer, AxisAlignedTransform2D transform, boolean asSource) {
        Block block;
        IvWorldData worldData = new IvWorldData(this.worldDataCompound, world, MCRegistrySpecial.INSTANCE);
        IvBlockCollection blockCollection = worldData.blockCollection;
        int[] size = new int[]{blockCollection.width, blockCollection.height, blockCollection.length};
        ArrayList<GeneratingTileEntity> generatingTileEntities = new ArrayList<GeneratingTileEntity>();
        HashMap<BlockCoord, TileEntity> tileEntities = new HashMap<BlockCoord, TileEntity>();
        for (TileEntity tileEntity : worldData.tileEntities) {
            tileEntities.put(new BlockCoord(tileEntity), tileEntity);
        }
        if (!asSource) {
            for (BlockTransformer transformer : this.blockTransformers) {
                if (!transformer.generatesInPhase(BlockTransformer.Phase.BEFORE)) continue;
                for (BlockCoord sourceCoord : blockCollection) {
                    byte meta;
                    BlockCoord worldCoord = transform.apply(sourceCoord, size).add(origin);
                    block = blockCollection.getBlock(sourceCoord);
                    if (!transformer.matches(block, meta = blockCollection.getMetadata(sourceCoord))) continue;
                    transformer.apply(world, random, BlockTransformer.Phase.BEFORE, worldCoord, block, meta, worldData);
                }
            }
        }
        for (int pass = 0; pass < 2; ++pass) {
            for (BlockCoord sourceCoord : blockCollection) {
                Block block2 = blockCollection.getBlock(sourceCoord);
                byte meta = blockCollection.getMetadata(sourceCoord);
                BlockCoord worldPos = transform.apply(sourceCoord, size).add(origin);
                if (pass != this.getPass(block2, meta) || !asSource && this.transformer(block2, meta) != null) continue;
                world.func_147465_d(worldPos.x, worldPos.y, worldPos.z, block2, (int)meta, 2);
                TileEntity tileEntity = (TileEntity)tileEntities.get(sourceCoord);
                if (tileEntity != null) {
                    world.func_72921_c(worldPos.x, worldPos.y, worldPos.z, (int)meta, 2);
                    tileEntity.field_145851_c = worldPos.x;
                    tileEntity.field_145848_d = worldPos.y;
                    tileEntity.field_145849_e = worldPos.z;
                    world.func_147455_a(worldPos.x, worldPos.y, worldPos.z, tileEntity);
                    tileEntity.func_145836_u();
                    if (!asSource) {
                        if (tileEntity instanceof IInventory) {
                            IInventory inventory = (IInventory)tileEntity;
                            InventoryGenerationHandler.generateAllTags(inventory, random);
                        }
                        if (tileEntity instanceof GeneratingTileEntity) {
                            generatingTileEntities.add((GeneratingTileEntity)tileEntity);
                        }
                    }
                }
                transform.rotateBlock(world, worldPos, block2);
            }
        }
        if (!asSource) {
            for (BlockTransformer transformer : this.blockTransformers) {
                if (!transformer.generatesInPhase(BlockTransformer.Phase.AFTER)) continue;
                for (BlockCoord sourceCoord : blockCollection) {
                    byte meta;
                    BlockCoord worldCoord = transform.apply(sourceCoord, size).add(origin);
                    block = blockCollection.getBlock(sourceCoord);
                    if (!transformer.matches(block, meta = blockCollection.getMetadata(sourceCoord))) continue;
                    transformer.apply(world, random, BlockTransformer.Phase.AFTER, worldCoord, block, meta, worldData);
                }
            }
        }
        List<Entity> entities = worldData.entities;
        for (Entity entity : entities) {
            entity.resetEntityId();
            RecurrentComplexEntityAccessor.resetEntityUUID(entity);
            double[] newEntityPos = transform.apply(new double[]{entity.field_70165_t, entity.field_70163_u, entity.field_70161_v}, size);
            entity.func_70107_b(newEntityPos[0] + (double)origin.x, newEntityPos[1] + (double)origin.y, newEntityPos[2] + (double)origin.z);
            world.func_72838_d(entity);
        }
        if (layer < 30) {
            for (GeneratingTileEntity generatingTileEntity : generatingTileEntities) {
                generatingTileEntity.generate(world, random, transform, layer + 1);
            }
        } else {
            RecurrentComplex.logger.warn("Structure generated with over 30 layers; most likely infinite loop!");
        }
    }

    private int getPass(Block block, int metadata) {
        return block.func_149721_r() || block.func_149688_o() == Material.field_151579_a ? 0 : 1;
    }

    private BlockTransformer transformer(Block block, int metadata) {
        for (BlockTransformer transformer : this.blockTransformers) {
            if (!transformer.matches(block, metadata)) continue;
            return transformer;
        }
        return null;
    }

    @Override
    public int generationWeightInBiome(BiomeGenBase biome) {
        for (BiomeGenerationInfo generationInfo : this.generationWeights) {
            int genWeight = generationInfo.getActiveGenerationWeight();
            String generationBiomeID = generationInfo.getBiomeID();
            if (generationBiomeID.equals(biome.field_76791_y)) {
                return genWeight;
            }
            List<BiomeDictionary.Type> types = generationInfo.getBiomeTypes();
            if (types == null || !GenericStructureInfo.isBiomeAllTypes(biome, types)) continue;
            return genWeight;
        }
        return 0;
    }

    private static boolean isBiomeAllTypes(BiomeGenBase biomeGenBase, List<BiomeDictionary.Type> types) {
        for (BiomeDictionary.Type type : types) {
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomeGenBase, (BiomeDictionary.Type)type)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String generationCategory() {
        return this.generationCategory;
    }

    @Override
    public GenericStructureInfo copyAsGenericStructureInfo() {
        return (GenericStructureInfo)this.clone();
    }

    @Override
    public boolean areDependenciesResolved() {
        for (String mod : this.dependencies) {
            if (Loader.isModLoaded((String)mod)) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        GenericStructureInfo genericStructureInfo = StructureHandler.createStructureFromJSON(StructureHandler.createJSONFromStructure(this));
        genericStructureInfo.worldDataCompound = (NBTTagCompound)this.worldDataCompound.func_74737_b();
        return genericStructureInfo;
    }

    public static class Serializer
    implements JsonDeserializer<GenericStructureInfo>,
    JsonSerializer<GenericStructureInfo> {
        public GenericStructureInfo deserialize(JsonElement jsonElement, Type par2Type, JsonDeserializationContext context) {
            Integer version;
            JsonObject jsonobject = JsonUtils.getJsonElementAsJsonObject(jsonElement, "status");
            GenericStructureInfo structureInfo = new GenericStructureInfo();
            if (jsonobject.has("version")) {
                version = JsonUtils.getJsonObjectIntegerFieldValue(jsonobject, "version");
            } else {
                version = 1;
                RecurrentComplex.logger.warn("Structure JSON missing 'version', using latest (" + this.getClass() + ")");
            }
            if (jsonobject.has("generationBiomes")) {
                JsonArray generationBiomes = JsonUtils.getJsonObjectJsonArrayField(jsonobject, "generationBiomes");
                for (JsonElement generationElement : generationBiomes) {
                    BiomeGenerationInfo genInfo = (BiomeGenerationInfo)context.deserialize(generationElement, BiomeGenerationInfo.class);
                    structureInfo.generationWeights.add(genInfo);
                }
            } else {
                RecurrentComplex.logger.warn("Structure JSON missing 'generationBiomes'!");
            }
            if (jsonobject.has("blockTransformers")) {
                JsonArray blockTransformers = JsonUtils.getJsonObjectJsonArrayField(jsonobject, "blockTransformers");
                for (JsonElement transformerElement : blockTransformers) {
                    BlockTransformer transformer = (BlockTransformer)context.deserialize(transformerElement, BlockTransformer.class);
                    structureInfo.blockTransformers.add(transformer);
                }
            }
            if (jsonobject.has("generationY")) {
                structureInfo.ySelector = (GenerationYSelector)context.deserialize(jsonobject.get("generationY"), GenerationYSelector.class);
            } else {
                RecurrentComplex.logger.warn("Structure JSON missing 'generationY'! Using 'surface'!");
                structureInfo.ySelector = new GenerationYSelector(GenerationYSelector.SelectionMode.SURFACE, 0, 0);
            }
            structureInfo.rotatable = JsonUtils.getJsonObjectBooleanFieldValueOrDefault(jsonobject, "rotatable", false);
            structureInfo.mirrorable = JsonUtils.getJsonObjectBooleanFieldValueOrDefault(jsonobject, "mirrorable", false);
            structureInfo.generationCategory = JsonUtils.getJsonObjectStringFieldValue(jsonobject, "generationCategory");
            if (jsonobject.has("dependencies")) {
                JsonArray dependencyArray = JsonUtils.getJsonObjectJsonArrayField(jsonobject, "dependencies");
                for (JsonElement element : dependencyArray) {
                    structureInfo.dependencies.add(JsonUtils.getJsonElementStringValue(element, "dependency"));
                }
            }
            if (jsonobject.has("worldData")) {
                structureInfo.worldDataCompound = (NBTTagCompound)context.deserialize(jsonobject.get("worldData"), NBTTagCompound.class);
            } else if (jsonobject.has("worldDataBase64")) {
                structureInfo.worldDataCompound = NbtToJson.getNBTFromBase64(JsonUtils.getJsonObjectStringFieldValue(jsonobject, "worldDataBase64"));
            }
            return structureInfo;
        }

        public JsonElement serialize(GenericStructureInfo structureInfo, Type par2Type, JsonSerializationContext context) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("version", (Number)1);
            JsonArray generationBiomes = new JsonArray();
            for (BiomeGenerationInfo info : structureInfo.generationWeights) {
                generationBiomes.add(context.serialize((Object)info));
            }
            jsonobject.add("generationBiomes", (JsonElement)generationBiomes);
            if (structureInfo.blockTransformers.size() > 0) {
                JsonArray blockTransformers = new JsonArray();
                for (BlockTransformer transformer : structureInfo.blockTransformers) {
                    blockTransformers.add(context.serialize((Object)transformer, BlockTransformer.class));
                }
                jsonobject.add("blockTransformers", (JsonElement)blockTransformers);
            }
            jsonobject.add("generationY", context.serialize((Object)structureInfo.ySelector, GenerationYSelector.class));
            jsonobject.addProperty("rotatable", Boolean.valueOf(structureInfo.rotatable));
            jsonobject.addProperty("mirrorable", Boolean.valueOf(structureInfo.mirrorable));
            jsonobject.addProperty("generationCategory", structureInfo.generationCategory);
            if (structureInfo.dependencies.size() > 0) {
                JsonArray dependencyArray = new JsonArray();
                for (String s : structureInfo.dependencies) {
                    dependencyArray.add(context.serialize((Object)s));
                }
                jsonobject.add("dependencies", (JsonElement)dependencyArray);
            }
            return jsonobject;
        }
    }
}

