/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.tools;

import ivorius.ivtoolkit.math.IvBytePacker;
import ivorius.ivtoolkit.tools.MCRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.potion.PotionEffect;

public class IvNBTHelper {
    public static double[] readDoubleArray(String key, NBTTagCompound compound) {
        if (compound.func_74764_b(key)) {
            NBTTagList list = compound.func_150295_c(key, 6);
            double[] array = new double[list.func_74745_c()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = list.func_150309_d(i);
            }
            return array;
        }
        return null;
    }

    public static void writeDoubleArray(String key, double[] array, NBTTagCompound compound) {
        if (array != null) {
            NBTTagList list = new NBTTagList();
            for (double d : array) {
                list.func_74742_a((NBTBase)new NBTTagDouble(d));
            }
            compound.func_74782_a(key, (NBTBase)list);
        }
    }

    public static String[] readNBTStrings(String id, NBTTagCompound compound) {
        if (compound.func_74764_b(id)) {
            NBTTagList nbtTagList = compound.func_150295_c(id, 8);
            String[] strings = new String[nbtTagList.func_74745_c()];
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = nbtTagList.func_150307_f(i);
            }
            return strings;
        }
        return null;
    }

    public static void writeNBTStrings(String id, String[] strings, NBTTagCompound compound) {
        if (strings != null) {
            NBTTagList nbtTagList = new NBTTagList();
            for (String s : strings) {
                nbtTagList.func_74742_a((NBTBase)new NBTTagString(s));
            }
            compound.func_74782_a(id, (NBTBase)nbtTagList);
        }
    }

    public static String[][] readNBTStrings2D(String id, NBTTagCompound compound) {
        if (compound.func_74764_b(id)) {
            NBTTagList nbtTagList = compound.func_150295_c(id, 10);
            String[][] strings = new String[nbtTagList.func_74745_c()][];
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = IvNBTHelper.readNBTStrings("Strings", nbtTagList.func_150305_b(i));
            }
            return strings;
        }
        return null;
    }

    public static void writeNBTStrings2D(String id, String[][] strings, NBTTagCompound compound) {
        if (strings != null) {
            NBTTagList nbtTagList = new NBTTagList();
            for (String[] s : strings) {
                NBTTagCompound compound1 = new NBTTagCompound();
                IvNBTHelper.writeNBTStrings("Strings", s, compound1);
                nbtTagList.func_74742_a((NBTBase)compound1);
            }
            compound.func_74782_a(id, (NBTBase)nbtTagList);
        }
    }

    public static ItemStack[] readNBTStacks(String id, NBTTagCompound compound) {
        if (compound.func_74764_b(id)) {
            NBTTagList nbtTagList = compound.func_150295_c(id, 10);
            ItemStack[] itemStacks = new ItemStack[nbtTagList.func_74745_c()];
            for (int i = 0; i < itemStacks.length; ++i) {
                itemStacks[i] = ItemStack.func_77949_a((NBTTagCompound)nbtTagList.func_150305_b(i));
            }
            return itemStacks;
        }
        return null;
    }

    public static void writeNBTStacks(String id, ItemStack[] stacks, NBTTagCompound compound) {
        if (stacks != null) {
            NBTTagList nbtTagList = new NBTTagList();
            for (ItemStack stack : stacks) {
                NBTTagCompound tagCompound = new NBTTagCompound();
                stack.func_77955_b(tagCompound);
                nbtTagList.func_74742_a((NBTBase)tagCompound);
            }
            compound.func_74782_a(id, (NBTBase)nbtTagList);
        }
    }

    public static Block[] readNBTBlocks(String id, NBTTagCompound compound, MCRegistry registry) {
        if (compound.func_74764_b(id)) {
            NBTTagList nbtTagList = compound.func_150295_c(id, 8);
            Block[] blocks = new Block[nbtTagList.func_74745_c()];
            for (int i = 0; i < blocks.length; ++i) {
                blocks[i] = registry.blockFromID(nbtTagList.func_150307_f(i));
            }
            return blocks;
        }
        return null;
    }

    public static void writeNBTBlocks(String id, Block[] blocks, NBTTagCompound compound) {
        if (blocks != null) {
            NBTTagList nbtTagList = new NBTTagList();
            for (Block b : blocks) {
                nbtTagList.func_74742_a((NBTBase)new NBTTagString(Block.field_149771_c.func_148750_c((Object)b)));
            }
            compound.func_74782_a(id, (NBTBase)nbtTagList);
        }
    }

    public static long[] readNBTLongs(String id, NBTTagCompound compound) {
        if (compound.func_74764_b(id)) {
            NBTTagList nbtTagList = compound.func_150295_c(id, 3);
            long[] longs = new long[nbtTagList.func_74745_c()];
            for (int i = 0; i < longs.length; ++i) {
                int[] parts = nbtTagList.func_150306_c(i);
                longs[i] = (long)parts[0] + ((long)parts[1] << 32);
            }
            return longs;
        }
        return null;
    }

    public static void writeNBTLongs(String id, long[] longs, NBTTagCompound compound) {
        if (longs != null) {
            NBTTagList nbtTagList = new NBTTagList();
            for (long l : longs) {
                nbtTagList.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{(int)l, (int)(l >>> 32)}));
            }
            compound.func_74782_a(id, (NBTBase)nbtTagList);
        }
    }

    public static PotionEffect[] readNBTPotions(String id, NBTTagCompound compound) {
        if (compound.func_74764_b(id)) {
            NBTTagList nbtTagList = compound.func_150295_c(id, 8);
            PotionEffect[] potions = new PotionEffect[nbtTagList.func_74745_c()];
            for (int i = 0; i < potions.length; ++i) {
                potions[i] = PotionEffect.func_82722_b((NBTTagCompound)nbtTagList.func_150305_b(i));
            }
            return potions;
        }
        return null;
    }

    public static void writeNBTPotions(String id, PotionEffect[] potions, NBTTagCompound compound) {
        if (potions != null) {
            NBTTagList nbtTagList = new NBTTagList();
            for (PotionEffect p : potions) {
                nbtTagList.func_74742_a((NBTBase)p.func_82719_a(new NBTTagCompound()));
            }
            compound.func_74782_a(id, (NBTBase)nbtTagList);
        }
    }

    public static int[] readIntArrayFixedSize(String id, int length, NBTTagCompound compound) {
        int[] array = compound.func_74759_k(id);
        return array.length != length ? new int[length] : array;
    }

    public static void writeCompressed(String idBase, int[] intArray, int maxValueInArray, NBTTagCompound compound) {
        byte bitLength = IvBytePacker.getRequiredBitLength(maxValueInArray);
        byte[] bytes = IvBytePacker.packValues(intArray, bitLength);
        compound.func_74773_a(idBase + "_bytes", bytes);
        compound.func_74774_a(idBase + "_bitLength", bitLength);
        compound.func_74768_a(idBase + "_length", intArray.length);
    }

    public static int[] readCompressed(String idBase, NBTTagCompound compound) {
        byte[] bytes = compound.func_74770_j(idBase + "_bytes");
        byte bitLength = compound.func_74771_c(idBase + "_bitLength");
        int intArrayLength = compound.func_74762_e(idBase + "_length");
        return IvBytePacker.unpackValues(bytes, bitLength, intArrayLength);
    }
}

