/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands;

import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.reccomplex.blocks.RCBlocks;
import ivorius.reccomplex.commands.CommandSelectModify;
import ivorius.reccomplex.entities.StructureEntityInfo;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CommandSelectNatural
extends CommandSelectModify {
    public String func_71517_b() {
        return "selectNatural";
    }

    public String func_71518_a(ICommandSender var1) {
        return "commands.selectNatural.usage";
    }

    @Override
    public void processCommandSelection(EntityPlayerMP player, StructureEntityInfo structureEntityInfo, BlockCoord point1, BlockCoord point2, String[] args) {
        World world = player.func_130014_f_();
        BlockArea area = new BlockArea(point1, point2);
        double expandFloor = args.length >= 1 ? CommandSelectNatural.func_82363_b((ICommandSender)player, (String)args[0]) : 1.0;
        CommandSelectNatural.placeNaturalFloor(world, area, expandFloor);
        CommandSelectNatural.placeNaturalAir(world, area);
    }

    public List func_71516_a(ICommandSender commandSender, String[] args) {
        if (args.length == 1) {
            return CommandSelectNatural.func_71530_a((String[])args, (String[])new String[]{"0", "1", "2"});
        }
        return super.func_71516_a(commandSender, args);
    }

    public static void placeNaturalFloor(World world, BlockArea area, double lowerExpansion) {
        lowerExpansion += 0.01;
        Block floorBlock = RCBlocks.naturalFloor;
        Block airBlock1 = RCBlocks.negativeSpace;
        BlockCoord lowerPoint = area.getLowerCorner();
        BlockCoord higherPoint = area.getHigherCorner();
        for (int x = lowerPoint.x; x <= higherPoint.x; ++x) {
            block1: for (int z = lowerPoint.z; z <= higherPoint.z; ++z) {
                for (int y = lowerPoint.y; y <= higherPoint.y; ++y) {
                    Block block = world.func_147439_a(x, y, z);
                    if (block.func_149688_o() == Material.field_151579_a || block == floorBlock || block == airBlock1) continue;
                    if (!block.isNormalCube((IBlockAccess)world, x, y, z) || y <= lowerPoint.y) continue block1;
                    CommandSelectNatural.setBlockIfAirInArea(world, new BlockCoord(x, y - 1, z), floorBlock, area);
                    int expX = MathHelper.func_76143_f((double)(-lowerExpansion));
                    while ((double)expX <= lowerExpansion) {
                        int expZ = MathHelper.func_76143_f((double)(-lowerExpansion));
                        while ((double)expZ <= lowerExpansion) {
                            if ((double)(expX * expX + expZ * expZ) <= lowerExpansion * lowerExpansion) {
                                CommandSelectNatural.setBlockIfAirInArea(world, new BlockCoord(x + expX, y - 1, z + expZ), floorBlock, area);
                            }
                            ++expZ;
                        }
                        ++expX;
                    }
                    continue block1;
                }
            }
        }
    }

    public static void setBlockIfAirInArea(World world, BlockCoord coord, Block block, BlockArea area) {
        Block prevBlock;
        if (area.contains(coord) && ((prevBlock = world.func_147439_a(coord.x, coord.y, coord.z)).func_149688_o() == Material.field_151579_a || prevBlock == RCBlocks.negativeSpace)) {
            world.func_147449_b(coord.x, coord.y, coord.z, block);
        }
    }

    public static int sidesClosed(World world, BlockCoord coord, BlockArea area) {
        int sides = 0;
        BlockCoord lower = area.getLowerCorner();
        BlockCoord higher = area.getHigherCorner();
        if (CommandSelectNatural.sideClosed(world, new BlockCoord(lower.x, coord.y, coord.z), coord.x - lower.x, 1, 0, 0)) {
            ++sides;
        }
        if (CommandSelectNatural.sideClosed(world, new BlockCoord(higher.x, coord.y, coord.z), higher.x - coord.x, -1, 0, 0)) {
            ++sides;
        }
        if (CommandSelectNatural.sideClosed(world, new BlockCoord(coord.x, coord.y, lower.z), coord.z - lower.z, 0, 0, 1)) {
            ++sides;
        }
        if (CommandSelectNatural.sideClosed(world, new BlockCoord(coord.x, coord.y, higher.z), higher.z - coord.z, 0, 0, -1)) {
            ++sides;
        }
        return sides;
    }

    public static boolean sideClosed(World world, BlockCoord coord, int iterations, int xP, int yP, int zP) {
        for (int i = 0; i < iterations; ++i) {
            int x = coord.x + xP * i;
            int y = coord.y + yP * i;
            int z = coord.z + zP * i;
            Block block = world.func_147439_a(x, y, z);
            if (block.isReplaceable((IBlockAccess)world, x, y, z)) continue;
            return true;
        }
        return false;
    }

    public static void placeNaturalAir(World world, BlockArea area) {
        Block spaceBlock = RCBlocks.negativeSpace;
        BlockCoord lowerPoint = area.getLowerCorner();
        BlockCoord higherPoint = area.getHigherCorner();
        for (int x = lowerPoint.x; x <= higherPoint.x; ++x) {
            for (int z = lowerPoint.z; z <= higherPoint.z; ++z) {
                Block block;
                int y;
                int safePoint = lowerPoint.y;
                for (y = higherPoint.y; y >= lowerPoint.y; --y) {
                    block = world.func_147439_a(x, y, z);
                    if ((block.func_149688_o() == Material.field_151579_a || block == spaceBlock) && CommandSelectNatural.sidesClosed(world, new BlockCoord(x, y, z), area) < 3) continue;
                    safePoint = y + (block == RCBlocks.naturalFloor ? 1 : 3);
                    break;
                }
                for (y = safePoint; y <= higherPoint.y; ++y) {
                    world.func_147449_b(x, y, z, spaceBlock);
                }
                if (safePoint > lowerPoint.y) {
                    for (y = lowerPoint.y; y <= higherPoint.y; ++y) {
                        block = world.func_147439_a(x, y, z);
                        if ((block.func_149688_o() == Material.field_151579_a || block == spaceBlock) && CommandSelectNatural.sidesClosed(world, new BlockCoord(x, y, z), area) < 3) continue;
                        safePoint = y - 1;
                        break;
                    }
                }
                for (y = lowerPoint.y; y <= safePoint; ++y) {
                    world.func_147449_b(x, y, z, spaceBlock);
                }
            }
        }
    }
}

