/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editmazeblock;

import ivorius.ivtoolkit.maze.MazeComponent;
import ivorius.ivtoolkit.maze.MazePath;
import ivorius.ivtoolkit.maze.MazeRoom;
import ivorius.reccomplex.gui.editmazeblock.TableDataSourceMazeComponent;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementButton;
import ivorius.reccomplex.gui.table.TableNavigator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class TableDataSourceMazeComponentList
implements TableDataSource,
TableElementButton.Listener {
    private List<MazeComponent> mazeComponentList;
    private TableDelegate tableDelegate;
    private TableNavigator navigator;

    public TableDataSourceMazeComponentList(List<MazeComponent> mazeComponentList, TableDelegate tableDelegate, TableNavigator navigator) {
        this.mazeComponentList = mazeComponentList;
        this.tableDelegate = tableDelegate;
        this.navigator = navigator;
    }

    public List<MazeComponent> getMazeComponentList() {
        return Collections.unmodifiableList(this.mazeComponentList);
    }

    public void setMazeComponentList(List<MazeComponent> mazeComponentList) {
        this.mazeComponentList = mazeComponentList;
    }

    public TableDelegate getTableDelegate() {
        return this.tableDelegate;
    }

    public void setTableDelegate(TableDelegate tableDelegate) {
        this.tableDelegate = tableDelegate;
    }

    public TableNavigator getNavigator() {
        return this.navigator;
    }

    public void setNavigator(TableNavigator navigator) {
        this.navigator = navigator;
    }

    @Override
    public boolean has(GuiTable table, int index) {
        return index >= 0 && index < this.mazeComponentList.size() + 1;
    }

    @Override
    public TableElement elementForIndex(GuiTable table, int index) {
        if (index == this.mazeComponentList.size()) {
            TableElementButton addButton = new TableElementButton("addComponent", "Add", new TableElementButton.Action("addComponent", "Add Component"));
            addButton.addListener(this);
            return addButton;
        }
        TableElementButton button = new TableElementButton("mazeComponent" + index, this.mazeComponentList.get(index).getIdentifier(), new TableElementButton.Action("edit", "Edit"), new TableElementButton.Action("delete", "Delete"));
        button.addListener(this);
        return button;
    }

    @Override
    public void actionPerformed(TableElementButton tableElementButton, String actionID) {
        if (actionID.equals("addComponent")) {
            MazeComponent component = new MazeComponent(100, "", Arrays.asList(new MazeRoom(0, 0, 0)), Arrays.asList(new MazePath(0, false, 0, 0, 0), new MazePath(0, true, 0, 0, 0), new MazePath(2, false, 0, 0, 0), new MazePath(2, true, 0, 0, 0)));
            this.mazeComponentList.add(component);
            this.navigator.pushTable(new GuiTable(this.tableDelegate, new TableDataSourceMazeComponent(component, this.tableDelegate, this.navigator)));
        } else if (tableElementButton.getID().startsWith("mazeComponent")) {
            int index = Integer.valueOf(tableElementButton.getID().substring(13));
            MazeComponent component = this.mazeComponentList.get(index);
            if (actionID.equals("edit")) {
                this.navigator.pushTable(new GuiTable(this.tableDelegate, new TableDataSourceMazeComponent(component, this.tableDelegate, this.navigator)));
            } else if (actionID.equals("delete")) {
                this.mazeComponentList.remove((Object)component);
                this.tableDelegate.reloadData();
            }
        }
    }
}

