/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure;

import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementButton;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.worldgen.StructureHandler;
import ivorius.reccomplex.worldgen.blockTransformers.BlockTransformer;
import ivorius.reccomplex.worldgen.blockTransformers.BlockTransformerProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class TableDataSourceBlockTransformerList
implements TableDataSource,
TableElementButton.Listener {
    private List<BlockTransformer> blockTransformerList;
    private TableDelegate tableDelegate;
    private TableNavigator navigator;
    private String currentTransformerType;

    public TableDataSourceBlockTransformerList(List<BlockTransformer> blockTransformerList, TableDelegate tableDelegate, TableNavigator navigator) {
        this.blockTransformerList = blockTransformerList;
        this.tableDelegate = tableDelegate;
        this.navigator = navigator;
        this.currentTransformerType = TableDataSourceBlockTransformerList.nextTransformerID(null);
    }

    public List<BlockTransformer> getBlockTransformerList() {
        return Collections.unmodifiableList(this.blockTransformerList);
    }

    public void setBlockTransformerList(List<BlockTransformer> blockTransformerList) {
        this.blockTransformerList = blockTransformerList;
    }

    public TableDelegate getTableDelegate() {
        return this.tableDelegate;
    }

    public void setTableDelegate(TableDelegate tableDelegate) {
        this.tableDelegate = tableDelegate;
    }

    public TableNavigator getNavigator() {
        return this.navigator;
    }

    public void setNavigator(TableNavigator navigator) {
        this.navigator = navigator;
    }

    private static String nextTransformerID(String transformerID) {
        Collection<String> allTypes = StructureHandler.allBlockTransformerIDs();
        String[] allTypesArray = allTypes.toArray(new String[allTypes.size()]);
        for (int i = 0; i < allTypesArray.length; ++i) {
            if (!allTypesArray[i].equals(transformerID)) continue;
            return allTypesArray[(i + 1) % allTypesArray.length];
        }
        return allTypesArray[0];
    }

    @Override
    public boolean has(GuiTable table, int index) {
        return index >= 0 && index < this.blockTransformerList.size() + 2;
    }

    @Override
    public TableElement elementForIndex(GuiTable table, int index) {
        if (index == 0 || index == this.blockTransformerList.size() + 1) {
            int realIndex = index == 0 ? index : index - 1;
            TableElementButton addButton = new TableElementButton("add" + realIndex, "Type", new TableElementButton.Action("changeType", this.currentTransformerType), new TableElementButton.Action("add", "Add"));
            addButton.addListener(this);
            return addButton;
        }
        int transformerIndex = index - 1;
        TableElementButton.Action[] actions = new TableElementButton.Action[]{new TableElementButton.Action("earlier", "Earlier", transformerIndex > 0), new TableElementButton.Action("later", "Later", transformerIndex < this.blockTransformerList.size() - 1), new TableElementButton.Action("edit", "Edit"), new TableElementButton.Action("delete", "Delete")};
        TableElementButton button = new TableElementButton("transformer" + transformerIndex, this.blockTransformerList.get(transformerIndex).displayString(), actions);
        button.addListener(this);
        return button;
    }

    @Override
    public void actionPerformed(TableElementButton tableElementButton, String actionID) {
        if (actionID.equals("add")) {
            int index = Integer.valueOf(tableElementButton.getID().substring(3));
            BlockTransformerProvider provider = StructureHandler.blockTransformerProviderForID(this.currentTransformerType);
            Object blockTransformer = provider.defaultTransformer();
            TableDataSource tableDataSource = provider.tableDataSource(blockTransformer);
            this.blockTransformerList.add(index, (BlockTransformer)blockTransformer);
            this.navigator.pushTable(new GuiTable(this.tableDelegate, tableDataSource));
        } else if (actionID.equals("changeType")) {
            this.currentTransformerType = TableDataSourceBlockTransformerList.nextTransformerID(this.currentTransformerType);
            this.tableDelegate.reloadData();
        } else if (tableElementButton.getID().startsWith("transformer")) {
            int index = Integer.valueOf(tableElementButton.getID().substring(11));
            BlockTransformer blockTransformer = this.blockTransformerList.get(index);
            BlockTransformerProvider provider = StructureHandler.blockTransformerProviderForID(StructureHandler.blockTransformerIDForType(blockTransformer.getClass()));
            switch (actionID) {
                case "edit": {
                    this.navigator.pushTable(new GuiTable(this.tableDelegate, provider.tableDataSource(blockTransformer)));
                    break;
                }
                case "delete": {
                    this.blockTransformerList.remove(blockTransformer);
                    this.tableDelegate.reloadData();
                    break;
                }
                case "earlier": {
                    this.blockTransformerList.remove(index);
                    this.blockTransformerList.add(index - 1, blockTransformer);
                    this.tableDelegate.reloadData();
                    break;
                }
                case "later": {
                    this.blockTransformerList.remove(index);
                    this.blockTransformerList.add(index + 1, blockTransformer);
                    this.tableDelegate.reloadData();
                }
            }
        }
    }
}

