/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure;

import ivorius.ivtoolkit.gui.IntegerRange;
import ivorius.reccomplex.gui.GuiValidityStateIndicator;
import ivorius.reccomplex.gui.editstructure.TableDataSourceBiomeGenList;
import ivorius.reccomplex.gui.editstructure.TableDataSourceBlockTransformerList;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementBoolean;
import ivorius.reccomplex.gui.table.TableElementButton;
import ivorius.reccomplex.gui.table.TableElementIntegerRange;
import ivorius.reccomplex.gui.table.TableElementList;
import ivorius.reccomplex.gui.table.TableElementPropertyDefault;
import ivorius.reccomplex.gui.table.TableElementPropertyListener;
import ivorius.reccomplex.gui.table.TableElementString;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.worldgen.StructureHandler;
import ivorius.reccomplex.worldgen.genericStructures.GenerationYSelector;
import ivorius.reccomplex.worldgen.genericStructures.GenericStructureInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import joptsimple.internal.Strings;
import net.minecraft.client.resources.I18n;

public class TableDataSourceGenericStructure
implements TableDataSource,
TableElementButton.Listener,
TableElementPropertyListener {
    private GenericStructureInfo structureInfo;
    private String structureKey;
    private TableDelegate tableDelegate;
    private TableNavigator navigator;

    public TableDataSourceGenericStructure(GenericStructureInfo structureInfo, String structureKey, TableDelegate tableDelegate, TableNavigator navigator) {
        this.structureInfo = structureInfo;
        this.structureKey = structureKey;
        this.tableDelegate = tableDelegate;
        this.navigator = navigator;
    }

    private static List<TableElementList.Option> allGenerationOptions() {
        ArrayList<TableElementList.Option> generationBases = new ArrayList<TableElementList.Option>();
        for (GenerationYSelector.SelectionMode selectionMode : GenerationYSelector.SelectionMode.values()) {
            generationBases.add(new TableElementList.Option(selectionMode.serializedName(), I18n.func_135052_a((String)("structures.genY." + selectionMode.serializedName()), (Object[])new Object[0])));
        }
        return generationBases;
    }

    private static List<TableElementList.Option> allGenerationCategories() {
        String[] categories = new String[]{"decoration", "adventure", "rare"};
        ArrayList<TableElementList.Option> generationBases = new ArrayList<TableElementList.Option>();
        for (String category : categories) {
            generationBases.add(new TableElementList.Option(category, I18n.func_135052_a((String)("structures.category." + category), (Object[])new Object[0])));
        }
        return generationBases;
    }

    public GenericStructureInfo getStructureInfo() {
        return this.structureInfo;
    }

    public void setStructureInfo(GenericStructureInfo structureInfo) {
        this.structureInfo = structureInfo;
    }

    public String getStructureKey() {
        return this.structureKey;
    }

    public void setStructureKey(String structureKey) {
        this.structureKey = structureKey;
    }

    public TableDelegate getTableDelegate() {
        return this.tableDelegate;
    }

    public void setTableDelegate(TableDelegate tableDelegate) {
        this.tableDelegate = tableDelegate;
    }

    public TableNavigator getNavigator() {
        return this.navigator;
    }

    public void setNavigator(TableNavigator navigator) {
        this.navigator = navigator;
    }

    @Override
    public boolean has(GuiTable table, int index) {
        return index >= 0 && index < 9;
    }

    @Override
    public TableElement elementForIndex(GuiTable table, int index) {
        if (index == 0) {
            TableElementString element = new TableElementString("name", "Name", this.structureKey);
            element.addPropertyListener(this);
            element.setShowsValidityState(true);
            element.setValidityState(this.currentNameState());
            return element;
        }
        if (index == 1) {
            TableElementList element = new TableElementList("category", "Category", this.structureInfo.generationCategory(), TableDataSourceGenericStructure.allGenerationCategories());
            element.addPropertyListener(this);
            return element;
        }
        if (index == 2) {
            TableElementList element = new TableElementList("ySelType", "Generation Base", this.structureInfo.ySelector.selectionMode.serializedName(), TableDataSourceGenericStructure.allGenerationOptions());
            element.addPropertyListener(this);
            return element;
        }
        if (index == 3) {
            TableElementIntegerRange element = new TableElementIntegerRange("ySelShift", "Y Shift", new IntegerRange(this.structureInfo.ySelector.minY, this.structureInfo.ySelector.maxY), -100, 100);
            element.addPropertyListener(this);
            return element;
        }
        if (index == 4) {
            TableElementBoolean element = new TableElementBoolean("rotatable", "Rotatable", this.structureInfo.rotatable);
            element.addPropertyListener(this);
            return element;
        }
        if (index == 5) {
            TableElementBoolean element = new TableElementBoolean("mirrorable", "Mirrorable", this.structureInfo.mirrorable);
            element.addPropertyListener(this);
            return element;
        }
        if (index == 6) {
            TableElementString element = new TableElementString("dependencies", "Dependencies (A,B,...)", Strings.join(this.structureInfo.dependencies, (String)","));
            element.setValidityState(this.currentDependencyState());
            element.setShowsValidityState(true);
            element.addPropertyListener(this);
            return element;
        }
        if (index == 7) {
            TableElementButton elementEditBiomes = new TableElementButton("editBiomes", "Biomes", new TableElementButton.Action("edit", "Edit"));
            elementEditBiomes.addListener(this);
            return elementEditBiomes;
        }
        if (index == 8) {
            TableElementButton elementEditTransformers = new TableElementButton("editTransformers", "Transformers", new TableElementButton.Action("edit", "Edit"));
            elementEditTransformers.addListener(this);
            return elementEditTransformers;
        }
        return null;
    }

    @Override
    public void actionPerformed(TableElementButton tableElementButton, String actionID) {
        if ("editBiomes".equals(tableElementButton.getID()) && "edit".equals(actionID)) {
            GuiTable editBiomesProperties = new GuiTable(this.tableDelegate, new TableDataSourceBiomeGenList(this.structureInfo.generationWeights, this.tableDelegate, this.navigator));
            this.navigator.pushTable(editBiomesProperties);
        } else if ("editTransformers".equals(tableElementButton.getID()) && "edit".equals(actionID)) {
            GuiTable editTransformersProperties = new GuiTable(this.tableDelegate, new TableDataSourceBlockTransformerList(this.structureInfo.blockTransformers, this.tableDelegate, this.navigator));
            this.navigator.pushTable(editTransformersProperties);
        }
    }

    @Override
    public void valueChanged(TableElementPropertyDefault element) {
        if ("name".equals(element.getID())) {
            this.structureKey = (String)element.getPropertyValue();
            ((TableElementString)element).setValidityState(this.currentNameState());
        } else if ("category".equals(element.getID())) {
            this.structureInfo.generationCategory = (String)element.getPropertyValue();
        } else if ("ySelType".equals(element.getID())) {
            GenerationYSelector.SelectionMode selectionMode = GenerationYSelector.SelectionMode.selectionMode((String)element.getPropertyValue());
            this.structureInfo.ySelector.selectionMode = selectionMode != null ? selectionMode : GenerationYSelector.SelectionMode.SURFACE;
        } else if ("ySelShift".equals(element.getID())) {
            IntegerRange range = (IntegerRange)element.getPropertyValue();
            this.structureInfo.ySelector.minY = range.getMin();
            this.structureInfo.ySelector.maxY = range.getMax();
        } else if ("rotatable".equals(element.getID())) {
            this.structureInfo.rotatable = (Boolean)element.getPropertyValue();
        } else if ("mirrorable".equals(element.getID())) {
            this.structureInfo.mirrorable = (Boolean)element.getPropertyValue();
        } else if ("dependencies".equals(element.getID())) {
            this.structureInfo.dependencies.clear();
            String[] dependencies = ((String)element.getPropertyValue()).split(",");
            if (dependencies.length != 1 || dependencies[0].trim().length() > 0) {
                Collections.addAll(this.structureInfo.dependencies, dependencies);
            }
            ((TableElementString)element).setValidityState(this.currentDependencyState());
        }
    }

    private GuiValidityStateIndicator.State currentNameState() {
        if (StructureHandler.getAllStructureNames().contains(this.structureKey)) {
            return GuiValidityStateIndicator.State.SEMI_VALID;
        }
        return this.structureKey.trim().length() > 0 ? GuiValidityStateIndicator.State.VALID : GuiValidityStateIndicator.State.INVALID;
    }

    private GuiValidityStateIndicator.State currentDependencyState() {
        return this.structureInfo.areDependenciesResolved() ? GuiValidityStateIndicator.State.VALID : GuiValidityStateIndicator.State.SEMI_VALID;
    }
}

