/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table;

import ivorius.reccomplex.gui.table.Bounds;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class GuiTable
extends Gui {
    public static final int HEIGHT_PER_SLOT = 25;
    public static final int SCROLL_BAR_HEIGHT = 27;
    private TableDelegate delegate;
    private TableDataSource dataSource;
    private Bounds propertiesBounds;
    private int currentScrollIndex;
    private int cachedMaxIndex;
    private boolean hideScrollbarIfUnnecessary;
    private List<TableElement> currentElements = new ArrayList<TableElement>();
    private Map<GuiButton, Pair<TableElement, Integer>> buttonMap = new HashMap<GuiButton, Pair<TableElement, Integer>>();
    private GuiButton scrollUpButton;
    private GuiButton scrollDownButton;

    public GuiTable(TableDelegate delegate, TableDataSource dataSource) {
        this.delegate = delegate;
        this.dataSource = dataSource;
    }

    public TableDelegate getDelegate() {
        return this.delegate;
    }

    public void setDelegate(TableDelegate delegate) {
        this.delegate = delegate;
    }

    public TableDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(TableDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean hidesScrollbarIfUnnecessary() {
        return this.hideScrollbarIfUnnecessary;
    }

    public void setHideScrollbarIfUnnecessary(boolean hideScrollbarIfUnnecessary) {
        this.hideScrollbarIfUnnecessary = hideScrollbarIfUnnecessary;
    }

    public void initGui() {
        this.buttonMap.clear();
        for (TableElement element : this.currentElements) {
            element.setHidden(true);
        }
        this.currentElements.clear();
        this.scrollUpButton = new GuiButton(-1, this.propertiesBounds.getMinX(), this.propertiesBounds.getMinY(), this.propertiesBounds.getWidth() / 2 - 1, 20, "Up");
        this.delegate.addButton(this.scrollUpButton);
        this.scrollDownButton = new GuiButton(-1, this.propertiesBounds.getCenterX() + 1, this.propertiesBounds.getMinY(), this.propertiesBounds.getWidth() / 2 - 1, 20, "Down");
        this.delegate.addButton(this.scrollDownButton);
        int supportedSlotNumber = (this.propertiesBounds.getHeight() - 27) / 25;
        this.cachedMaxIndex = this.currentScrollIndex + supportedSlotNumber - 1;
        boolean needsUpScroll = this.dataSource.has(this, this.currentScrollIndex - 1);
        boolean needsDownScroll = this.dataSource.has(this, this.cachedMaxIndex + 1);
        boolean needsScroll = needsUpScroll || needsDownScroll;
        this.scrollUpButton.field_146124_l = needsUpScroll;
        this.scrollDownButton.field_146124_l = needsDownScroll;
        this.scrollUpButton.field_146125_m = needsScroll || !this.hideScrollbarIfUnnecessary;
        this.scrollDownButton.field_146125_m = needsScroll || !this.hideScrollbarIfUnnecessary;
        int baseY = this.propertiesBounds.getMinY() + 27;
        for (int index = 0; index < supportedSlotNumber && this.dataSource.has(this, this.currentScrollIndex + index); ++index) {
            int elementY = index * 25;
            TableElement element = this.dataSource.elementForIndex(this, this.currentScrollIndex + index);
            element.setBounds(Bounds.boundsWithSize(this.propertiesBounds.getMinX() + 100, this.propertiesBounds.getWidth() - 100, baseY + elementY, 20));
            element.setHidden(false);
            element.initGui(this);
            this.currentElements.add(element);
        }
    }

    public void drawScreen(GuiScreen screen, int mouseX, int mouseY, float partialTicks) {
        for (TableElement element : this.currentElements) {
            if (element.isHidden()) continue;
            element.draw(this, mouseX, mouseY, partialTicks);
            String title = element.getTitle();
            Bounds bounds = element.bounds();
            int stringWidth = screen.field_146297_k.field_71466_p.func_78256_a(title);
            screen.func_73731_b(screen.field_146297_k.field_71466_p, title, bounds.getMinX() - stringWidth - 10, bounds.getCenterY() - 4, -1);
        }
    }

    public void updateScreen() {
        for (TableElement element : this.currentElements) {
            element.update(this);
        }
    }

    protected void actionPerformed(GuiButton button) {
        if (button == this.scrollDownButton) {
            this.scrollDownIfPossible();
        } else if (button == this.scrollUpButton) {
            this.scrollUpIfPossible();
        } else {
            Pair<TableElement, Integer> propertyPair = this.buttonMap.get(button);
            if (propertyPair != null) {
                ((TableElement)propertyPair.getLeft()).buttonClicked((Integer)propertyPair.getRight());
            }
        }
    }

    protected boolean keyTyped(char keyChar, int keyCode) {
        for (TableElement element : this.currentElements) {
            if (!element.keyTyped(keyChar, keyCode)) continue;
            return true;
        }
        return false;
    }

    protected void mouseClicked(int x, int y, int button) {
        for (TableElement element : this.currentElements) {
            element.mouseClicked(button, x, y);
        }
    }

    public void setValueForProperty(String id, Object value) {
        for (TableElement element : this.currentElements) {
            if (!(element instanceof TableElementProperty) || !element.getID().equals(id)) continue;
            ((TableElementProperty)element).setPropertyValue(value);
        }
        throw new IllegalArgumentException("Unknown id: " + id);
    }

    public <V> V valueForProperty(String id) {
        for (TableElement element : this.currentElements) {
            if (!(element instanceof TableElementProperty) || !element.getID().equals(id)) continue;
            return (V)((TableElementProperty)element).getPropertyValue();
        }
        throw new IllegalArgumentException("Unknown id: " + id);
    }

    public void addButton(TableElement property, int id, GuiButton button) {
        this.delegate.addButton(button);
        this.buttonMap.put(button, (Pair<TableElement, Integer>)new ImmutablePair((Object)property, (Object)id));
    }

    public Bounds getPropertiesBounds() {
        return this.propertiesBounds;
    }

    public void setPropertiesBounds(Bounds propertiesBounds) {
        this.propertiesBounds = propertiesBounds;
    }

    public void scrollUpIfPossible() {
        if (this.dataSource.has(this, this.currentScrollIndex - 1)) {
            --this.currentScrollIndex;
            this.delegate.reloadData();
        }
    }

    public void scrollDownIfPossible() {
        if (this.dataSource.has(this, this.cachedMaxIndex + 1)) {
            ++this.currentScrollIndex;
            this.delegate.reloadData();
        }
    }
}

