/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.worldgen;

import ivorius.reccomplex.worldgen.StructureInfo;
import ivorius.reccomplex.worldgen.WeightedStructureInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;

public class StructureSelector {
    private Map<String, List<WeightedStructureInfo>> weightedStructureInfos = new HashMap<String, List<WeightedStructureInfo>>();

    public StructureSelector(Collection<StructureInfo> structures, BiomeGenBase biome) {
        for (StructureInfo structureInfo : structures) {
            int generationWeight = structureInfo.generationWeightInBiome(biome);
            if (generationWeight <= 0) continue;
            String category = structureInfo.generationCategory();
            if (!this.weightedStructureInfos.containsKey(category)) {
                this.weightedStructureInfos.put(category, new ArrayList());
            }
            this.weightedStructureInfos.get(category).add(new WeightedStructureInfo(generationWeight, structureInfo));
        }
    }

    public static float generationChance(String category) {
        switch (category) {
            case "decoration": {
                return 0.05f;
            }
            case "adventure": {
                return 0.005f;
            }
            case "rare": {
                return 0.001f;
            }
        }
        return 0.01f;
    }

    public List<StructureInfo> generatedStructures(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        ArrayList<StructureInfo> infos = new ArrayList<StructureInfo>();
        for (String category : this.weightedStructureInfos.keySet()) {
            if (!(random.nextFloat() < StructureSelector.generationChance(category))) continue;
            List<WeightedStructureInfo> structureInfos = this.weightedStructureInfos.get(category);
            WeightedStructureInfo structureInfo = (WeightedStructureInfo)WeightedRandom.func_76271_a((Random)random, structureInfos);
            infos.add(structureInfo.structureInfo);
        }
        return infos;
    }
}

