/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.reccomplex.worldgen.StructureHandler;
import ivorius.reccomplex.worldgen.StructureInfo;
import ivorius.reccomplex.worldgen.StructureSelector;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldGenStructures
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.func_72912_H().func_76089_r()) {
            BiomeGenBase biomeGen = world.func_72807_a(chunkX * 16, chunkZ * 16);
            StructureSelector structureSelector = StructureHandler.getStructureSelectorInBiome(biomeGen);
            List<StructureInfo> generated = structureSelector.generatedStructures(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
            for (StructureInfo info : generated) {
                int genX = chunkX * 16 + random.nextInt(16);
                int genZ = chunkZ * 16 + random.nextInt(16);
                int genY = WorldGenStructures.generateStructureRandomly(world, random, info, genX, genZ);
            }
        }
    }

    public static int generateStructureRandomly(World world, Random random, StructureInfo info, int x, int z) {
        AxisAlignedTransform2D transform = AxisAlignedTransform2D.transform(info.isRotatable() ? random.nextInt(4) : 0, info.isMirrorable() && random.nextBoolean());
        int[] size = WorldGenStructures.structureBoundingBox(info, transform);
        int genX = x - size[0] / 2;
        int genZ = z - size[2] / 2;
        int genY = info.generationY(world, random, x, z);
        info.generate(world, random, new BlockCoord(genX, genY, genZ), transform, 0);
        return genY;
    }

    public static int[] structureBoundingBox(StructureInfo info, AxisAlignedTransform2D transform) {
        int[] size = info.structureBoundingBox();
        if (transform.getRotation() % 2 == 1) {
            int cache = size[0];
            size[0] = size[2];
            size[2] = cache;
        }
        return size;
    }
}

