/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.worldgen.blockTransformers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.reccomplex.blocks.RCBlocks;
import ivorius.reccomplex.gui.editstructure.TableDataSourceBTNegativeSpace;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.worldgen.MCRegistrySpecial;
import ivorius.reccomplex.worldgen.blockTransformers.BlockTransformerNegativeSpace;
import ivorius.reccomplex.worldgen.blockTransformers.BlockTransformerProvider;
import java.lang.reflect.Type;
import net.minecraft.block.Block;

public class BTProviderNegativeSpace
implements BlockTransformerProvider<BlockTransformerNegativeSpace> {
    private Serializer serializer = new Serializer(MCRegistrySpecial.INSTANCE);

    @Override
    public BlockTransformerNegativeSpace defaultTransformer() {
        return new BlockTransformerNegativeSpace(RCBlocks.negativeSpace, 0);
    }

    @Override
    public TableDataSource tableDataSource(BlockTransformerNegativeSpace element) {
        return new TableDataSourceBTNegativeSpace(element);
    }

    @Override
    public JsonSerializer<BlockTransformerNegativeSpace> serializer() {
        return this.serializer;
    }

    @Override
    public JsonDeserializer<BlockTransformerNegativeSpace> deserializer() {
        return this.serializer;
    }

    public static class Serializer
    implements JsonDeserializer<BlockTransformerNegativeSpace>,
    JsonSerializer<BlockTransformerNegativeSpace> {
        private MCRegistry registry;

        public Serializer(MCRegistry registry) {
            this.registry = registry;
        }

        public BlockTransformerNegativeSpace deserialize(JsonElement jsonElement, Type par2Type, JsonDeserializationContext context) {
            JsonObject jsonobject = JsonUtils.getJsonElementAsJsonObject(jsonElement, "transformerNegativeSpace");
            String sourceBlock = JsonUtils.getJsonObjectStringFieldValue(jsonobject, "source");
            Block source = this.registry.blockFromID(sourceBlock);
            int sourceMeta = JsonUtils.getJsonObjectIntegerFieldValueOrDefault(jsonobject, "sourceMetadata", -1);
            return new BlockTransformerNegativeSpace(source, sourceMeta);
        }

        public JsonElement serialize(BlockTransformerNegativeSpace transformerPillar, Type par2Type, JsonSerializationContext context) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("source", Block.field_149771_c.func_148750_c((Object)transformerPillar.sourceBlock));
            if (transformerPillar.sourceMetadata >= 0) {
                jsonobject.addProperty("sourceMetadata", (Number)transformerPillar.sourceMetadata);
            }
            return jsonobject;
        }
    }
}

