/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.worldgen.genericStructures;

import ivorius.ivtoolkit.tools.IvGsonHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GenerationYSelector {
    public SelectionMode selectionMode;
    public int minY;
    public int maxY;

    public GenerationYSelector(SelectionMode selectionMode, int minY, int maxY) {
        this.selectionMode = selectionMode;
        this.minY = minY;
        this.maxY = maxY;
    }

    public int generationY(World world, Random random, int x, int z, int[] structureSize) {
        int y = this.minY + random.nextInt(this.maxY - this.minY + 1);
        switch (this.selectionMode) {
            case BEDROCK: {
                return Math.max(2, y);
            }
            case SURFACE: {
                int genYC = this.surfaceHeight(world, x, z);
                int genYPP = this.surfaceHeight(world, x + structureSize[0] / 2, z + structureSize[2] / 2);
                int genYPM = this.surfaceHeight(world, x + structureSize[0] / 2, z - structureSize[2] / 2);
                int genYMP = this.surfaceHeight(world, x - structureSize[0] / 2, z + structureSize[2] / 2);
                int genYMM = this.surfaceHeight(world, x - structureSize[0] / 2, z - structureSize[2] / 2);
                return Math.max(2, (genYC * 2 + genYPP + genYPM + genYMP + genYMM) / 6 + y);
            }
            case SEALEVEL: {
                return Math.max(2, 63 + y);
            }
            case UNDERWATER: {
                int genYC = this.surfaceHeightUnderwater(world, x, z);
                int genYPP = this.surfaceHeightUnderwater(world, x + structureSize[0] / 2, z + structureSize[2] / 2);
                int genYPM = this.surfaceHeightUnderwater(world, x + structureSize[0] / 2, z - structureSize[2] / 2);
                int genYMP = this.surfaceHeightUnderwater(world, x - structureSize[0] / 2, z + structureSize[2] / 2);
                int genYMM = this.surfaceHeightUnderwater(world, x - structureSize[0] / 2, z - structureSize[2] / 2);
                return Math.max(2, (genYC * 2 + genYPP + genYPM + genYMP + genYMM) / 6 + y);
            }
            case TOP: {
                return Math.max(2, world.func_72800_K() + y);
            }
            case LOWEST_EDGE: {
                int genYC = this.surfaceHeightUnderwater(world, x, z);
                int genYPP = this.surfaceHeightUnderwater(world, x + structureSize[0] / 2, z + structureSize[2] / 2);
                int genYPM = this.surfaceHeightUnderwater(world, x + structureSize[0] / 2, z - structureSize[2] / 2);
                int genYMP = this.surfaceHeightUnderwater(world, x - structureSize[0] / 2, z + structureSize[2] / 2);
                int genYMM = this.surfaceHeightUnderwater(world, x - structureSize[0] / 2, z - structureSize[2] / 2);
                return Math.max(2, GenerationYSelector.min(genYC, genYPP, genYPM, genYMP, genYMM) + y);
            }
        }
        throw new RuntimeException("Unrecognized selection mode " + (Object)((Object)this.selectionMode));
    }

    private int surfaceHeightUnderwater(World world, int x, int z) {
        int curYWater;
        for (curYWater = world.func_72825_h(x, z); curYWater > 0; --curYWater) {
            Block block = world.func_147439_a(x, curYWater, z);
            if (block instanceof BlockLiquid || block.func_149688_o() == Material.field_151588_w) continue;
            ++curYWater;
            break;
        }
        return curYWater;
    }

    private int surfaceHeight(World world, int x, int z) {
        Block block;
        int curY;
        for (curY = world.func_72825_h(x, z); curY > 0 && ((block = world.func_147439_a(x, curY, z)).isFoliage((IBlockAccess)world, x, curY, z) || block.func_149688_o() == Material.field_151584_j || block.func_149688_o() == Material.field_151585_k || block.func_149688_o() == Material.field_151575_d); --curY) {
        }
        while (curY < world.func_72800_K() && world.func_147439_a(x, curY, z) instanceof BlockLiquid) {
            ++curY;
        }
        return curY;
    }

    private static int min(int ... values) {
        int min = values[0];
        for (int val : values) {
            min = Math.min(val, min);
        }
        return min;
    }

    public static enum SelectionMode {
        BEDROCK,
        SURFACE,
        SEALEVEL,
        UNDERWATER,
        TOP,
        LOWEST_EDGE;


        public String serializedName() {
            return IvGsonHelper.serializedName(this);
        }

        public static SelectionMode selectionMode(String serializedName) {
            return (SelectionMode)IvGsonHelper.enumForName((String)serializedName, (Enum[])SelectionMode.values());
        }
    }
}

