/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.worldgen.inventory;

import ivorius.ivtoolkit.tools.IvFileHelper;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.worldgen.inventory.GenericInventoryGenerator;
import ivorius.reccomplex.worldgen.inventory.InventoryGenerationHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class InventoryGeneratorSaveHandler {
    private static List<String> importedCustomGenerators = new ArrayList<String>();

    public static void reloadAllCustomInventoryGenerators() {
        File[] inventoryGenFiles;
        File inventoryGeneratorsFile;
        while (!importedCustomGenerators.isEmpty()) {
            InventoryGenerationHandler.removeGenerator(importedCustomGenerators.remove(0));
        }
        importedCustomGenerators.clear();
        File structuresFile = IvFileHelper.getValidatedFolder(RecurrentComplex.proxy.getBaseFolderFile("structures"));
        if (structuresFile != null && (inventoryGeneratorsFile = IvFileHelper.getValidatedFolder(structuresFile, "inventoryGenerators")) != null && (inventoryGenFiles = inventoryGeneratorsFile.listFiles()) != null) {
            for (File inventoryGenFile : inventoryGenFiles) {
                String name = FilenameUtils.getBaseName((String)inventoryGenFile.getName());
                GenericInventoryGenerator genericStructureInfo = InventoryGeneratorSaveHandler.readInventoryGenerator(inventoryGenFile);
                if (genericStructureInfo == null) continue;
                InventoryGenerationHandler.registerInventoryGenerator(genericStructureInfo, name);
                importedCustomGenerators.add(name);
            }
        }
    }

    public static boolean saveInventoryGenerator(GenericInventoryGenerator info, String name) {
        File inventoryGeneratorsFile;
        File structuresFile = IvFileHelper.getValidatedFolder(RecurrentComplex.proxy.getBaseFolderFile("structures"));
        if (structuresFile != null && (inventoryGeneratorsFile = IvFileHelper.getValidatedFolder(structuresFile, "inventoryGenerators")) != null) {
            File newFile = new File(inventoryGeneratorsFile, name + ".json");
            String json = InventoryGenerationHandler.createJSONFromInventoryGenerator(info);
            try {
                FileUtils.writeStringToFile((File)newFile, (String)json);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return newFile.exists();
        }
        return false;
    }

    public static GenericInventoryGenerator readInventoryGenerator(ResourceLocation resourceLocation) {
        try {
            String json = IOUtils.toString((InputStream)IvFileHelper.inputStreamFromResourceLocation(resourceLocation), (String)"UTF-8");
            return InventoryGenerationHandler.createInventoryGeneratorFromJSON(json);
        }
        catch (Exception ex) {
            RecurrentComplex.logger.error("Could not read inventory generator " + resourceLocation.toString(), (Throwable)ex);
            return null;
        }
    }

    public static GenericInventoryGenerator readInventoryGenerator(File file) {
        String fullFileName = file.getName();
        String ext = FilenameUtils.getExtension((String)fullFileName);
        if (file.isFile() && "json".equals(ext)) {
            String fileContents = null;
            try {
                fileContents = FileUtils.readFileToString((File)file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (fileContents != null) {
                return InventoryGenerationHandler.createInventoryGeneratorFromJSON(fileContents);
            }
        }
        return null;
    }
}

