/*
 * Decompiled with CFR 0.152.
 */
package mariculture.api.fishery.fish;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mariculture.api.fishery.Fishing;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.api.util.Text;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class FishDNABase {
    protected String category;
    public static final ArrayList<FishDNABase> DNAParts = new ArrayList();

    public FishDNABase register() {
        DNAParts.add(this);
        return this;
    }

    public String getName() {
        return this.getClass().getSimpleName().substring(7);
    }

    public String getEggString() {
        return this.getName() + "List";
    }

    public String getHigherString() {
        return this.getName();
    }

    public String getLowerString() {
        return "lower" + this.getName();
    }

    public void getInformationDisplay(ItemStack stack, List list) {
    }

    public int[] attemptMutation(int parent1dna, int parent2dna) {
        int[] ret = new int[]{parent1dna, parent2dna};
        return ret;
    }

    public int[] getDominant(int option1, int option2, Random rand) {
        int[] ret = new int[]{option1, option2};
        return ret;
    }

    public int[] swapDominance(int dominance1, int dominance2, int option1, int option2, Random rand) {
        int[] array = new int[2];
        if (dominance1 == dominance2) {
            if (rand.nextInt(2) == 0) {
                array[0] = option1;
                array[1] = option2;
            } else {
                array[0] = option2;
                array[1] = option1;
            }
        } else if (dominance1 < dominance2) {
            array[0] = option1;
            array[1] = option2;
        } else {
            array[0] = option2;
            array[1] = option1;
        }
        return array;
    }

    public Integer getDNAFromSpecies(FishSpecies species) {
        return -1;
    }

    public ItemStack addDNA(ItemStack stack, Integer data) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (this.category == null) {
            stack.field_77990_d.func_74768_a(this.getHigherString(), data.intValue());
        } else {
            NBTTagCompound tag = stack.field_77990_d.func_74775_l(this.category);
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            tag.func_74768_a(this.getHigherString(), data.intValue());
            stack.field_77990_d.func_74782_a(this.category, (NBTBase)tag);
        }
        return stack;
    }

    public ItemStack addLowerDNA(ItemStack stack, Integer data) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (this.category == null) {
            stack.field_77990_d.func_74768_a(this.getLowerString(), data.intValue());
        } else {
            NBTTagCompound tag = stack.field_77990_d.func_74775_l(this.category);
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            tag.func_74768_a(this.getLowerString(), data.intValue());
            stack.field_77990_d.func_74782_a(this.category, (NBTBase)tag);
        }
        return stack;
    }

    public void addDNAList(ItemStack stack, int[] data) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (this.category == null) {
            stack.field_77990_d.func_74783_a(this.getEggString(), data);
        } else {
            NBTTagCompound tag = stack.field_77990_d.func_74775_l(this.category);
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            tag.func_74783_a(this.getEggString(), data);
            stack.field_77990_d.func_74782_a(this.category, (NBTBase)tag);
        }
    }

    public boolean hasEggData(ItemStack egg) {
        if (this.category == null) {
            return egg.field_77990_d.func_74764_b(this.getEggString());
        }
        NBTTagCompound tag = egg.field_77990_d.func_74775_l(this.category);
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        return tag.func_74764_b(this.getEggString());
    }

    public Integer getDNA(ItemStack stack) {
        if (stack == null || !stack.func_77942_o()) {
            return 0;
        }
        if (this.category == null) {
            if (!stack.field_77990_d.func_74764_b(this.getHigherString()) && stack.field_77990_d.func_74764_b("SpeciesID")) {
                FishSpecies species = Fishing.fishHelper.getSpecies(stack);
                this.addDNA(stack, this.getDNAFromSpecies(species));
            }
            return stack.field_77990_d.func_74762_e(this.getHigherString());
        }
        NBTTagCompound tag = stack.field_77990_d.func_74775_l(this.category);
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        return tag.func_74762_e(this.getHigherString());
    }

    public Integer getLowerDNA(ItemStack stack) {
        if (stack == null || !stack.func_77942_o()) {
            return 0;
        }
        if (this.category == null) {
            if (!stack.field_77990_d.func_74764_b(this.getLowerString()) && stack.field_77990_d.func_74764_b("lowerSpeciesID")) {
                FishSpecies species = Fishing.fishHelper.getSpecies(stack);
                this.addLowerDNA(stack, this.getDNAFromSpecies(species));
            }
            return stack.field_77990_d.func_74762_e(this.getLowerString());
        }
        NBTTagCompound tag = stack.field_77990_d.func_74775_l(this.category);
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        return tag.func_74762_e(this.getLowerString());
    }

    public int[] getDNAList(ItemStack stack) {
        if (this.category == null) {
            return stack.field_77990_d.func_74759_k(this.getEggString());
        }
        NBTTagCompound tag = stack.field_77990_d.func_74775_l(this.category);
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        return tag.func_74759_k(this.getEggString());
    }

    public String[] getScannedDisplay(ItemStack stack) {
        return new String[]{Text.translate(this.getName()), "" + this.getDNA(stack), "" + this.getLowerDNA(stack)};
    }
}

