/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import mariculture.Mariculture;
import mariculture.api.core.Environment;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.core.MaricultureTab;
import mariculture.core.Recipes;
import mariculture.core.RecipesSmelting;
import mariculture.core.RetroGeneration;
import mariculture.core.blocks.BlockAir;
import mariculture.core.blocks.BlockGlass;
import mariculture.core.blocks.BlockGround;
import mariculture.core.blocks.BlockLimestone;
import mariculture.core.blocks.BlockMachine;
import mariculture.core.blocks.BlockMachineMulti;
import mariculture.core.blocks.BlockMetal;
import mariculture.core.blocks.BlockPearlBlock;
import mariculture.core.blocks.BlockPressurisedWater;
import mariculture.core.blocks.BlockRenderedMachine;
import mariculture.core.blocks.BlockRenderedMachineMulti;
import mariculture.core.blocks.BlockRock;
import mariculture.core.blocks.BlockTank;
import mariculture.core.blocks.BlockTicking;
import mariculture.core.blocks.BlockTransparent;
import mariculture.core.blocks.BlockWater;
import mariculture.core.blocks.BlockWood;
import mariculture.core.config.Gardening;
import mariculture.core.config.WorldGeneration;
import mariculture.core.gui.GuiItemToolTip;
import mariculture.core.handlers.BucketHandler;
import mariculture.core.handlers.CastingHandler;
import mariculture.core.handlers.ClientFMLEvents;
import mariculture.core.handlers.CrucibleHandler;
import mariculture.core.handlers.EnvironmentHandler;
import mariculture.core.handlers.FuelHandler;
import mariculture.core.handlers.OreDicHandler;
import mariculture.core.handlers.PearlGenHandler;
import mariculture.core.handlers.ServerFMLEvents;
import mariculture.core.handlers.UpgradeHandler;
import mariculture.core.handlers.VatHandler;
import mariculture.core.handlers.WorldEventHandler;
import mariculture.core.handlers.WorldGenHandler;
import mariculture.core.helpers.FluidHelper;
import mariculture.core.helpers.RegistryHelper;
import mariculture.core.items.ItemBattery;
import mariculture.core.items.ItemBottle;
import mariculture.core.items.ItemBuckets;
import mariculture.core.items.ItemCrafting;
import mariculture.core.items.ItemFluidStorage;
import mariculture.core.items.ItemFood;
import mariculture.core.items.ItemHammer;
import mariculture.core.items.ItemMaterial;
import mariculture.core.items.ItemPearl;
import mariculture.core.items.ItemUpgrade;
import mariculture.core.items.ItemWorked;
import mariculture.core.lib.MetalRates;
import mariculture.core.lib.Modules;
import mariculture.core.tile.TileAirPump;
import mariculture.core.tile.TileAnvil;
import mariculture.core.tile.TileAutohammer;
import mariculture.core.tile.TileBlockCaster;
import mariculture.core.tile.TileBookshelf;
import mariculture.core.tile.TileCrucible;
import mariculture.core.tile.TileIngotCaster;
import mariculture.core.tile.TileNuggetCaster;
import mariculture.core.tile.TileOyster;
import mariculture.core.tile.TileTankBlock;
import mariculture.core.tile.TileVat;
import mariculture.core.tile.TileVoidBottle;
import mariculture.core.util.EntityFakeItem;
import mariculture.core.util.Fluids;
import mariculture.core.util.XPRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class Core
extends Modules.RegistrationModule {
    public static Block air;
    public static Block glass;
    public static Block limestone;
    public static Block metals;
    public static Block pearlBlock;
    public static Block rocks;
    public static Block sands;
    public static Block transparent;
    public static Block woods;
    public static Block water;
    public static Block machines;
    public static Block machinesMulti;
    public static Block renderedMachines;
    public static Block renderedMachinesMulti;
    public static Block tanks;
    public static Block ticking;
    public static Item buckets;
    public static Item bottles;
    public static Item crafting;
    public static Item food;
    public static Item materials;
    public static Item pearls;
    public static Item upgrade;
    public static Item worked;
    public static Item batteryTitanium;
    public static Item batteryCopper;
    public static Item bucketTitanium;
    public static Item hammer;
    public static Item ladle;
    public WorldEventHandler worldGen;
    Item.ToolMaterial brick = EnumHelper.addToolMaterial((String)"BRICK", (int)1, (int)1000, (float)3.0f, (float)1.2f, (int)12);

    @Override
    public void registerHandlers() {
        MaricultureHandlers.anvil = new TileAnvil();
        MaricultureHandlers.casting = new CastingHandler();
        MaricultureHandlers.crucible = new CrucibleHandler();
        MaricultureHandlers.environment = new EnvironmentHandler();
        MaricultureHandlers.upgrades = new UpgradeHandler();
        MaricultureHandlers.vat = new VatHandler();
        OreDicHandler.init();
        GameRegistry.registerFuelHandler((IFuelHandler)new FuelHandler());
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenHandler(), (int)1);
        MinecraftForge.EVENT_BUS.register((Object)new BucketHandler());
        MinecraftForge.EVENT_BUS.register((Object)new GuiItemToolTip());
        MinecraftForge.EVENT_BUS.register((Object)new OreDicHandler());
        FMLCommonHandler.instance().bus().register((Object)new ServerFMLEvents());
        FMLCommonHandler.instance().bus().register((Object)new ClientFMLEvents());
        if (WorldGeneration.WorldGen.ENABLE_REPLACEMENTS) {
            MinecraftForge.EVENT_BUS.register((Object)new WorldEventHandler());
        }
        BiomeGenBase.func_150565_n()[BiomeGenBase.field_76771_b.field_76756_M].func_150570_a(new BiomeGenBase.Height((float)WorldGeneration.WorldGen.OCEAN_ROOT, (float)WorldGeneration.WorldGen.OCEAN_VARIATION));
        BiomeGenBase.func_150565_n()[BiomeGenBase.field_150575_M.field_76756_M].func_150570_a(new BiomeGenBase.Height((float)WorldGeneration.WorldGen.OCEAN_DEEP_ROOT, (float)WorldGeneration.WorldGen.OCEAN_DEEP_VARIATION));
        if (WorldGeneration.RetroGen.ENABLED) {
            MinecraftForge.EVENT_BUS.register((Object)new RetroGeneration());
        }
    }

    @Override
    public void registerItems() {
        materials = new ItemMaterial().func_77655_b("materials");
        crafting = new ItemCrafting().func_77655_b("crafting");
        pearls = new ItemPearl().func_77655_b("pearls");
        food = new ItemFood().func_77655_b("food");
        upgrade = new ItemUpgrade().func_77655_b("upgrade");
        hammer = new ItemHammer(this.brick).func_77655_b("hammer");
        ladle = new ItemFluidStorage(MetalRates.INGOT).func_77655_b("ladle");
        bucketTitanium = new ItemFluidStorage(8000).func_77655_b("bucket.titanium");
        bottles = new ItemBottle().func_77655_b("fluids");
        buckets = new ItemBuckets().func_77655_b("bucket");
        batteryCopper = new ItemBattery(10000, 100, 250).func_77655_b("battery.copper");
        batteryTitanium = new ItemBattery(100000, 1000, 2500).func_77655_b("battery.titanium");
        worked = new ItemWorked().func_77655_b("worked");
        RegistryHelper.registerItems(new Item[]{materials, crafting, pearls, food, upgrade, bottles, buckets, hammer, ladle, bucketTitanium, batteryCopper, batteryTitanium, worked});
    }

    @Override
    public void registerFluids() {
        Fluids.add("water", FluidRegistry.WATER, 1000);
        Fluids.add("lava", FluidRegistry.LAVA, 100);
        FluidHelper.addGas("natural_gas", "gas.natural", 2000, 2);
        FluidHelper.addFluid("hp_water", "fastwater", 1000, 26, 250);
        FluidHelper.addFluid("quicklime", 1000, 18, 900);
        FluidHelper.addFluid("salt", "salt.molten", 1000, 19, 20);
        FluidHelper.addFluid("glass", "glass.molten", 1000, 15, 1000);
        FluidHelper.addFluid("aluminum", "aluminum.molten", MetalRates.ORE, 11, 144);
        FluidHelper.addFluid("magnesium", "magnesium.molten", MetalRates.ORE, 13, 144);
        FluidHelper.addFluid("titanium", "titanium.molten", MetalRates.ORE, 12, 144);
        FluidHelper.addFluid("copper", "copper.molten", MetalRates.ORE, 5, 144);
        FluidHelper.addFluid("rutile", "rutile.molten", MetalRates.ORE, 17, 144);
        FluidHelper.addFluid("iron", "iron.molten", MetalRates.ORE, 3, 144);
        FluidHelper.addFluid("gold", "gold.molten", MetalRates.ORE, 4, 144);
        FluidHelper.addFluid("tin", "tin.molten", MetalRates.ORE, 6, 144);
        FluidHelper.addFluid("lead", "lead.molten", MetalRates.ORE, 8, 144);
        FluidHelper.addFluid("silver", "silver.molten", MetalRates.ORE, 7, 144);
        FluidHelper.addFluid("nickel", "nickel.molten", MetalRates.ORE, 14, 144);
        FluidHelper.addFluid("bronze", "bronze.molten", MetalRates.ORE, 9, 144);
        FluidHelper.addFluid("steel", "steel.molten", MetalRates.ORE, 10, 144);
        FluidHelper.addFluid("electrum", "electrum.molten", MetalRates.ORE, 21, 144);
        FluidHelper.addFluid("xp", 100);
        XPRegistry.register("xp", 100.0f);
        FluidHelper.registerVanillaBottle(Fluids.getFluid("natural_gas"), 1000, 27);
        FluidHelper.registerHeatBottle(FluidRegistry.WATER, 2000, 22);
        FluidHelper.registerHeatBottle(FluidRegistry.LAVA, 2000, 23);
        FluidHelper.registerBucket(Fluids.getFluid("hp_water"), 1000, 0);
    }

    @Override
    public void registerBlocks() {
        FluidHelper.setBlock(BlockPressurisedWater.class, "hp_water", "highPressureWater");
        rocks = new BlockRock().func_149672_a(Block.field_149769_e).func_149752_b(2.0f).func_149663_c("rocks");
        limestone = new BlockLimestone().func_149672_a(Block.field_149769_e).func_149752_b(1.0f).func_149663_c("limestone");
        metals = new BlockMetal().func_149672_a(Block.field_149777_j).func_149752_b(5.0f).func_149663_c("metals");
        pearlBlock = new BlockPearlBlock("pearlBlock_").func_149672_a(Block.field_149769_e).func_149752_b(1.5f).func_149663_c("pearl.block");
        machines = new BlockMachine().func_149672_a(Block.field_149766_f).func_149752_b(10.0f).func_149663_c("machines.single");
        machinesMulti = new BlockMachineMulti().func_149672_a(Block.field_149769_e).func_149752_b(20.0f).func_149663_c("machines.multi");
        renderedMachines = new BlockRenderedMachine().func_149672_a(Block.field_149777_j).func_149752_b(1.0f).func_149711_c(1.0f).func_149663_c("machines.single.rendered");
        renderedMachinesMulti = new BlockRenderedMachineMulti().func_149672_a(Block.field_149777_j).func_149752_b(3.0f).func_149711_c(3.0f).func_149663_c("machines.multi.rendered");
        glass = new BlockGlass().func_149672_a(Block.field_149778_k).func_149752_b(5.0f).func_149663_c("glass");
        air = new BlockAir().func_149663_c("air");
        woods = new BlockWood().func_149672_a(Block.field_149766_f).func_149663_c("woods").func_149711_c(2.0f);
        tanks = new BlockTank().func_149672_a(Block.field_149778_k).func_149663_c("tanks").func_149711_c(1.0f);
        sands = new BlockGround().func_149663_c("sands").func_149711_c(1.0f);
        transparent = new BlockTransparent().func_149672_a(Block.field_149780_i).func_149663_c("transparent").func_149711_c(1.0f);
        ticking = new BlockTicking().func_149672_a(Block.field_149775_l).func_149711_c(0.05f).func_149663_c("ticking");
        water = new BlockWater().func_149672_a(Block.field_149773_n).func_149711_c(10.0f).func_149663_c("water");
        RegistryHelper.registerBlocks(new Block[]{rocks, limestone, water, metals, sands, woods, glass, transparent, pearlBlock, machines, machinesMulti, renderedMachinesMulti, renderedMachines, ticking, tanks, air});
        RegistryHelper.registerTiles(new Class[]{TileAirPump.class, TileCrucible.class, TileBookshelf.class, TileTankBlock.class, TileVat.class, TileAnvil.class, TileIngotCaster.class, TileVoidBottle.class, TileOyster.class, TileBlockCaster.class, TileNuggetCaster.class, TileAutohammer.class});
    }

    @Override
    public void registerOther() {
        this.addToOreDictionary();
        this.registerBiomes();
        this.registerEntities();
        this.registerPearls();
        if (MaricultureTab.tabCore != null) {
            MaricultureTab.tabCore.setIcon(new ItemStack(pearls, 1, 0), true);
            MaricultureTab.tabFactory.setIcon(new ItemStack(crafting, 1, 11), true);
            MaricultureTab.tabFishery.setIcon(new ItemStack(Items.field_151115_aP), true);
            MaricultureTab.tabWorld.setIcon(new ItemStack(limestone, 1, 0), true);
        }
    }

    private void registerEntities() {
        EntityRegistry.registerModEntity(EntityFakeItem.class, (String)"FakeItem", (int)44, (Object)Mariculture.instance, (int)80, (int)3, (boolean)false);
    }

    private void registerBiomes() {
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76787_r, Environment.Salinity.BRACKISH, 25);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76769_d, Environment.Salinity.FRESH, 45);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76786_s, Environment.Salinity.FRESH, 45);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76770_e, Environment.Salinity.FRESH, 5);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76783_v, Environment.Salinity.FRESH, 7);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76767_f, Environment.Salinity.FRESH, 10);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76785_t, Environment.Salinity.FRESH, 8);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76776_l, Environment.Salinity.SALINE, -1);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76777_m, Environment.Salinity.FRESH, -1);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76778_j, Environment.Salinity.FRESH, 80);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76775_o, Environment.Salinity.FRESH, -1);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76774_n, Environment.Salinity.FRESH, -1);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76782_w, Environment.Salinity.FRESH, 25);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76792_x, Environment.Salinity.FRESH, 24);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76789_p, Environment.Salinity.FRESH, 15);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76788_q, Environment.Salinity.BRACKISH, 20);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76771_b, Environment.Salinity.SALINE, 4);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76772_c, Environment.Salinity.FRESH, 10);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76781_i, Environment.Salinity.FRESH, 10);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76779_k, Environment.Salinity.FRESH, 3);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76780_h, Environment.Salinity.FRESH, 8);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76768_g, Environment.Salinity.FRESH, 5);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76784_u, Environment.Salinity.FRESH, 4);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_150584_S, Environment.Salinity.FRESH, 1);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_150579_T, Environment.Salinity.FRESH, 0);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_150577_O, Environment.Salinity.BRACKISH, 1);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_150576_N, Environment.Salinity.BRACKISH, 15);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_150575_M, Environment.Salinity.SALINE, 2);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_150580_W, Environment.Salinity.FRESH, 5);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_150578_U, Environment.Salinity.FRESH, 3);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_150581_V, Environment.Salinity.FRESH, 2);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_150583_P, Environment.Salinity.FRESH, 10);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_150582_Q, Environment.Salinity.FRESH, 8);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_150585_R, Environment.Salinity.FRESH, 11);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_150588_X, Environment.Salinity.FRESH, 23);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_150587_Y, Environment.Salinity.FRESH, 22);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_150589_Z, Environment.Salinity.FRESH, 40);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_150607_aa, Environment.Salinity.FRESH, 38);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_150608_ab, Environment.Salinity.FRESH, 39);
    }

    private void registerPearls() {
        PearlGenHandler.addPearl(new ItemStack(pearls, 1, 9), 7);
        PearlGenHandler.addPearl(new ItemStack(pearls, 1, 8), 9);
        PearlGenHandler.addPearl(new ItemStack(pearls, 1, 6), 12);
        PearlGenHandler.addPearl(new ItemStack(pearls, 1, 5), 5);
        PearlGenHandler.addPearl(new ItemStack(pearls, 1, 1), 9);
        PearlGenHandler.addPearl(new ItemStack(pearls, 1, 3), 11);
        PearlGenHandler.addPearl(new ItemStack(pearls, 1, 10), 10);
        PearlGenHandler.addPearl(new ItemStack(pearls, 1, 7), 9);
        PearlGenHandler.addPearl(new ItemStack(pearls, 1, 4), 9);
        PearlGenHandler.addPearl(new ItemStack(pearls, 1, 11), 6);
        PearlGenHandler.addPearl(new ItemStack(pearls, 1, 0), 7);
        PearlGenHandler.addPearl(new ItemStack(pearls, 1, 2), 6);
        PearlGenHandler.addPearl(new ItemStack((Block)Blocks.field_150354_m), 15);
        if (Gardening.GEN_ENDER_PEARLS) {
            PearlGenHandler.addPearl(new ItemStack(Items.field_151079_bi), 1);
        }
    }

    private void addToOreDictionary() {
        OreDictionary.registerOre((String)"blockLimestone", (ItemStack)new ItemStack(limestone, 1, 0));
        OreDictionary.registerOre((String)"limestone", (ItemStack)new ItemStack(limestone, 1, 0));
        OreDictionary.registerOre((String)"oreCopper", (ItemStack)new ItemStack(rocks, 1, 1));
        OreDictionary.registerOre((String)"oreAluminum", (ItemStack)new ItemStack(rocks, 1, 2));
        OreDictionary.registerOre((String)"oreRutile", (ItemStack)new ItemStack(rocks, 1, 3));
        OreDictionary.registerOre((String)"blockAluminum", (ItemStack)new ItemStack(metals, 1, 1));
        OreDictionary.registerOre((String)"blockCopper", (ItemStack)new ItemStack(metals, 1, 0));
        OreDictionary.registerOre((String)"blockMagnesium", (ItemStack)new ItemStack(metals, 1, 3));
        OreDictionary.registerOre((String)"blockRutile", (ItemStack)new ItemStack(metals, 1, 2));
        OreDictionary.registerOre((String)"blockTitanium", (ItemStack)new ItemStack(metals, 1, 4));
        OreDictionary.registerOre((String)"dustMagnesium", (ItemStack)new ItemStack(materials, 1, 13));
        OreDictionary.registerOre((String)"foodSalt", (ItemStack)new ItemStack(materials, 1, 12));
        OreDictionary.registerOre((String)"ingotAluminum", (ItemStack)new ItemStack(materials, 1, 0));
        OreDictionary.registerOre((String)"ingotCopper", (ItemStack)new ItemStack(materials, 1, 4));
        OreDictionary.registerOre((String)"ingotMagnesium", (ItemStack)new ItemStack(materials, 1, 1));
        OreDictionary.registerOre((String)"ingotRutile", (ItemStack)new ItemStack(materials, 1, 3));
        OreDictionary.registerOre((String)"ingotTitanium", (ItemStack)new ItemStack(materials, 1, 2));
        OreDictionary.registerOre((String)"dyeYellow", (ItemStack)new ItemStack(materials, 1, 30));
        OreDictionary.registerOre((String)"dyeRed", (ItemStack)new ItemStack(materials, 1, 31));
        OreDictionary.registerOre((String)"dyeBrown", (ItemStack)new ItemStack(materials, 1, 32));
        OreDictionary.registerOre((String)"dyeGreen", (ItemStack)new ItemStack(materials, 1, 29));
        OreDictionary.registerOre((String)"dyeWhite", (ItemStack)new ItemStack(materials, 1, 27));
        OreDictionary.registerOre((String)"dyeBlue", (ItemStack)new ItemStack(materials, 1, 28));
        OreDictionary.registerOre((String)"nuggetAluminum", (ItemStack)new ItemStack(materials, 1, 34));
        OreDictionary.registerOre((String)"nuggetCopper", (ItemStack)new ItemStack(materials, 1, 38));
        OreDictionary.registerOre((String)"nuggetMagnesium", (ItemStack)new ItemStack(materials, 1, 35));
        OreDictionary.registerOre((String)"nuggetRutile", (ItemStack)new ItemStack(materials, 1, 37));
        OreDictionary.registerOre((String)"nuggetTitanium", (ItemStack)new ItemStack(materials, 1, 36));
        OreDictionary.registerOre((String)"nuggetIron", (ItemStack)new ItemStack(materials, 1, 33));
    }

    @Override
    public void registerRecipes() {
        Recipes.add();
    }

    @Override
    public void postInit() {
        RecipesSmelting.postAdd();
        super.postInit();
    }
}

