/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mariculture.core.blocks.base.BlockDecorative;
import mariculture.factory.items.ItemRotor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockMetal
extends BlockDecorative {
    private IIcon[] aluminum;

    public BlockMetal() {
        super(Material.field_151573_f);
    }

    @Override
    public String getToolType(int meta) {
        return "pickaxe";
    }

    @Override
    public int getToolLevel(int meta) {
        switch (meta) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 1;
            }
        }
        return 1;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        switch (world.func_72805_g(x, y, z)) {
            case 0: {
                return 2.5f;
            }
            case 1: {
                return 4.0f;
            }
            case 2: {
                return 10.0f;
            }
            case 3: {
                return 1.0f;
            }
            case 4: {
                return 15.0f;
            }
            case 5: {
                return 3.0f;
            }
        }
        return 4.0f;
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        switch (world.func_72805_g(x, y, z)) {
            case 0: {
                return 10.0f;
            }
            case 1: {
                return 12.0f;
            }
            case 2: {
                return 15.0f;
            }
            case 3: {
                return 2.0f;
            }
            case 4: {
                return 45.0f;
            }
            case 5: {
                return 10.0f;
            }
        }
        return 10.0f;
    }

    private boolean isSameBlock(IBlockAccess world, int[] coords1, int[] coords2) {
        return world.func_147439_a(coords1[0], coords1[1], coords1[2]) == world.func_147439_a(coords2[0], coords2[1], coords2[2]) && world.func_72805_g(coords1[1], coords1[0], coords1[2]) == world.func_72805_g(coords2[1], coords2[0], coords2[2]);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        ItemStack held = player.func_71045_bC();
        if (!player.func_70093_af() && held != null && world.func_72805_g(x, y, z) == 5 && held.func_77973_b() instanceof ItemRotor) {
            if (((ItemRotor)held.func_77973_b()).setBlock(held, world, x, y, z, ForgeDirection.getOrientation((int)side))) {
                player.func_70062_b(0, null);
                return true;
            }
            return false;
        }
        return false;
    }

    public IIcon func_149673_e(IBlockAccess block, int x, int y, int z, int side) {
        int meta = block.func_72805_g(x, y, z);
        if (meta != 1) {
            return super.func_149673_e(block, x, y, z, side);
        }
        if (this.isSameBlock(block, new int[]{x, y, z}, new int[]{x, y + 1, z})) {
            if (this.isSameBlock(block, new int[]{x, y, z}, new int[]{x, y - 1, z})) {
                return this.aluminum[0];
            }
            return this.aluminum[1];
        }
        if (this.isSameBlock(block, new int[]{x, y, z}, new int[]{x, y - 1, z})) {
            if (this.isSameBlock(block, new int[]{x, y, z}, new int[]{x, y + 1, z})) {
                return this.aluminum[0];
            }
            return this.aluminum[2];
        }
        return super.func_149673_e(block, x, y, z, side);
    }

    @Override
    public int getMetaCount() {
        return 6;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        super.func_149651_a(register);
        this.aluminum = new IIcon[3];
        for (int i = 0; i < this.aluminum.length; ++i) {
            this.aluminum[i] = register.func_94245_a("mariculture:aluminumBlock" + i);
        }
    }
}

