/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.blocks;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mariculture.Mariculture;
import mariculture.api.core.MaricultureTab;
import mariculture.core.blocks.base.BlockFunctionalMulti;
import mariculture.core.helpers.FluidHelper;
import mariculture.core.helpers.SpawnItemHelper;
import mariculture.core.helpers.cofh.ItemHelper;
import mariculture.core.items.ItemUpgrade;
import mariculture.core.lib.Modules;
import mariculture.core.lib.RenderIds;
import mariculture.core.network.PacketCompressor;
import mariculture.core.network.PacketHandler;
import mariculture.core.tile.TileVat;
import mariculture.diving.Diving;
import mariculture.diving.TileAirCompressor;
import mariculture.factory.tile.TilePressureVessel;
import mariculture.fishery.tile.TileSifter;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public class BlockRenderedMachineMulti
extends BlockFunctionalMulti {
    public IIcon bar1;

    public BlockRenderedMachineMulti() {
        super(Material.field_151573_f);
        this.func_149713_g(0);
    }

    @Override
    public String getToolType(int meta) {
        if (meta == 4) {
            return "axe";
        }
        return "pickaxe";
    }

    @Override
    public int getToolLevel(int meta) {
        return meta == 3 ? 1 : 2;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        switch (world.func_72805_g(x, y, z)) {
            case 0: {
                return 6.0f;
            }
            case 1: {
                return 4.0f;
            }
            case 2: {
                return 15.0f;
            }
            case 3: {
                return 2.5f;
            }
            case 4: {
                return 1.5f;
            }
        }
        return 5.0f;
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileSifter sifter;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null) {
            return false;
        }
        ItemStack heldItem = player.func_71045_bC();
        if (heldItem != null && tile instanceof TileAirCompressor) {
            TileAirCompressor te = (TileAirCompressor)((TileAirCompressor)tile).getMaster();
            if (te != null) {
                int rf;
                int n = rf = heldItem.func_77973_b() instanceof IEnergyContainerItem ? ((IEnergyContainerItem)heldItem.func_77973_b()).extractEnergy(heldItem, 5000, true) : 0;
                if (rf > 0) {
                    int drain = te.receiveEnergy(ForgeDirection.UP, rf, true);
                    if (drain > 0) {
                        ((IEnergyContainerItem)heldItem.func_77973_b()).extractEnergy(heldItem, drain, false);
                        te.receiveEnergy(ForgeDirection.UP, drain, false);
                    }
                    return true;
                }
                if (heldItem.func_77973_b() == Diving.scubaTank && heldItem.func_77960_j() > 1 && te.storedAir > 0) {
                    heldItem.func_77964_b(heldItem.func_77960_j() - 1);
                    if (!world.field_72995_K) {
                        --te.storedAir;
                        PacketHandler.sendAround(new PacketCompressor(te.field_145851_c, te.field_145848_d, te.field_145849_e, te.storedAir, te.getEnergyStored(ForgeDirection.UP)), te);
                    }
                    return true;
                }
            } else {
                return false;
            }
        }
        if (tile instanceof TileVat) {
            TileVat vat = (TileVat)tile;
            ItemStack held = player.func_71045_bC();
            ItemStack input = vat.func_70301_a(0);
            ItemStack output = vat.func_70301_a(1);
            if (FluidHelper.isFluidOrEmpty(player.func_71045_bC())) {
                return FluidHelper.handleFillOrDrain((IFluidHandler)world.func_147438_o(x, y, z), player, ForgeDirection.UP);
            }
            if (output != null) {
                if (!player.field_71071_by.func_70441_a(vat.func_70301_a(1)) && !world.field_72995_K) {
                    SpawnItemHelper.spawnItem(world, x, y + 1, z, vat.func_70301_a(1));
                }
                vat.func_70299_a(1, null);
                return true;
            }
            if (player.func_70093_af() && input != null) {
                if (!player.field_71071_by.func_70441_a(vat.func_70301_a(0)) && !world.field_72995_K) {
                    SpawnItemHelper.spawnItem(world, x, y + 1, z, vat.func_70301_a(0));
                }
                vat.func_70299_a(0, null);
                return true;
            }
            if (held != null && !player.func_70093_af()) {
                if (input == null) {
                    if (!world.field_72995_K) {
                        ItemStack copy = held.func_77946_l();
                        copy.field_77994_a = 1;
                        vat.func_70299_a(0, copy);
                        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                    }
                    return true;
                }
                if (ItemHelper.areItemStacksEqualNoNBT(input, held)) {
                    if (input.field_77994_a + 1 < input.func_77976_d()) {
                        if (!world.field_72995_K) {
                            ItemStack stack = input.func_77946_l();
                            ++stack.field_77994_a;
                            vat.func_70299_a(0, stack);
                            player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                        }
                        return true;
                    }
                    return false;
                }
                return false;
            }
        }
        if (tile instanceof TileSifter && (sifter = ((TileSifter)tile).getMaster()) != null) {
            if (sifter.hasInventory) {
                player.openGui((Object)Mariculture.instance, 0, world, sifter.field_145851_c, sifter.field_145848_d, sifter.field_145849_e);
            } else if (heldItem != null) {
                if (heldItem.func_77973_b() instanceof ItemUpgrade && heldItem.func_77960_j() == 0 && !sifter.hasInventory) {
                    sifter.hasInventory = true;
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                    }
                    if (!world.field_72995_K) {
                        PacketHandler.updateRender(sifter);
                    }
                } else {
                    ItemStack addition = heldItem.func_77946_l();
                    addition.field_77994_a = 1;
                    if (sifter.process(addition, world.field_73012_v) && !player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                    }
                }
            }
        }
        return super.func_149727_a(world, x, y, z, player, side, hitX, hitY, hitZ);
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        EntityItem item;
        ItemStack stack;
        TileSifter sifter;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (entity instanceof EntityItem && !world.field_72995_K && tile instanceof TileSifter && (sifter = ((TileSifter)tile).getMaster()) != null && sifter.process(stack = (item = (EntityItem)entity).func_92059_d(), world.field_73012_v)) {
            item.func_70106_y();
        }
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return RenderIds.RENDER_ALL;
    }

    public void func_149719_a(IBlockAccess block, int x, int y, int z) {
        int meta = block.func_72805_g(x, y, z);
        switch (meta) {
            case 1: {
                this.func_149676_a(0.05f, 0.0f, 0.05f, 0.95f, 0.15f, 0.95f);
                break;
            }
            case 0: {
                this.func_149676_a(0.05f, 0.0f, 0.05f, 0.95f, 1.0f, 0.95f);
                break;
            }
            default: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.95f, 1.0f);
            }
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == 3) {
            return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + (double)0.50001f), (double)((double)z + this.field_149757_G));
        }
        return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F), (double)((double)z + this.field_149757_G));
    }

    @Override
    public boolean destroyBlock(World world, int x, int y, int z) {
        return false;
    }

    @Override
    public TileEntity createTileEntity(World world, int meta) {
        switch (meta) {
            case 0: {
                return new TileAirCompressor();
            }
            case 1: {
                return new TileAirCompressor();
            }
            case 2: {
                return new TilePressureVessel();
            }
            case 3: {
                return new TileVat();
            }
            case 4: {
                return new TileSifter();
            }
        }
        return null;
    }

    @Override
    public boolean isActive(int meta) {
        switch (meta) {
            case 0: {
                return Modules.isActive(Modules.diving);
            }
            case 1: {
                return Modules.isActive(Modules.diving);
            }
            case 2: {
                return Modules.isActive(Modules.factory);
            }
            case 4: {
                return Modules.isActive(Modules.fishery);
            }
        }
        return true;
    }

    @Override
    public boolean isValidTab(CreativeTabs tab, int meta) {
        if (meta == 4) {
            return MaricultureTab.tabFishery == tab;
        }
        return tab == MaricultureTab.tabFactory;
    }

    @Override
    public int getMetaCount() {
        return 5;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.bar1 = iconRegister.func_94245_a("mariculture:bar1");
        super.func_149651_a(iconRegister);
    }
}

