/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.gui;

import java.util.List;
import mariculture.api.core.FuelInfo;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.core.RecipeSmelter;
import mariculture.core.gui.ContainerCrucible;
import mariculture.core.gui.GuiMariculture;
import mariculture.core.gui.feature.FeatureArrow;
import mariculture.core.gui.feature.FeatureEject;
import mariculture.core.gui.feature.FeatureRedstone;
import mariculture.core.gui.feature.FeatureTank;
import mariculture.core.gui.feature.FeatureUpgrades;
import mariculture.core.helpers.FluidHelper;
import mariculture.core.tile.TileCrucible;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GuiCrucible
extends GuiMariculture {
    private final TileCrucible tile;

    public GuiCrucible(InventoryPlayer player, TileCrucible tile) {
        super(new ContainerCrucible(tile, player), "liquifier", 10);
        this.tile = tile;
        this.features.add(new FeatureUpgrades());
        this.features.add(new FeatureTank(tile, 98, 19, FeatureTank.TankSize.DOUBLE));
        this.features.add(new FeatureArrow(tile, 65, 41));
        this.features.add(new FeatureRedstone(tile));
        this.features.add(new FeatureEject(tile));
    }

    @Override
    public void addToolTip() {
        if (this.mouseX >= 12 && this.mouseX <= 16 && this.mouseY >= 18 && this.mouseY <= 77) {
            this.tooltip.add(this.tile.getRealTemperature() + "\u00b0" + "C");
        }
    }

    @Override
    public void addItemToolTip(ItemStack stack, List<String> currenttip) {
        boolean ethereal = MaricultureHandlers.upgrades.hasUpgrade("ethereal", this.tile);
        if (stack != null) {
            int meltingPoint = MaricultureHandlers.crucible.getMeltingPoint(stack, ethereal);
            FuelInfo info = MaricultureHandlers.crucible.getFuelInfo(stack);
            if (FluidContainerRegistry.isFilledContainer((ItemStack)stack)) {
                FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
                info = MaricultureHandlers.crucible.getFuelInfo(fluid);
            }
            if (meltingPoint > 0) {
                currenttip.add("\u00a76" + StatCollector.func_74838_a((String)"mariculture.string.melting") + ": " + meltingPoint + "\u00b0" + "C");
            }
            if (MaricultureHandlers.crucible.getResult(stack, null, -1, ethereal) != null) {
                RecipeSmelter result = MaricultureHandlers.crucible.getResult(stack, null, -1, ethereal);
                if (result.fluid.amount > 0) {
                    if (result.rands != null) {
                        currenttip.add("\u00a79" + StatCollector.func_74838_a((String)"mariculture.string.randomMetal"));
                    } else {
                        currenttip.add("\u00a79" + FluidHelper.getName(result.fluid.getFluid()) + ": " + result.fluid.amount + "mB");
                    }
                }
                if (result.output != null && result.chance > 0) {
                    int chance = (int)(1.0f / (float)result.chance * 100.0f);
                    currenttip.add("\u00a77" + chance + StatCollector.func_74838_a((String)"mariculture.string.percent") + result.output.func_82833_r());
                }
            }
            if (info != null) {
                if (FluidContainerRegistry.isFilledContainer((ItemStack)stack)) {
                    currenttip.add("\u00a73" + StatCollector.func_74838_a((String)"mariculture.string.asFluid"));
                    currenttip.add("\u00a7f" + StatCollector.func_74838_a((String)"mariculture.string.perTempFluid") + ": " + info.maxTempPer + "\u00b0" + "C");
                } else {
                    currenttip.add("\u00a72" + StatCollector.func_74838_a((String)"mariculture.string.asSolid"));
                    currenttip.add("\u00a7f" + StatCollector.func_74838_a((String)"mariculture.string.perTempSolid") + ": " + info.maxTempPer + "\u00b0" + "C");
                }
                currenttip.add("\u00a77" + StatCollector.func_74838_a((String)"mariculture.string.maxTemp") + ": " + info.maxTemp + "\u00b0" + "C");
            }
        }
    }

    @Override
    public void drawBackground(int x, int y) {
        int temp = this.tile.getTemperatureScaled(60);
        this.func_73729_b(x + 12, y + 18 + 60 - temp, 251, 60 - temp, 5, temp);
        int burn = this.tile.getBurnTimeRemainingScaled();
        this.func_73729_b(x + 38, y + 43 + 12 - burn, 242, 72 - burn, 14, burn);
    }

    @Override
    public int getX() {
        return 16;
    }
}

