/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.handlers;

import java.util.HashMap;
import mariculture.api.core.Environment;
import mariculture.api.core.IEnvironmentHandler;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class EnvironmentHandler
implements IEnvironmentHandler {
    public static final HashMap<Integer, BiomeData> environments = new HashMap();

    @Override
    public void addEnvironment(BiomeGenBase biome, Environment.Salinity salinity, int temperature) {
        environments.put(biome.field_76756_M, new BiomeData(temperature, salinity));
    }

    @Override
    public Environment.Salinity getSalinity(World world, int x, int z) {
        BiomeGenBase biome = world.func_72807_a(x, z);
        BiomeData data = environments.get(biome.field_76756_M);
        return data == null ? Environment.Salinity.FRESH : data.salinity;
    }

    @Override
    public int getBiomeTemperature(World world, int x, int y, int z) {
        int temperature = 10;
        BiomeGenBase biome = world.func_72807_a(x, z);
        BiomeData data = environments.get(biome.field_76756_M);
        if (data != null) {
            temperature = data.temperature;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            temperature = 100;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DESERT)) {
            temperature = 50;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FROZEN)) {
            temperature = -30;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            temperature = 8;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            temperature = 25;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            temperature = 10;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS)) {
            temperature = 10;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND)) {
            temperature = 45;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END)) {
            temperature = -10;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER)) {
            temperature = 3;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL)) {
            temperature = 20;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH)) {
            temperature = 15;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN)) {
            temperature = -10;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS)) {
            temperature = -2;
        }
        return temperature;
    }

    @Override
    public int getTemperature(World world, int x, int y, int z) {
        int temperature = this.getBiomeTemperature(world, x, y, z) - 3;
        temperature = (int)((float)temperature + (this.getSunBrightness(world, 1.0f) * 9.0f - 2.0f));
        if (y > 60) {
            temperature = (int)((double)(60 - y) * 0.11255) + temperature;
        } else if (y < 68) {
            temperature = (int)((double)temperature - (double)(68 - y) * 0.11255);
        }
        return temperature -= (int)((double)world.func_72867_j(1.0f) * 0.15);
    }

    public float getSunBrightness(World world, float par1) {
        float f1 = world.func_72826_c(par1);
        float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        f2 = 1.0f - f2;
        f2 = (float)((double)f2 * (1.0 - (double)(world.func_72867_j(par1) * 5.0f) / 16.0));
        f2 = (float)((double)f2 * (1.0 - (double)(world.func_72819_i(par1) * 5.0f) / 16.0));
        return f2 * 0.8f + 0.2f;
    }

    @Override
    public boolean matches(Environment.Salinity salt, int temp, Environment.Salinity[] salinity, int[] temperature) {
        if (salinity == null || temperature == null) {
            return false;
        }
        if (temperature.length != 2) {
            return false;
        }
        if (temp >= temperature[0] && temp <= temperature[1]) {
            for (Environment.Salinity s : salinity) {
                if (s != salt) continue;
                return true;
            }
        }
        return false;
    }

    private static class BiomeData {
        private int temperature;
        private Environment.Salinity salinity;

        private BiomeData(int temperature, Environment.Salinity salinity) {
            this.temperature = temperature;
            this.salinity = salinity;
        }
    }
}

