/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.helpers;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import mariculture.core.helpers.PlayerHelper;
import mariculture.core.tile.base.TileMultiBlock;
import mariculture.core.util.Fluids;
import mariculture.core.util.IItemDropBlacklist;
import mariculture.fishery.tile.TileFishTank;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockHelper {
    public static boolean isWater(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) == Blocks.field_150355_j;
    }

    public static boolean isHPWater(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) == Fluids.getFluidBlock("hp_water");
    }

    public static boolean isLava(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) == Blocks.field_150353_l;
    }

    public static boolean isFishLiveable(World world, int x, int y, int z) {
        if (world.field_73011_w.field_76575_d) {
            return BlockHelper.isLava(world, x, y, z);
        }
        return BlockHelper.isWater(world, x, y, z);
    }

    public static boolean isFishable(World world, int x, int y, int z) {
        return BlockHelper.isWater(world, x, y, z) || BlockHelper.isLava(world, x, y, z) && world.field_73011_w.field_76575_d;
    }

    public static boolean isAir(World world, int x, int y, int z) {
        if (world.func_72863_F().func_73149_a(x >> 4, z >> 4)) {
            try {
                return world.func_147437_c(x, y, z);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return false;
    }

    public static void setBlock(World world, int x, int y, int z, Block block, int meta) {
        if (world.func_72863_F().func_73149_a(x >> 4, z >> 4)) {
            try {
                world.func_147465_d(x, y, z, block, meta, 3);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static Block getBlock(World world, int x, int y, int z) {
        if (world.func_72863_F().func_73149_a(x >> 4, z >> 4)) {
            try {
                return world.func_147439_a(x, y, z);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return Blocks.field_150348_b;
    }

    public static int getMeta(World world, int x, int y, int z) {
        if (world.func_72863_F().func_73149_a(x >> 4, z >> 4)) {
            try {
                return world.func_72805_g(x, y, z);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return -1;
    }

    public static boolean chunkExists(World world, int x, int z) {
        return world.func_72863_F().func_73149_a(x >> 4, z >> 4);
    }

    public static String getName(ItemStack stack) {
        return stack != null ? stack.func_77973_b().func_77653_i(stack) : "";
    }

    public static String getName(TileEntity tile) {
        return tile != null ? BlockHelper.getName(new ItemStack(tile.func_145838_q(), 1, tile.func_145832_p())) : "";
    }

    public static ForgeDirection rotate(ForgeDirection dir, int num) {
        if (dir == ForgeDirection.NORTH) {
            return ForgeDirection.EAST;
        }
        if (dir == ForgeDirection.EAST) {
            return num == 2 ? ForgeDirection.NORTH : ForgeDirection.SOUTH;
        }
        if (dir == ForgeDirection.SOUTH) {
            return ForgeDirection.WEST;
        }
        if (dir == ForgeDirection.WEST) {
            return num == 6 ? ForgeDirection.UP : ForgeDirection.NORTH;
        }
        if (dir == ForgeDirection.UP) {
            return ForgeDirection.DOWN;
        }
        return ForgeDirection.NORTH;
    }

    public static ForgeDirection rotate(ForgeDirection dir) {
        return BlockHelper.rotate(dir, 6);
    }

    public static void dropItems(World world, int x, int y, int z) {
        Random rand = world.field_73012_v;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof IInventory)) {
            return;
        }
        if (tile instanceof TileMultiBlock) {
            TileMultiBlock multi = (TileMultiBlock)tile;
            if (multi.master != null && !multi.isMaster()) {
                return;
            }
        }
        IInventory inventory = (IInventory)tile;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack item;
            boolean drop = true;
            if (tile instanceof IItemDropBlacklist) {
                drop = ((IItemDropBlacklist)tile).doesDrop(i);
            }
            if (!drop || (item = inventory.func_70301_a(i)) == null || item.field_77994_a <= 0) continue;
            float rx = rand.nextFloat() * 0.6f + 0.1f;
            float ry = rand.nextFloat() * 0.6f + 0.1f;
            float rz = rand.nextFloat() * 0.6f + 0.1f;
            EntityItem entity_item = new EntityItem(world, (double)((float)x + rx), (double)((float)y + ry), (double)((float)z + rz), new ItemStack(item.func_77973_b(), item.field_77994_a, item.func_77960_j()));
            if (item.func_77942_o()) {
                entity_item.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entity_item.field_70159_w = rand.nextGaussian() * (double)factor;
            entity_item.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entity_item.field_70179_y = rand.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entity_item);
            item.field_77994_a = 0;
        }
    }

    public static void dropFish(World world, int x, int y, int z) {
        Random rand = world.field_73012_v;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileFishTank) {
            HashMap<Integer, ItemStack> fish = ((TileFishTank)tile).fish;
            for (Map.Entry<Integer, ItemStack> pairs : fish.entrySet()) {
                ItemStack stack = pairs.getValue();
                if (stack == null || stack.field_77994_a <= 0) continue;
                float rx = rand.nextFloat() * 0.6f + 0.1f;
                float ry = rand.nextFloat() * 0.6f + 0.1f;
                float rz = rand.nextFloat() * 0.6f + 0.1f;
                EntityItem entity_item = new EntityItem(world, (double)((float)x + rx), (double)((float)y + ry), (double)((float)z + rz), new ItemStack(stack.func_77973_b(), stack.field_77994_a, stack.func_77960_j()));
                if (stack.func_77942_o()) {
                    entity_item.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
                }
                float factor = 0.05f;
                entity_item.field_70159_w = rand.nextGaussian() * (double)factor;
                entity_item.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
                entity_item.field_70179_y = rand.nextGaussian() * (double)factor;
                world.func_72838_d((Entity)entity_item);
                stack.field_77994_a = 0;
            }
        }
        BlockHelper.dropItems(world, x, y, z);
    }

    private static boolean removeBlock(World world, EntityPlayerMP player, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int l = world.func_72805_g(x, y, z);
        block.func_149681_a(world, x, y, z, l, (EntityPlayer)player);
        boolean flag = block.removedByPlayer(world, (EntityPlayer)player, x, y, z, true);
        if (flag) {
            block.func_149664_b(world, x, y, z, l);
        }
        return flag;
    }

    public static void destroyBlock(World world, int x, int y, int z) {
        BlockHelper.destroyBlock(world, x, y, z, null, null);
    }

    public static void destroyBlock(World world, int x, int y, int z, Block required, ItemStack held) {
        if (!(world instanceof WorldServer)) {
            return;
        }
        Block block = world.func_147439_a(x, y, z);
        if (required != null && block != required) {
            return;
        }
        if (block.func_149712_f(world, x, y, z) < 0.0f) {
            return;
        }
        FakePlayer player = PlayerHelper.getFakePlayer(world);
        if (player != null && held != null) {
            player.func_70062_b(0, held.func_77946_l());
        }
        int l = world.func_72805_g(x, y, z);
        world.func_72889_a((EntityPlayer)player, 2001, x, y, z, Block.func_149682_b((Block)block) + (world.func_72805_g(x, y, z) << 12));
        boolean flag = BlockHelper.removeBlock(world, (EntityPlayerMP)player, x, y, z);
        if (flag) {
            block.func_149636_a(world, (EntityPlayer)player, x, y, z, l);
        }
    }
}

