/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mariculture.api.core.IBlacklisted;
import mariculture.core.gui.feature.FeatureEject;
import mariculture.core.helpers.SpawnItemHelper;
import mariculture.core.helpers.cofh.InventoryHelper;
import mariculture.core.tile.base.TileMultiBlock;
import mariculture.core.tile.base.TileMultiStorage;
import mariculture.core.tile.base.TileMultiStorageTank;
import mariculture.core.util.IEjectable;
import mariculture.core.util.IMachine;
import mariculture.core.util.ITank;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public class BlockTransferHelper {
    private static List<Integer> sides = new ArrayList<Integer>();
    public TileEntity thisTile;
    public IFluidHandler handler;
    public IInventory inventory;
    public World world;
    int x;
    int y;
    int z;

    public static List<Integer> getSides() {
        Collections.shuffle(sides);
        return sides;
    }

    public BlockTransferHelper(TileEntity tile) {
        this.thisTile = tile;
        this.world = tile.func_145831_w();
        this.x = tile.field_145851_c;
        this.y = tile.field_145848_d;
        this.z = tile.field_145849_e;
        if (tile instanceof IInventory) {
            this.inventory = (IInventory)tile;
        }
        if (this.inventory instanceof IFluidHandler) {
            this.handler = (IFluidHandler)tile;
        }
    }

    public boolean ejectFluid(int[] rate) {
        boolean canEject = true;
        if (this.handler instanceof IEjectable) {
            TileMultiStorageTank tile;
            IEjectable ejectable = (IEjectable)this.handler;
            if (ejectable instanceof TileMultiStorageTank && (tile = (TileMultiStorageTank)this.handler).getMaster() != null) {
                ejectable = (IEjectable)((Object)tile.getMaster());
            }
            canEject = FeatureEject.EjectSetting.canEject(ejectable.getEjectSetting(), FeatureEject.EjectSetting.FLUID);
        }
        if (canEject) {
            for (Integer side : BlockTransferHelper.getSides()) {
                IFluidHandler tank;
                ForgeDirection dir = ForgeDirection.getOrientation((int)side);
                TileEntity tile = this.world.func_147438_o(this.x + dir.offsetX, this.y + dir.offsetY, this.z + dir.offsetZ);
                if (this.isSameBlock(tile) || !(tile instanceof IFluidHandler) || (tank = (IFluidHandler)tile) instanceof IBlacklisted && ((IBlacklisted)tank).isBlacklisted(this.world, this.x, this.y, this.z)) continue;
                for (int drain : rate) {
                    if (!this.transfer(tank, dir.getOpposite(), drain)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean transfer(IFluidHandler tank, ForgeDirection from, int transfer) {
        if (this.handler instanceof ITank) {
            TileMultiStorageTank tile;
            ITank machine = (ITank)this.handler;
            if (this.handler instanceof TileMultiStorageTank && (tile = (TileMultiStorageTank)this.handler).getMaster() != null) {
                machine = (ITank)((Object)tile.getMaster());
            }
            if (machine.getFluid(transfer) != null && tank.fill(from, machine.getFluid(transfer), false) >= transfer) {
                tank.fill(from, machine.getFluid(transfer), true);
                ((IFluidHandler)machine).drain(from, machine.getFluid(transfer), true);
                return true;
            }
        }
        return false;
    }

    public ItemStack insertStack(ItemStack stack, int[] slots) {
        if (this.inventory instanceof IEjectable) {
            TileMultiBlock tile;
            IEjectable ejectable = (IEjectable)this.inventory;
            if (ejectable instanceof TileMultiStorage && (tile = (TileMultiStorage)this.inventory).getMaster() != null) {
                ejectable = (IEjectable)((Object)tile.getMaster());
            }
            if (ejectable != null && FeatureEject.EjectSetting.canEject(ejectable.getEjectSetting(), FeatureEject.EjectSetting.ITEM)) {
                if (this.inventory instanceof TileMultiBlock) {
                    tile = (TileMultiBlock)this.inventory;
                    if (tile.getMaster() != null) {
                        TileMultiBlock master = tile.getMaster();
                        ArrayList<TileMultiBlock.MultiPart> cords = master.slaves;
                        Collections.shuffle(cords);
                        for (TileMultiBlock.MultiPart cord : cords) {
                            if (this.world.func_147438_o(cord.xCoord, cord.yCoord, cord.zCoord) == null) continue;
                            BlockTransferHelper helper = new BlockTransferHelper(this.world.func_147438_o(cord.xCoord, cord.yCoord, cord.zCoord));
                            stack = helper.ejectToSides(stack);
                        }
                        stack = new BlockTransferHelper(master).ejectToSides(stack);
                    }
                } else {
                    stack = this.ejectToSides(stack);
                }
            }
        }
        if (stack != null) {
            if (!(this.inventory instanceof IMachine)) {
                return SpawnItemHelper.spawnItem(this, stack);
            }
            if (!InventoryHelper.addItemStackToInventory(((IMachine)this.inventory).getInventory(), stack, slots)) {
                return SpawnItemHelper.spawnItem(this, stack);
            }
        }
        return null;
    }

    private ItemStack ejectToSides(ItemStack stack) {
        Collections.shuffle(sides);
        for (Integer side : sides) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)side);
            TileEntity tile = this.world.func_147438_o(this.x + dir.offsetX, this.y + dir.offsetY, this.z + dir.offsetZ);
            if (!(tile instanceof IInventory) || tile instanceof TileEntityHopper || this.isSameBlock(tile)) continue;
            stack = InventoryHelper.insertItemStackIntoInventory((IInventory)tile, stack, dir.getOpposite().ordinal());
        }
        return stack;
    }

    private boolean isSameBlock(TileEntity tile) {
        return tile != null && this.inventory != null && tile.getClass().equals(this.thisTile.getClass());
    }

    static {
        for (int i = 0; i < 6; ++i) {
            sides.add(i);
        }
    }
}

