/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.helpers;

import java.util.HashMap;
import java.util.List;
import mariculture.api.util.Text;
import mariculture.core.Core;
import mariculture.core.blocks.base.BlockFluid;
import mariculture.core.helpers.RegistryHelper;
import mariculture.core.lib.MetalRates;
import mariculture.core.lib.Modules;
import mariculture.core.util.FluidMari;
import mariculture.core.util.Fluids;
import mariculture.fishery.FishFoodHandler;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class FluidHelper {
    public static HashMap<String, ItemStack> empties = new HashMap();

    public static boolean isFluidOrEmpty(ItemStack stack) {
        return FluidHelper.isEmpty(stack) || FluidHelper.isFilled(stack) || FluidHelper.isVoid(stack) || FishFoodHandler.isFishFood(stack);
    }

    public static boolean isEmpty(ItemStack stack) {
        return FluidContainerRegistry.isEmptyContainer((ItemStack)stack);
    }

    public static boolean isFilled(ItemStack stack) {
        return FluidContainerRegistry.isFilledContainer((ItemStack)stack);
    }

    public static boolean isVoid(ItemStack stack) {
        return stack != null && stack.func_77973_b() == Core.bottles && stack.func_77960_j() == 0;
    }

    public static boolean isIContainer(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof IFluidContainerItem;
    }

    public static ItemStack getFluidResult(IFluidHandler tile, ItemStack top, ItemStack bottom) {
        if (top != null) {
            if (FluidHelper.isVoid(top)) {
                return FluidHelper.doVoid(tile, top, bottom);
            }
            if (FluidHelper.isEmpty(top)) {
                return FluidHelper.doFill(tile, top, bottom);
            }
            if (FluidHelper.isFilled(top)) {
                return FluidHelper.doEmpty(tile, top, bottom);
            }
            if (FluidHelper.isIContainer(top)) {
                return FluidHelper.doIContainer(tile, top, bottom);
            }
            if (FishFoodHandler.isFishFood(top)) {
                return FluidHelper.addFishFood(tile, top);
            }
        }
        return null;
    }

    private static ItemStack addFishFood(IFluidHandler tile, ItemStack stack) {
        int increase = FishFoodHandler.getValue(stack);
        int fill = tile.fill(ForgeDirection.UP, Fluids.getFluidStack("fish_food", increase), false);
        if (fill >= increase) {
            tile.fill(ForgeDirection.UP, Fluids.getFluidStack("fish_food", increase), true);
            return new ItemStack(Core.air);
        }
        return null;
    }

    public static void registerException(ItemStack filled, ItemStack empty) {
        empties.put(Item.field_150901_e.func_148750_c((Object)filled.func_77973_b()) + ":" + filled.func_77960_j(), empty);
    }

    public static ItemStack getEmptyContainerForFilledItem(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null || empties == null) {
            return null;
        }
        ItemStack result = empties.get(Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()) + ":" + stack.func_77960_j());
        return result != null ? result : (stack.func_77973_b().hasContainerItem(stack) ? stack.func_77973_b().getContainerItem(stack) : null);
    }

    private static ItemStack doEmpty(IFluidHandler tile, ItemStack top, ItemStack bottom) {
        ItemStack result = FluidHelper.getEmptyContainerForFilledItem(top);
        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)top);
        if (result != null && tile.fill(ForgeDirection.UNKNOWN, fluid, false) == fluid.amount && FluidHelper.matches(top, bottom, result)) {
            tile.fill(ForgeDirection.UNKNOWN, fluid, true);
            return result;
        }
        return null;
    }

    private static ItemStack doFill(IFluidHandler tile, ItemStack top, ItemStack bottom) {
        ItemStack result = FluidContainerRegistry.fillFluidContainer((FluidStack)tile.drain(ForgeDirection.UNKNOWN, 100000, false), (ItemStack)top);
        if (result != null && FluidHelper.matches(top, bottom, result)) {
            FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)result);
            tile.drain(ForgeDirection.UNKNOWN, fluid.amount, true);
            return result;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ItemStack doIContainer(IFluidHandler tile, ItemStack top, ItemStack bottom) {
        if (bottom != null) {
            return null;
        }
        IFluidContainerItem container = (IFluidContainerItem)top.func_77973_b();
        FluidStack fluid = container.getFluid(top);
        if (fluid != null) {
            FluidStack stack = container.drain(top, 1000000, false);
            if (stack == null) return top;
            stack.amount = tile.fill(ForgeDirection.UNKNOWN, stack, false);
            if (stack.amount <= 0) return null;
            container.drain(top, stack.amount, true);
            tile.fill(ForgeDirection.UNKNOWN, stack, true);
            return top;
        } else {
            FluidStack stack = tile.drain(ForgeDirection.UNKNOWN, MetalRates.INGOT, true);
            if (stack == null || stack.amount <= 0) return null;
            container.fill(top, stack, true);
        }
        return top;
    }

    public static ItemStack doVoid(IFluidHandler tile, ItemStack top, ItemStack bottom) {
        if (FluidHelper.matches(top, bottom, new ItemStack(Core.bottles, 1, 20))) {
            FluidStack fluid = tile.drain(ForgeDirection.UNKNOWN, Short.MAX_VALUE, false);
            if (fluid == null || fluid != null && fluid.amount <= 0) {
                return null;
            }
            tile.drain(ForgeDirection.UNKNOWN, Short.MAX_VALUE, true);
            return new ItemStack(Core.bottles, 1, 20);
        }
        return null;
    }

    public static void process(IInventory invent, int in, int out) {
        ItemStack result = FluidHelper.getFluidResult((IFluidHandler)invent, invent.func_70301_a(in), invent.func_70301_a(out));
        if (result != null) {
            invent.func_70298_a(in, 1);
            if (result.func_77973_b() != Item.func_150898_a((Block)Core.air)) {
                if (invent.func_70301_a(out) == null) {
                    invent.func_70299_a(out, result.func_77946_l());
                } else if (invent.func_70301_a(out).func_77973_b() == result.func_77973_b()) {
                    ItemStack stack = invent.func_70301_a(out);
                    ++stack.field_77994_a;
                    invent.func_70299_a(out, stack);
                }
            }
        }
    }

    public static int getRequiredVolumeForBlock(Fluid fluid) {
        FluidContainerRegistry.FluidContainerData[] data = FluidContainerRegistry.getRegisteredFluidContainerData();
        int highest = -1;
        for (FluidContainerRegistry.FluidContainerData element : data) {
            if (element.fluid.fluidID != fluid.getID()) continue;
            if (element.fluid.amount > highest) {
                highest = element.fluid.amount;
            }
            if (element.emptyContainer.func_77973_b() != Items.field_151133_ar) continue;
            return element.fluid.amount;
        }
        return highest;
    }

    public static boolean matches(ItemStack top, ItemStack bottom, ItemStack result) {
        if (bottom == null) {
            return true;
        }
        return bottom.func_77969_a(result) && bottom.field_77994_a < 64 && bottom.field_77994_a < bottom.func_77976_d();
    }

    public static String getName(Fluid fluid) {
        if (fluid == null) {
            return null;
        }
        if (fluid.getID() > 0) {
            String name = fluid.getLocalizedName();
            if (name.startsWith("fluid.") && (name = name.substring(6)).startsWith("tile.")) {
                name = name.substring(5);
            }
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return null;
    }

    public static boolean handleFillOrDrain(IFluidHandler tank, EntityPlayer player, ForgeDirection side) {
        ItemStack heldItem = player.field_71071_by.func_70448_g();
        FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)heldItem);
        ItemStack newHeld = FluidHelper.getEmptyContainerForFilledItem(heldItem);
        if (newHeld != null && newHeld.field_77994_a == 0) {
            newHeld.field_77994_a = 1;
        }
        if (liquid != null) {
            int amount = tank.fill(ForgeDirection.UNKNOWN, liquid, false);
            if (amount >= liquid.amount) {
                tank.fill(ForgeDirection.UNKNOWN, liquid, true);
                if (!player.field_71075_bZ.field_75098_d) {
                    if (heldItem.field_77994_a == 1) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, newHeld);
                    } else {
                        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                        if (!player.field_71071_by.func_70441_a(newHeld)) {
                            player.func_71019_a(newHeld, true);
                        }
                    }
                }
                return true;
            }
            return true;
        }
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)heldItem)) {
            ItemStack result = FluidContainerRegistry.fillFluidContainer((FluidStack)tank.drain(ForgeDirection.UNKNOWN, 100000, false), (ItemStack)heldItem);
            FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)result);
            if (result != null) {
                tank.drain(side, fluid.amount, true);
                if (!player.field_71075_bZ.field_75098_d) {
                    if (heldItem.field_77994_a == 1) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, result);
                    } else {
                        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                        if (!player.field_71071_by.func_70441_a(result)) {
                            player.func_71019_a(result, true);
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static String getFluidName(FluidStack fluid) {
        if (fluid == null || fluid.getFluid() == null || fluid.amount <= 0) {
            return "\u00a7f" + StatCollector.func_74838_a((String)"mariculture.string.empty");
        }
        return FluidHelper.getFluidName(fluid.getFluid());
    }

    public static String getFluidName(Fluid fluid) {
        String fluidName = "";
        if (fluid.getRarity() == EnumRarity.uncommon) {
            fluidName = fluidName + "\u00a7e";
        } else if (fluid.getRarity() == EnumRarity.rare) {
            fluidName = fluidName + "\u00a7b";
        } else if (fluid.getRarity() == EnumRarity.epic) {
            fluidName = fluidName + "\u00a7d";
        }
        fluidName = fluidName + fluid.getLocalizedName() + "\u00a7r";
        return fluidName;
    }

    public static List getFluidQty(List tooltip, FluidStack fluid, int max) {
        if (fluid == null || fluid.getFluid() == null) {
            tooltip.add("\u00a770" + (max > 0 ? "/" + max + Text.translate("mb") : Text.translate("mb")));
        } else if (Modules.isActive(Modules.fishery) && fluid.fluidID == Fluids.getFluidID("fish_food")) {
            tooltip.add("\u00a77" + fluid.amount + (max > 0 ? "/" + max + " " + StatCollector.func_74838_a((String)"mariculture.string.pieces") : " " + StatCollector.func_74838_a((String)"mariculture.string.pieces")));
        } else if (fluid.getFluid().getName().contains("glass") || fluid.getFluid().getName().contains("salt") || fluid.getFluid().getName().contains("dirt")) {
            tooltip.add("\u00a77" + fluid.amount + (max > 0 ? "/" + max + Text.translate("mb") : Text.translate("mb")));
        } else if (fluid.getFluid().getName().contains("molten")) {
            int mB;
            int ingots = fluid.amount / MetalRates.INGOT;
            if (ingots > 0) {
                tooltip.add("\u00a77" + StatCollector.func_74838_a((String)"mariculture.string.ingots") + ": " + ingots);
            }
            if ((mB = fluid.amount % MetalRates.INGOT) > 0) {
                int nuggets = mB / MetalRates.NUGGET;
                int junk = mB % MetalRates.NUGGET;
                if (nuggets > 0) {
                    tooltip.add("\u00a77" + StatCollector.func_74838_a((String)"mariculture.string.nuggets") + ": " + nuggets);
                }
                if (junk > 0) {
                    tooltip.add("\u00a77" + Text.translate("mb") + ": " + junk);
                }
            }
            if (max > 0) {
                tooltip.add("");
                tooltip.add("\u00a77" + StatCollector.func_74838_a((String)"mariculture.string.outof"));
                tooltip.add("\u00a77" + max / MetalRates.INGOT + " " + StatCollector.func_74838_a((String)"mariculture.string.ingots") + " & " + max % MetalRates.INGOT + Text.translate("mb"));
            }
        } else {
            tooltip.add("\u00a77" + fluid.amount + (max > 0 ? "/" + max + Text.translate("mb") : Text.translate("mb")));
        }
        return tooltip;
    }

    public static void addGas(String field, String name, int volume, int bottleMeta) {
        FluidHelper.addFluid(field, name, volume, bottleMeta, true, 1000);
    }

    public static void addFluid(String field, String name, int volume, int bottleMeta, int balance) {
        FluidHelper.addFluid(field, name, volume, bottleMeta, false, balance);
    }

    public static void addFluid(String field, String name, int volume, int bottleMeta, boolean isGas, int balance) {
        Fluid fluid = new FluidMari(name, bottleMeta).setUnlocalizedName(name).setGaseous(isGas);
        if (Fluids.add(field, fluid, balance)) {
            FluidRegistry.registerFluid((Fluid)Fluids.getFluid(field));
        } else {
            fluid = Fluids.getFluid(field);
        }
        if (volume != -1) {
            FluidHelper.registerHeatBottle(fluid, volume, bottleMeta);
        }
    }

    public static void registerHeatBottle(Fluid fluid, int vol, int meta) {
        FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(fluid, vol), (ItemStack)new ItemStack(Core.bottles, 1, meta), (ItemStack)new ItemStack(Core.bottles, 1, 20));
    }

    public static void registerVanillaBottle(Fluid fluid, int vol, int meta) {
        FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(fluid, vol), (ItemStack)new ItemStack(Core.bottles, 1, meta), (ItemStack)new ItemStack(Items.field_151069_bo));
    }

    public static void addFluid(String name, int volume, int meta, int balance) {
        FluidHelper.addFluid(name, name, volume, meta, balance);
    }

    public static void registerBucket(Fluid fluid, int vol, int meta) {
        FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(fluid, vol), (ItemStack)new ItemStack(Core.buckets, 1, meta), (ItemStack)new ItemStack(Items.field_151133_ar));
    }

    public static boolean areEqual(FluidStack fluid1, FluidStack fluid2) {
        if (fluid1 == null || fluid2 == null || fluid1.getFluid() == null || fluid2.getFluid() == null) {
            return false;
        }
        return fluid1.getFluid().getName().equals(fluid2.getFluid().getName());
    }

    public static void setBlock(Fluid fluid, Block block) {
        if (fluid.getBlock() == null) {
            fluid.setBlock(block);
        }
    }

    public static void addFluid(String string, int balance) {
        FluidHelper.addFluid(string, -1, -1, balance);
    }

    public static boolean setBlock(Class<? extends BlockFluid> clazz, String fluid) {
        return FluidHelper.setBlock(clazz, fluid, fluid);
    }

    public static boolean setBlock(Class<? extends BlockFluid> clazz, String fName, String name) {
        Fluid fluid = FluidRegistry.getFluid((String)Fluids.getFluidName(fName));
        if (fluid.getBlock() != null) {
            return Fluids.setBlock(fName, fluid.getBlock());
        }
        try {
            Block block = ((Block)clazz.getDeclaredConstructor(Fluid.class, Material.class).newInstance(fluid, Material.field_151586_h)).func_149663_c(name);
            RegistryHelper.registerBlocks(new Block[]{block});
            return Fluids.setBlock(fName, block);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

