/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.helpers;

import cpw.mods.fml.common.registry.GameRegistry;
import mariculture.api.core.FuelInfo;
import mariculture.api.core.IAnvilHandler;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.core.RecipeCasting;
import mariculture.api.core.RecipeSmelter;
import mariculture.api.core.RecipeVat;
import mariculture.core.Core;
import mariculture.core.lib.MetalRates;
import mariculture.core.util.Fluids;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeHelper {
    public static ItemStack _(Block block) {
        return new ItemStack(block);
    }

    public static ItemStack _(Item item) {
        return new ItemStack(item);
    }

    public static ItemStack _(ItemStack stack, int amount) {
        ItemStack ret = stack.func_77946_l();
        ret.field_77994_a = amount;
        return ret;
    }

    public static ItemStack _(ItemStack stack, int dmg, int amount) {
        ItemStack ret = stack.func_77946_l();
        ret.func_77964_b(dmg);
        ret.field_77994_a = amount;
        return ret;
    }

    public static void addShaped(ItemStack result, Object[] input) {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(result, input));
    }

    public static void addShapeless(ItemStack result, Object[] input) {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapelessOreRecipe(result, input));
    }

    public static void addSmelting(ItemStack output, ItemStack input, float xp) {
        GameRegistry.addSmelting((ItemStack)input, (ItemStack)output, (float)xp);
    }

    public static void addVatItemRecipe(Object input, String fluid, int vol, ItemStack output, int time) {
        MaricultureHandlers.vat.addRecipe(new RecipeVat(input, FluidRegistry.getFluidStack((String)fluid, (int)vol), output, time));
    }

    public static void addVatItemRecipeResultFluid(ItemStack input, FluidStack inputFluid, FluidStack output, int time) {
        MaricultureHandlers.vat.addRecipe(new RecipeVat((Object)input, inputFluid, output, time));
    }

    public static void addNuggetCasting(FluidStack fluid, ItemStack stack) {
        MaricultureHandlers.casting.addRecipe(new RecipeCasting.RecipeNuggetCasting(fluid, stack));
    }

    public static void addIngotCasting(FluidStack fluid, ItemStack stack) {
        MaricultureHandlers.casting.addRecipe(new RecipeCasting.RecipeIngotCasting(fluid, stack));
    }

    public static void addBlockCasting(FluidStack fluid, ItemStack stack) {
        MaricultureHandlers.casting.addRecipe(new RecipeCasting.RecipeBlockCasting(fluid, stack));
    }

    public static void addMetalCasting(String metal) {
        String nugget = "nugget" + metal;
        String ingot = "ingot" + metal;
        String block = "block" + metal;
        if (OreDictionary.getOres((String)nugget).size() > 0) {
            RecipeHelper.addNuggetCasting(Fluids.getFluidStack(metal.toLowerCase(), MetalRates.NUGGET), (ItemStack)OreDictionary.getOres((String)nugget).get(0));
        }
        if (OreDictionary.getOres((String)ingot).size() > 0) {
            RecipeHelper.addIngotCasting(Fluids.getFluidStack(metal.toLowerCase(), MetalRates.INGOT), (ItemStack)OreDictionary.getOres((String)ingot).get(0));
        }
        if (OreDictionary.getOres((String)block).size() > 0) {
            RecipeHelper.addBlockCasting(Fluids.getFluidStack(metal.toLowerCase(), MetalRates.BLOCK), (ItemStack)OreDictionary.getOres((String)block).get(0));
        }
    }

    public static void addFluidAlloy(FluidStack fluid1, FluidStack fluid2, FluidStack result, int time) {
        MaricultureHandlers.vat.addRecipe(new RecipeVat(fluid1, fluid2, result, time));
    }

    public static void addFluidAlloyResultItem(FluidStack fluid1, FluidStack fluid2, ItemStack result, int time) {
        MaricultureHandlers.vat.addRecipe(new RecipeVat(fluid1, fluid2, result, time));
    }

    public static void addFluidAlloyResultItemNFluid(FluidStack fluid1, FluidStack fluid2, FluidStack newFluid, ItemStack result, int time) {
        MaricultureHandlers.vat.addRecipe(new RecipeVat(fluid1, fluid2, newFluid, result, time));
    }

    public static void addFluidAlloyNItemResultItem(FluidStack fluid1, FluidStack fluid2, ItemStack input, ItemStack result, int time) {
        MaricultureHandlers.vat.addRecipe(new RecipeVat((Object)input, fluid1, fluid2, result, time));
    }

    public static void add4x4Recipe(ItemStack result, Block block, int meta) {
        RecipeHelper.addShaped(result, new Object[]{"##", "##", Character.valueOf('#'), new ItemStack(block, 1, meta)});
    }

    public static void add4x4Recipe(ItemStack result, Object input) {
        RecipeHelper.addShaped(result, new Object[]{"##", "##", Character.valueOf('#'), input});
    }

    public static void add9x9Recipe(ItemStack result, Object input) {
        RecipeHelper.addShaped(result, new Object[]{"###", "###", "###", Character.valueOf('#'), input});
    }

    public static void addUncraftingRecipe(ItemStack result, Object input) {
        RecipeHelper.addShapeless(result, new Object[]{input});
    }

    public static void addAnvilRecipe(ItemStack input, ItemStack output, int hits) {
        MaricultureHandlers.anvil.addRecipe(new IAnvilHandler.RecipeAnvil(input, output, hits));
    }

    public static void addFishingRodRecipe(ItemStack output, Object mat) {
        RecipeHelper.addShaped(output, new Object[]{"  S", " SW", "S W", Character.valueOf('S'), mat, Character.valueOf('W'), Items.field_151007_F});
    }

    public static void addMelting(ItemStack stack, int temp, FluidStack fluid) {
        MaricultureHandlers.crucible.addRecipe(new RecipeSmelter(stack, temp, fluid, null, 0));
    }

    public static void addMelting(ItemStack stack, int temp, FluidStack fluid, ItemStack output, int chance) {
        MaricultureHandlers.crucible.addRecipe(new RecipeSmelter(stack, temp, fluid, output, chance));
    }

    public static void addMelting(ItemStack stack, int temp, String fluid, int vol) {
        RecipeHelper.addMelting(stack, temp, FluidRegistry.getFluidStack((String)fluid, (int)vol));
    }

    public static void add2x2Recipe(ItemStack result, Object input) {
        RecipeHelper.addShaped(result, new Object[]{"##", "##", Character.valueOf('#'), input});
    }

    public static void add3x3Recipe(ItemStack result, Object input) {
        RecipeHelper.addShaped(result, new Object[]{"###", "###", "###", Character.valueOf('#'), input});
    }

    public static void addCrossHatchRecipe(ItemStack output, Object item1, Object item2) {
        RecipeHelper.addShaped(output, new Object[]{"CAC", "ACA", "CAC", Character.valueOf('C'), item1, Character.valueOf('A'), item2});
    }

    public static void addWheelRecipe(ItemStack output, Object wheel, Object spoke) {
        RecipeHelper.addShaped(output, new Object[]{" W ", "WSW", " W ", Character.valueOf('W'), wheel, Character.valueOf('S'), spoke});
    }

    public static void addFuel(Object obj, FuelInfo fuelInfo) {
        MaricultureHandlers.crucible.addFuel(obj, fuelInfo);
    }

    public static void addCrushRecipe(ItemStack stack, Object string, boolean needAnvil) {
        if (!needAnvil) {
            RecipeHelper.addShapeless(stack, new Object[]{string});
        }
        ItemStack result = null;
        if (string instanceof String && OreDictionary.getOres((String)((String)string)).size() > 0) {
            result = (ItemStack)OreDictionary.getOres((String)((String)string)).get(0);
        }
        if (string instanceof ItemStack) {
            result = (ItemStack)string;
        }
        if (result != null) {
            if (!needAnvil) {
                stack.field_77994_a *= 2;
            }
            RecipeHelper.addAnvilRecipe(result, stack, 10);
        }
    }

    public static void addBleachRecipe(ItemStack input, ItemStack output, int time) {
        RecipeHelper.addVatItemRecipe(input, Fluids.getFluidName("quicklime"), 50, output, time);
    }

    public static void addSoakRecipe(ItemStack input, ItemStack output, int time) {
        RecipeHelper.addVatItemRecipe(input, "water", 100, output, time);
    }

    public static void addBookRecipe(ItemStack output, ItemStack input) {
        RecipeHelper.addShapeless(output, new Object[]{input, Items.field_151122_aG});
    }

    public static void addFishMelting(ItemStack stack, double volume, ItemStack product, int chance) {
        RecipeHelper.addMelting(stack, 180, Fluids.getFluidStack("fish_oil", (int)(volume * 1000.0)), product, chance);
    }

    public static void addFishSushi(ItemStack raw, int meal) {
        ItemStack kelp = new ItemStack(Core.food, 1, 8);
        if (OreDictionary.getOres((String)"cropRice").size() > 0) {
            RecipeHelper.addShaped(new ItemStack(Core.food, (int)Math.ceil((double)meal / 1.5), 5), new Object[]{"RKR", "KFK", "RKR", Character.valueOf('R'), kelp, Character.valueOf('F'), raw, Character.valueOf('K'), "cropRice"});
        } else {
            RecipeHelper.addShaped(new ItemStack(Core.food, (int)Math.ceil((double)meal / 1.5), 5), new Object[]{" K ", "KFK", " K ", Character.valueOf('K'), kelp, Character.valueOf('F'), raw});
        }
    }

    public static void addFishSoup(ItemStack raw, int meal) {
        ItemStack kelp = new ItemStack(Core.food, 1, 8);
        int number = (int)Math.ceil(meal / 2);
        int meta = number == 2 ? 11 : (number >= 3 ? 12 : 7);
        RecipeHelper.addShapeless(new ItemStack(Core.food, 1, meta), new Object[]{Items.field_151054_z, kelp, raw, Blocks.field_150338_P, Blocks.field_150337_Q});
    }

    public static void addFishMeal(ItemStack raw, int meal) {
        RecipeHelper.addShapeless(new ItemStack(Core.materials, meal, 14), new Object[]{raw});
    }

    public static ItemStack addUpgrade(int meta, Object[] input) {
        ItemStack result = new ItemStack(Core.upgrade, 1, meta);
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(result, input));
        return result;
    }
}

