/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.helpers;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class StackHelper {
    public static ItemStack getStackFromString(String str) {
        return StackHelper.getStackFromArray(str.trim().split(" "));
    }

    public static String getStringFromStack(ItemStack stack) {
        String str = Item.field_150901_e.func_148750_c((Object)stack.func_77973_b());
        if (stack.func_77981_g()) {
            str = str + " " + stack.func_77960_j();
        }
        if (stack.func_77942_o()) {
            str = str + " " + stack.field_77990_d.toString();
        }
        return str;
    }

    public static boolean matches(String str, ItemStack stack) {
        return StackHelper.getStringFromStack(stack).equals(str);
    }

    private static ItemStack getStackFromArray(String[] str) {
        Item item = StackHelper.getItemByText(str[0]);
        int meta = 0;
        if (str.length > 1) {
            meta = StackHelper.parseInt(str[1]);
        }
        ItemStack stack = new ItemStack(item, 1, meta);
        if (str.length > 2) {
            String s = StackHelper.formatNBT(str, 2).func_150260_c();
            try {
                NBTBase nbtbase = JsonToNBT.func_150315_a((String)s);
                if (!(nbtbase instanceof NBTTagCompound)) {
                    return null;
                }
                stack.func_77982_d((NBTTagCompound)nbtbase);
            }
            catch (Exception nbtexception) {
                return null;
            }
        }
        return stack;
    }

    private static Item getItemByText(String str) {
        Item item = (Item)Item.field_150901_e.func_82594_a(str);
        if (item == null) {
            try {
                Item item1;
                item = item1 = Item.func_150899_d((int)Integer.parseInt(str));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return item;
    }

    private static IChatComponent formatNBT(String[] str, int start) {
        ChatComponentText chatcomponenttext = new ChatComponentText("");
        for (int j = start; j < str.length; ++j) {
            if (j > start) {
                chatcomponenttext.func_150258_a(" ");
            }
            ChatComponentText object = new ChatComponentText(str[j]);
            chatcomponenttext.func_150257_a((IChatComponent)object);
        }
        return chatcomponenttext;
    }

    private static int parseInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException numberformatexception) {
            return 0;
        }
    }
}

