/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.helpers;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLHelper {
    public Element e;

    public XMLHelper(Element element) {
        this.e = element;
    }

    public Element getElement() {
        return this.e;
    }

    public XMLHelper getHelper(String name) {
        Node n = this.e.getElementsByTagName(name).item(0);
        if (n == null) {
            return this;
        }
        if (n.getNodeType() == 1) {
            return new XMLHelper((Element)n);
        }
        return this;
    }

    public String getAttribute(String name) {
        return this.e.getAttribute(name);
    }

    public String getOptionalAttribute(String name) {
        if (this.e.getAttribute(name) == null) {
            return "";
        }
        return this.e.getAttribute(name);
    }

    public boolean getAttribAsBoolean(String name) {
        if (this.e.getAttribute(name) == null) {
            return false;
        }
        return Boolean.parseBoolean(this.e.getAttribute(name));
    }

    public Integer getAttribAsInteger(String name, int dft) {
        String string = this.getAttribute(name);
        return string.equals("") ? dft : Integer.parseInt(string);
    }

    public Integer getAttribAsHex(String name, int dft) {
        String string = this.getAttribute(name);
        return string.equals("") ? dft : Integer.parseInt(string, 16);
    }

    public Float getAttribAsFloat(String name, float dft) {
        String string = this.getAttribute(name);
        return Float.valueOf(string.equals("") ? dft : Float.parseFloat(string));
    }

    public String getElement(String name) {
        return this.e.getElementsByTagName(name).item(0).getTextContent();
    }

    public String getOptionalElement(String str) {
        if (this.e.getElementsByTagName(str) == null) {
            return "";
        }
        if (this.e.getElementsByTagName(str).item(0) == null) {
            return "";
        }
        return this.e.getElementsByTagName(str).item(0).getTextContent();
    }

    public Integer getElementAsInteger(String name, int dft) {
        String string = this.getElement(name);
        return string.equals("") ? dft : Integer.parseInt(string);
    }

    public Integer getElementAsHex(String name, int dft) {
        String string = this.getElement(name);
        return string.equals("") ? dft : Integer.parseInt(string, 16);
    }

    public Float getElementAsFloat(String name, float dft) {
        String string = this.getElement(name);
        return Float.valueOf(string.equals("") ? dft : Float.parseFloat(string));
    }

    public String getSelf() {
        return this.e.getTextContent();
    }
}

