/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.helpers.cofh;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public final class BlockHelper {
    public static byte[] rotateType = new byte[4096];
    public static final int[][] SIDE_COORD_MOD = new int[][]{{0, -1, 0}, {0, 1, 0}, {0, 0, -1}, {0, 0, 1}, {-1, 0, 0}, {1, 0, 0}};
    public static final byte[] SIDE_LEFT = new byte[]{4, 5, 5, 4, 2, 3};
    public static final byte[] SIDE_RIGHT = new byte[]{5, 4, 4, 5, 3, 2};
    public static final byte[] SIDE_OPPOSITE = new byte[]{1, 0, 3, 2, 5, 4};

    private BlockHelper() {
    }

    private static MovingObjectPosition getCurrentMovingObjectPosition(EntityPlayer player) {
        double distance = player.field_71075_bZ.field_75098_d ? 5.0 : 4.5;
        Vec3 posVec = Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v);
        Vec3 lookVec = player.func_70676_i(1.0f);
        posVec.field_72448_b += (double)player.func_70047_e();
        lookVec = posVec.func_72441_c(lookVec.field_72450_a * distance, lookVec.field_72448_b * distance, lookVec.field_72449_c * distance);
        return player.field_70170_p.func_72933_a(posVec, lookVec);
    }

    public static TileEntity getAdjacentTileEntity(World world, int x, int y, int z, ForgeDirection dir) {
        return world == null ? null : world.func_147438_o(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
    }

    public static TileEntity getAdjacentTileEntity(TileEntity refTile, ForgeDirection dir) {
        return refTile == null ? null : BlockHelper.getAdjacentTileEntity(refTile.func_145831_w(), refTile.field_145851_c, refTile.field_145848_d, refTile.field_145849_e, dir);
    }

    public static int[] getAdjacentCoordinatesForSide(int x, int y, int z, int side) {
        return new int[]{x + SIDE_COORD_MOD[side][0], y + SIDE_COORD_MOD[side][1], z + SIDE_COORD_MOD[side][2]};
    }

    public static boolean canRotate(Block block) {
        return rotateType[Block.func_149682_b((Block)block)] != 0;
    }

    public static int rotateVanillaBlock(World world, int bId, int bMeta, int x, int y, int z) {
        switch (rotateType[bId]) {
            case 1: {
                return SIDE_LEFT[bMeta];
            }
            case 2: {
                if (bMeta < 6) {
                    return ++bMeta % 6;
                }
                return bMeta;
            }
            case 3: {
                if (bMeta < 2) {
                    return ++bMeta % 2;
                }
                return bMeta;
            }
            case 4: {
                return ++bMeta % 4;
            }
            case 5: {
                return ++bMeta % 8;
            }
            case 6: {
                int upper = bMeta & 0xC;
                int lower = bMeta & 3;
                return upper + ++lower % 4;
            }
            case 7: {
                return (bMeta + 4) % 12;
            }
            case 8: {
                return (bMeta + 8) % 16;
            }
            case 9: {
                int[] coords = new int[3];
                for (int i = 2; i < 6; ++i) {
                    coords = BlockHelper.getAdjacentCoordinatesForSide(x, y, z, i);
                    if (world.func_147439_a(coords[0], coords[1], coords[2]) != Blocks.field_150486_ae) continue;
                    world.func_72921_c(coords[0], coords[1], coords[2], (int)SIDE_OPPOSITE[bMeta], 1);
                    return SIDE_OPPOSITE[bMeta];
                }
                return SIDE_LEFT[bMeta];
            }
            case 10: {
                int shift = 0;
                if (bMeta > 7) {
                    bMeta -= 8;
                    shift = 8;
                }
                if (bMeta == 5) {
                    return 6 + shift;
                }
                if (bMeta == 6) {
                    return 5 + shift;
                }
                if (bMeta == 7) {
                    return 0 + shift;
                }
                if (bMeta == 0) {
                    return 7 + shift;
                }
                return bMeta + shift;
            }
            case 11: {
                return ++bMeta % 16;
            }
        }
        return bMeta;
    }

    public static int rotateVanillaBlockAlt(World world, int bId, int bMeta, int x, int y, int z) {
        switch (rotateType[bId]) {
            case 1: {
                return SIDE_RIGHT[bMeta];
            }
            case 2: {
                if (bMeta < 6) {
                    return (bMeta + 5) % 6;
                }
                return bMeta;
            }
            case 3: {
                if (bMeta < 2) {
                    return ++bMeta % 2;
                }
                return bMeta;
            }
            case 4: {
                return (bMeta + 3) % 4;
            }
            case 5: {
                return (bMeta + 7) % 8;
            }
            case 6: {
                int upper = bMeta & 0xC;
                int lower = bMeta & 3;
                return upper + (lower + 3) % 4;
            }
            case 7: {
                return (bMeta + 8) % 12;
            }
            case 8: {
                return (bMeta + 8) % 16;
            }
            case 9: {
                int[] coords = new int[3];
                for (int i = 2; i < 6; ++i) {
                    coords = BlockHelper.getAdjacentCoordinatesForSide(x, y, z, i);
                    if (world.func_147439_a(coords[0], coords[1], coords[2]) != Blocks.field_150486_ae) continue;
                    world.func_72921_c(coords[0], coords[1], coords[2], (int)SIDE_OPPOSITE[bMeta], 1);
                    return SIDE_OPPOSITE[bMeta];
                }
                return SIDE_RIGHT[bMeta];
            }
            case 10: {
                int shift = 0;
                if (bMeta > 7) {
                    bMeta -= 8;
                    shift = 8;
                }
                if (bMeta == 5) {
                    return 6 + shift;
                }
                if (bMeta == 6) {
                    return 5 + shift;
                }
                if (bMeta == 7) {
                    return 0 + shift;
                }
                if (bMeta == 0) {
                    return 7 + shift;
                }
            }
            case 11: {
                return ++bMeta % 16;
            }
        }
        return bMeta;
    }

    static {
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150364_r)] = 7;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150363_s)] = 7;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150367_z)] = 2;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150324_C)] = -1;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150318_D)] = 3;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150319_E)] = 3;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150320_F)] = 2;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150331_J)] = 2;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150333_U)] = 8;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150476_ad)] = 5;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150486_ae)] = 9;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150460_al)] = 1;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150472_an)] = 11;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150448_aq)] = 3;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150446_ar)] = 5;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150442_at)] = 10;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150423_aK)] = 4;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150428_aP)] = 4;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150416_aS)] = 6;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150413_aR)] = 6;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150389_bf)] = 5;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150390_bg)] = 5;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150387_bl)] = 5;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150376_bx)] = 8;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150372_bz)] = 5;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150477_bB)] = 1;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150485_bF)] = 5;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150487_bG)] = 5;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150481_bH)] = 5;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150370_cb)] = 5;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150438_bZ)] = 2;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150408_cc)] = 3;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150409_cd)] = 2;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150400_ck)] = 5;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150401_cl)] = 5;
    }

    public static final class RotationType {
        public static final int PREVENT = -1;
        public static final int FOUR_WAY = 1;
        public static final int SIX_WAY = 2;
        public static final int RAIL = 3;
        public static final int PUMPKIN = 4;
        public static final int STAIRS = 5;
        public static final int REDSTONE = 6;
        public static final int LOG = 7;
        public static final int SLAB = 8;
        public static final int CHEST = 9;
        public static final int LEVER = 10;
        public static final int SIGN = 11;
    }
}

