/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.helpers.cofh;

import mariculture.core.helpers.cofh.ItemHelper;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;

public class InventoryHelper {
    private InventoryHelper() {
    }

    private static boolean addItemStackToInventory(ItemStack[] inventory, ItemStack stack, int startIndex) {
        if (stack == null) {
            return true;
        }
        int openSlot = -1;
        for (int i = startIndex; i < inventory.length; ++i) {
            if (ItemHelper.areItemStacksEqualWithNBT(stack, inventory[i]) && inventory[i].func_77976_d() > inventory[i].field_77994_a) {
                int hold = inventory[i].func_77976_d() - inventory[i].field_77994_a;
                if (hold >= stack.field_77994_a) {
                    inventory[i].field_77994_a += stack.field_77994_a;
                    stack = null;
                    return true;
                }
                stack.field_77994_a -= hold;
                inventory[i].field_77994_a += hold;
                continue;
            }
            if (inventory[i] != null || openSlot != -1) continue;
            openSlot = i;
        }
        if (stack != null) {
            if (openSlot > -1) {
                inventory[openSlot] = stack;
            } else {
                return false;
            }
        }
        return true;
    }

    public static boolean addItemStackToInventory(ItemStack[] inventory, ItemStack stack, int[] slots) {
        if (stack == null) {
            return true;
        }
        if (slots == null) {
            return false;
        }
        int openSlot = -1;
        for (int i : slots) {
            if (ItemHelper.areItemStacksEqualWithNBT(stack, inventory[i]) && inventory[i].func_77976_d() > inventory[i].field_77994_a) {
                int hold = inventory[i].func_77976_d() - inventory[i].field_77994_a;
                if (hold >= stack.field_77994_a) {
                    inventory[i].field_77994_a += stack.field_77994_a;
                    stack = null;
                    return true;
                }
                stack.field_77994_a -= hold;
                inventory[i].field_77994_a += hold;
                continue;
            }
            if (inventory[i] != null || openSlot != -1) continue;
            openSlot = i;
        }
        if (stack != null) {
            if (openSlot > -1) {
                inventory[openSlot] = stack;
            } else {
                return false;
            }
        }
        return true;
    }

    public static boolean canAddItemStackToInventory(ItemStack[] inventory, ItemStack stack, int[] slots) {
        if (stack == null) {
            return true;
        }
        int openSlot = -1;
        for (int i : slots) {
            if (ItemHelper.areItemStacksEqualWithNBT(stack, inventory[i]) && inventory[i].func_77976_d() > inventory[i].field_77994_a) {
                return true;
            }
            if (inventory[i] != null || openSlot != -1) continue;
            openSlot = i;
        }
        return openSlot > -1;
    }

    public static ItemStack extractItemStackFromInventory(IInventory theInventory, int side) {
        ItemStack retStack = null;
        if (theInventory instanceof ISidedInventory) {
            ISidedInventory sidedInv = (ISidedInventory)theInventory;
            int[] slots = sidedInv.func_94128_d(side);
            for (int i = 0; i < slots.length && retStack == null; ++i) {
                if (sidedInv.func_70301_a(i) == null || !sidedInv.func_102008_b(i, sidedInv.func_70301_a(i), side)) continue;
                retStack = sidedInv.func_70301_a(i).func_77946_l();
                sidedInv.func_70299_a(i, null);
            }
        } else {
            for (int i = 0; i < theInventory.func_70302_i_() && retStack == null; ++i) {
                if (theInventory.func_70301_a(i) == null) continue;
                retStack = theInventory.func_70301_a(i).func_77946_l();
                theInventory.func_70299_a(i, null);
            }
        }
        if (retStack != null) {
            theInventory.func_70296_d();
        }
        return retStack;
    }

    public static ItemStack insertItemStackIntoInventory(IInventory theInventory, ItemStack stack, int side) {
        if (stack == null) {
            return null;
        }
        int stackSize = stack.field_77994_a;
        if (theInventory instanceof ISidedInventory) {
            int i;
            ISidedInventory sidedInv = (ISidedInventory)theInventory;
            int[] slots = sidedInv.func_94128_d(side);
            if (slots == null) {
                return stack;
            }
            for (i = 0; i < slots.length && stack != null; ++i) {
                if (!sidedInv.func_102007_a(slots[i], stack, side) || !ItemHelper.itemsEqualWithMetadata(stack, theInventory.func_70301_a(slots[i]), true)) continue;
                stack = InventoryHelper.addToOccupiedInventorySlot((IInventory)sidedInv, slots[i], stack);
            }
            for (i = 0; i < slots.length && stack != null; ++i) {
                if (!sidedInv.func_102007_a(slots[i], stack, side) || theInventory.func_70301_a(slots[i]) != null) continue;
                stack = InventoryHelper.addToEmptyInventorySlot((IInventory)sidedInv, slots[i], stack);
            }
        } else {
            int i;
            int invSize = theInventory.func_70302_i_();
            for (i = 0; i < invSize && stack != null; ++i) {
                if (!ItemHelper.itemsEqualWithMetadata(stack, theInventory.func_70301_a(i), true)) continue;
                stack = InventoryHelper.addToOccupiedInventorySlot(theInventory, i, stack);
            }
            for (i = 0; i < invSize && stack != null; ++i) {
                if (theInventory.func_70301_a(i) != null) continue;
                stack = InventoryHelper.addToEmptyInventorySlot(theInventory, i, stack);
            }
        }
        if (stack == null || stack.field_77994_a != stackSize) {
            theInventory.func_70296_d();
        }
        return stack;
    }

    public static boolean canInsertItemStackIntoInventory(IInventory theInventory, ItemStack stack, int side) {
        if (stack == null) {
            return false;
        }
        ItemStack original = stack.func_77946_l();
        int stackSize = stack.field_77994_a;
        if (theInventory instanceof ISidedInventory) {
            int i;
            ISidedInventory sidedInv = (ISidedInventory)theInventory;
            int[] slots = sidedInv.func_94128_d(side);
            if (slots == null) {
                return false;
            }
            for (i = 0; i < slots.length && stack != null; ++i) {
                if (!sidedInv.func_102007_a(slots[i], stack, side) || !ItemHelper.itemsEqualWithMetadata(stack, theInventory.func_70301_a(slots[i]), true)) continue;
                stack = InventoryHelper.simulateAddToOccupiedInventorySlot((IInventory)sidedInv, slots[i], stack);
            }
            for (i = 0; i < slots.length && stack != null; ++i) {
                if (!sidedInv.func_102007_a(slots[i], stack, side) || theInventory.func_70301_a(slots[i]) != null) continue;
                stack = InventoryHelper.simulateAddToEmptyInventorySlot((IInventory)sidedInv, slots[i], stack);
            }
        } else {
            int i;
            int invSize = theInventory.func_70302_i_();
            for (i = 0; i < invSize && stack != null; ++i) {
                if (!ItemHelper.itemsEqualWithMetadata(stack, theInventory.func_70301_a(i), true)) continue;
                stack = InventoryHelper.simulateAddToOccupiedInventorySlot(theInventory, i, stack);
            }
            for (i = 0; i < invSize && stack != null; ++i) {
                if (theInventory.func_70301_a(i) != null) continue;
                stack = InventoryHelper.simulateAddToEmptyInventorySlot(theInventory, i, stack);
            }
        }
        return stack == null || stack.field_77994_a == 0;
    }

    private static ItemStack addToEmptyInventorySlot(IInventory theInventory, int slot, ItemStack stack) {
        if (!theInventory.func_94041_b(slot, stack)) {
            return stack;
        }
        int stackLimit = theInventory.func_70297_j_();
        theInventory.func_70299_a(slot, ItemHelper.cloneStack(stack, Math.min(stack.field_77994_a, stackLimit)));
        return stackLimit >= stack.field_77994_a ? null : stack.func_77979_a(stack.field_77994_a - stackLimit);
    }

    private static ItemStack addToOccupiedInventorySlot(IInventory theInventory, int slot, ItemStack stack) {
        ItemStack stackInSlot = theInventory.func_70301_a(slot);
        int stackLimit = Math.min(theInventory.func_70297_j_(), stackInSlot.func_77976_d());
        if (stack.field_77994_a + stackInSlot.field_77994_a > stackLimit) {
            int stackDiff = stackLimit - stackInSlot.field_77994_a;
            stackInSlot.field_77994_a = stackLimit;
            stack.field_77994_a -= stackDiff;
            theInventory.func_70299_a(slot, stackInSlot);
            return stack;
        }
        stackInSlot.field_77994_a += Math.min(stack.field_77994_a, stackLimit);
        theInventory.func_70299_a(slot, stackInSlot);
        return stackLimit >= stack.field_77994_a ? null : stack.func_77979_a(stack.field_77994_a - stackLimit);
    }

    private static ItemStack simulateAddToEmptyInventorySlot(IInventory theInventory, int slot, ItemStack stack) {
        if (!theInventory.func_94041_b(slot, stack)) {
            return stack;
        }
        int stackLimit = theInventory.func_70297_j_();
        return stackLimit >= stack.field_77994_a ? null : stack.func_77979_a(stack.field_77994_a - stackLimit);
    }

    private static ItemStack simulateAddToOccupiedInventorySlot(IInventory theInventory, int slot, ItemStack stack) {
        ItemStack stackInSlot = theInventory.func_70301_a(slot);
        int stackLimit = Math.min(theInventory.func_70297_j_(), stackInSlot.func_77976_d());
        if (stack.field_77994_a + stackInSlot.field_77994_a > stackLimit) {
            stack.field_77994_a -= stackLimit - stackInSlot.field_77994_a;
            return stack;
        }
        return stackLimit >= stack.field_77994_a ? null : stack.func_77979_a(stack.field_77994_a - stackLimit);
    }
}

