/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.items;

import java.util.List;
import mariculture.core.helpers.FluidHelper;
import mariculture.core.items.ItemMariculture;
import mariculture.core.lib.Modules;
import mariculture.core.util.Fluids;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ItemBuckets
extends ItemMariculture {
    public ItemBuckets() {
        this.field_77777_bU = 1;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return new ItemStack(Items.field_151133_ar);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
        int amount = fluid == null ? 0 : fluid.amount;
        list.add(FluidHelper.getFluidName(fluid));
        FluidHelper.getFluidQty(list, fluid, -1);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        MovingObjectPosition movingobjectposition = this.func_77621_a(world, player, false);
        if (movingobjectposition == null) {
            return stack;
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int i = movingobjectposition.field_72311_b;
            int j = movingobjectposition.field_72312_c;
            int k = movingobjectposition.field_72309_d;
            if (!world.func_72962_a(player, i, j, k)) {
                return stack;
            }
            if (movingobjectposition.field_72310_e == 0) {
                --j;
            }
            if (movingobjectposition.field_72310_e == 1) {
                ++j;
            }
            if (movingobjectposition.field_72310_e == 2) {
                --k;
            }
            if (movingobjectposition.field_72310_e == 3) {
                ++k;
            }
            if (movingobjectposition.field_72310_e == 4) {
                --i;
            }
            if (movingobjectposition.field_72310_e == 5) {
                ++i;
            }
            if (!player.func_82247_a(i, j, k, movingobjectposition.field_72310_e, stack)) {
                return stack;
            }
            if (this.tryPlaceContainedLiquid(stack, world, i, j, k) && !player.field_71075_bZ.field_75098_d) {
                return new ItemStack(Items.field_151133_ar);
            }
        }
        return stack;
    }

    public boolean tryPlaceContainedLiquid(ItemStack stack, World world, int x, int y, int z) {
        boolean flag;
        Block block = this.getFluid(stack.func_77960_j());
        Material material = world.func_147439_a(x, y, z).func_149688_o();
        boolean bl = flag = !material.func_76220_a();
        if (!world.func_147437_c(x, y, z) && !flag) {
            return false;
        }
        if (!world.field_72995_K && flag && !material.func_76224_d()) {
            world.func_147480_a(x, y, z, true);
        }
        world.func_147465_d(x, y, z, block, 0, 3);
        return true;
    }

    public Block getFluid(int meta) {
        if (meta == 0) {
            return Fluids.getFluidBlock("hp_water");
        }
        if (meta == 3) {
            return Blocks.field_150346_d;
        }
        if (Modules.isActive(Modules.fishery)) {
            if (meta == 1) {
                return Fluids.getFluidBlock("fish_oil");
            }
            if (meta == 2) {
                return Fluids.getFluidBlock("custard");
            }
            if (meta == 8) {
                return Fluids.getFluidBlock("blood");
            }
            if (meta == 11) {
                return Fluids.getFluidBlock("chlorophyll");
            }
            if (meta == 6) {
                return Fluids.getFluidBlock("ender");
            }
            if (meta == 5) {
                return Fluids.getFluidBlock("flux");
            }
            if (meta == 4) {
                return Fluids.getFluidBlock("gunpowder");
            }
            if (meta == 7) {
                return Fluids.getFluidBlock("ice");
            }
            if (meta == 9) {
                return Fluids.getFluidBlock("mana");
            }
            if (meta == 10) {
                return Fluids.getFluidBlock("poison");
            }
        }
        return Blocks.field_150355_j;
    }

    public ItemStack getBucket(Block block) {
        if (block == Fluids.getFluidBlock("hp_water")) {
            return new ItemStack((Item)this, 1, 0);
        }
        if (Modules.isActive(Modules.fishery)) {
            if (block == Fluids.getFluidBlock("fish_oil")) {
                return new ItemStack((Item)this, 1, 1);
            }
            if (block == Fluids.getFluidBlock("custard")) {
                return new ItemStack((Item)this, 1, 2);
            }
            if (block == Fluids.getFluidBlock("blood")) {
                return new ItemStack((Item)this, 1, 8);
            }
            if (block == Fluids.getFluidBlock("chlorophyll")) {
                return new ItemStack((Item)this, 1, 11);
            }
            if (block == Fluids.getFluidBlock("ender")) {
                return new ItemStack((Item)this, 1, 6);
            }
            if (block == Fluids.getFluidBlock("flux")) {
                return new ItemStack((Item)this, 1, 5);
            }
            if (block == Fluids.getFluidBlock("gunpowder")) {
                return new ItemStack((Item)this, 1, 4);
            }
            if (block == Fluids.getFluidBlock("ice")) {
                return new ItemStack((Item)this, 1, 7);
            }
            if (block == Fluids.getFluidBlock("mana")) {
                return new ItemStack((Item)this, 1, 9);
            }
            if (block == Fluids.getFluidBlock("poison")) {
                return new ItemStack((Item)this, 1, 10);
            }
            return null;
        }
        return null;
    }

    @Override
    public int getMetaCount() {
        return 12;
    }

    @Override
    public String getName(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 2: {
                return "custardBucket";
            }
            case 3: {
                return "dirt";
            }
            case 1: {
                return "fishoil";
            }
            case 0: {
                return "hpwater";
            }
            case 8: {
                return "blood";
            }
            case 11: {
                return "chlorophyll";
            }
            case 6: {
                return "ender";
            }
            case 5: {
                return "flux";
            }
            case 4: {
                return "gunpowder";
            }
            case 7: {
                return "ice";
            }
            case 9: {
                return "mana";
            }
            case 10: {
                return "poison";
            }
        }
        return "container";
    }
}

