/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.lib;

import cofh.api.energy.IEnergyHandler;
import mariculture.factory.Factory;
import mariculture.factory.tile.TileCustom;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockWall;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PlansMeta {
    public static final int COUNT = 9;
    public static final int FLOOR = 0;
    public static final int BLOCK = 1;
    public static final int STAIRS = 2;
    public static final int SLABS = 3;
    public static final int FENCE = 4;
    public static final int GATE = 5;
    public static final int WALL = 6;
    public static final int LIGHT = 7;
    public static final int RF = 8;

    public static int getType(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.field_77990_d.func_74762_e("type");
        }
        return 0;
    }

    public static ItemStack setType(ItemStack stack, int type) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.field_77990_d.func_74768_a("type", type);
        return stack;
    }

    public static ItemStack getBlockStack(int type) {
        switch (type) {
            case 0: {
                return new ItemStack(Factory.customFlooring);
            }
            case 1: {
                return new ItemStack(Factory.customBlock);
            }
            case 2: {
                return new ItemStack(Factory.customStairs);
            }
            case 3: {
                return new ItemStack(Factory.customSlabs);
            }
            case 4: {
                return new ItemStack(Factory.customFence);
            }
            case 5: {
                return new ItemStack(Factory.customGate);
            }
            case 6: {
                return new ItemStack(Factory.customWall);
            }
            case 7: {
                return new ItemStack(Factory.customLight);
            }
            case 8: {
                return new ItemStack(Factory.customRFBlock);
            }
        }
        return null;
    }

    public static int getPlanType(Block block, World world, int x, int y, int z) {
        if (block instanceof BlockFence) {
            return 4;
        }
        if (block instanceof BlockFenceGate) {
            return 5;
        }
        if (block instanceof BlockSlab) {
            return 3;
        }
        if (block instanceof BlockStairs) {
            return 2;
        }
        if (block instanceof BlockWall) {
            return 6;
        }
        if (block instanceof BlockCarpet) {
            return 0;
        }
        if (world.func_147438_o(x, y, z) instanceof IEnergyHandler) {
            return 8;
        }
        if ((float)block.getLightValue((IBlockAccess)world, x, y, z) > 0.0f) {
            return 7;
        }
        if (world.func_147438_o(x, y, z) == null && !world.func_147437_c(x, y, z)) {
            return 1;
        }
        return -1;
    }

    public static boolean matches(NBTTagCompound nbt1, NBTTagCompound nbt2) {
        return PlansMeta.matches(nbt1, nbt2, true);
    }

    public static boolean matches(NBTTagCompound nbt1, NBTTagCompound nbt2, boolean checkHardness) {
        Block[] blocks1 = new Block[6];
        Block[] blocks2 = new Block[6];
        float resist1 = nbt1.func_74760_g("BlockResistance");
        float resist2 = nbt2.func_74760_g("BlockResistance");
        float hardness1 = nbt1.func_74760_g("BlockHardness");
        float hardness2 = nbt2.func_74760_g("BlockHardness");
        int[] theBlockMetas1 = nbt1.func_74759_k("BlockMetas");
        int[] theBlockMetas2 = nbt2.func_74759_k("BlockMetas");
        int[] theSides1 = nbt1.func_74759_k("BlockSides");
        int[] theSides2 = nbt2.func_74759_k("BlockSides");
        if (checkHardness && (resist1 != resist2 || hardness1 != hardness2)) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            blocks1[i] = (Block)Block.field_149771_c.func_82594_a(nbt1.func_74779_i("BlockIdentifier" + i));
            blocks2[i] = (Block)Block.field_149771_c.func_82594_a(nbt2.func_74779_i("BlockIdentifier" + i));
            if (blocks1[i] != blocks2[i]) {
                return false;
            }
            if (theBlockMetas1[i] == theBlockMetas2[i] && theSides1[i] == theSides2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isTheSame(World world, int x, int y, int z, ItemStack stack) {
        TileCustom tile = (TileCustom)world.func_147438_o(x, y, z);
        ItemStack block = new ItemStack(Factory.customSlabs);
        block.func_77982_d(new NBTTagCompound());
        if (tile == null) {
            return false;
        }
        tile.writeData(block.field_77990_d);
        return PlansMeta.matches(block.field_77990_d, stack.field_77990_d, false);
    }
}

