/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import mariculture.core.helpers.ClientHelper;
import mariculture.core.network.PacketCoords;
import mariculture.core.util.ITank;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;

public class PacketFluidSync
extends PacketCoords
implements IMessageHandler<PacketFluidSync, IMessage> {
    byte tank;
    FluidStack fluid;

    public PacketFluidSync() {
    }

    public PacketFluidSync(int x, int y, int z, FluidStack fluid, byte tank) {
        super(x, y, z);
        this.fluid = fluid;
        this.tank = tank;
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeByte((int)this.tank);
        if (this.fluid == null) {
            buffer.writeInt(0);
        } else {
            buffer.writeInt(this.fluid.fluidID);
            buffer.writeInt(this.fluid.amount);
        }
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.tank = buffer.readByte();
        int id = buffer.readInt();
        this.fluid = id == 0 ? null : new FluidStack(id, buffer.readInt());
    }

    public IMessage onMessage(PacketFluidSync message, MessageContext ctx) {
        TileEntity te = ClientHelper.getPlayer().field_70170_p.func_147438_o(message.x, message.y, message.z);
        if (te instanceof ITank) {
            ((ITank)te).setFluid(message.fluid, message.tank);
        }
        ClientHelper.updateRender(message.x, message.y, message.z);
        return null;
    }
}

