/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.network;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import mariculture.core.config.Machines;
import mariculture.core.network.PacketAirPump;
import mariculture.core.network.PacketClick;
import mariculture.core.network.PacketCompressor;
import mariculture.core.network.PacketCrack;
import mariculture.core.network.PacketDamageJewelry;
import mariculture.core.network.PacketEnchant;
import mariculture.core.network.PacketFLUDD;
import mariculture.core.network.PacketFluidSync;
import mariculture.core.network.PacketGUIUpdate;
import mariculture.core.network.PacketInventorySync;
import mariculture.core.network.PacketJewelrySwap;
import mariculture.core.network.PacketMultiInit;
import mariculture.core.network.PacketOrientationSync;
import mariculture.core.network.PacketParticle;
import mariculture.core.network.PacketRenderRefresh;
import mariculture.core.network.PacketRotorSpin;
import mariculture.core.network.PacketSponge;
import mariculture.core.network.PacketSyncFeeder;
import mariculture.core.network.PacketSyncMirror;
import mariculture.core.network.PacketTeleport;
import mariculture.core.util.IFaceable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class PacketHandler {
    private static int id;
    private static final SimpleNetworkWrapper INSTANCE;

    private static void registerPacket(Class clazz, Side side) {
        INSTANCE.registerMessage(clazz, clazz, id++, side);
    }

    public static void init() {
        PacketHandler.registerPacket(PacketAirPump.class, Side.CLIENT);
        PacketHandler.registerPacket(PacketCompressor.class, Side.CLIENT);
        PacketHandler.registerPacket(PacketFluidSync.class, Side.CLIENT);
        PacketHandler.registerPacket(PacketInventorySync.class, Side.CLIENT);
        PacketHandler.registerPacket(PacketMultiInit.class, Side.CLIENT);
        PacketHandler.registerPacket(PacketOrientationSync.class, Side.CLIENT);
        PacketHandler.registerPacket(PacketRenderRefresh.class, Side.CLIENT);
        PacketHandler.registerPacket(PacketSyncMirror.class, Side.CLIENT);
        PacketHandler.registerPacket(PacketClick.class, Side.SERVER);
        PacketHandler.registerPacket(PacketDamageJewelry.class, Side.SERVER);
        PacketHandler.registerPacket(PacketEnchant.class, Side.SERVER);
        PacketHandler.registerPacket(PacketJewelrySwap.class, Side.SERVER);
        PacketHandler.registerPacket(PacketTeleport.class, Side.SERVER);
        PacketHandler.registerPacket(PacketFLUDD.class, Side.CLIENT);
        PacketHandler.registerPacket(PacketFLUDD.class, Side.SERVER);
        PacketHandler.registerPacket(PacketSponge.class, Side.CLIENT);
        PacketHandler.registerPacket(PacketSponge.class, Side.SERVER);
        PacketHandler.registerPacket(PacketCrack.class, Side.CLIENT);
        PacketHandler.registerPacket(PacketParticle.class, Side.CLIENT);
        PacketHandler.registerPacket(PacketSyncFeeder.class, Side.CLIENT);
        PacketHandler.registerPacket(PacketRotorSpin.class, Side.CLIENT);
        PacketHandler.registerPacket(PacketGUIUpdate.class, Side.CLIENT);
    }

    public static void sendToClient(IMessage packet, EntityPlayerMP player) {
        INSTANCE.sendTo(packet, player);
    }

    public static void sendAround(IMessage packet, int dim, double x, double y, double z) {
        INSTANCE.sendToAllAround(packet, new NetworkRegistry.TargetPoint(dim, x, y, z, (double)Machines.MachineSettings.PACKET_DISTANCE));
    }

    public static void sendToServer(IMessage packet) {
        INSTANCE.sendToServer(packet);
    }

    public static void sendAround(IMessage packet, TileEntity tile) {
        PacketHandler.sendAround(packet, tile.func_145831_w().field_73011_w.field_76574_g, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
    }

    public static void syncInventory(TileEntity tile, ItemStack[] inventory) {
        PacketHandler.sendAround(new PacketInventorySync(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, inventory), tile);
    }

    public static void syncFluids(TileEntity tile, FluidStack fluid) {
        PacketHandler.syncFluidTank(tile, fluid, (byte)0);
    }

    public static void syncFluidTank(TileEntity tile, FluidStack fluid, byte tank) {
        PacketHandler.sendAround(new PacketFluidSync(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, fluid, tank), tile);
    }

    public static void syncMultiBlock(TileEntity master, TileEntity slave, ForgeDirection dir) {
        PacketHandler.sendAround(new PacketMultiInit(slave.field_145851_c, slave.field_145848_d, slave.field_145849_e, master.field_145851_c, master.field_145848_d, master.field_145849_e, dir), slave);
    }

    public static void breakMultiBlock(TileEntity slave) {
        PacketHandler.sendAround(new PacketMultiInit(slave.field_145851_c, slave.field_145848_d, slave.field_145849_e, 0, -1, 0, ForgeDirection.UNKNOWN), slave);
    }

    public static void updateOrientation(IFaceable faceable, int x, int y, int z, int dim) {
        INSTANCE.sendToAllAround((IMessage)new PacketOrientationSync(x, y, z, faceable.getFacing()), new NetworkRegistry.TargetPoint(dim, (double)x, (double)y, (double)z, (double)Machines.MachineSettings.PACKET_DISTANCE));
    }

    public static void updateOrientation(TileEntity tile) {
        IFaceable faceable = (IFaceable)tile;
        PacketHandler.sendAround(new PacketOrientationSync(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, faceable.getFacing()), tile);
    }

    public static void updateRender(TileEntity tile) {
        PacketHandler.sendAround(new PacketRenderRefresh(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e), tile);
    }

    public static void sendGUIUpdate(EntityPlayerMP player, int id, ArrayList<Integer> list) {
        INSTANCE.sendTo((IMessage)new PacketGUIUpdate(id, list), player);
    }

    static {
        INSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel("mariculture");
    }
}

