/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mariculture.api.util.CachedCoords;
import mariculture.core.helpers.ClientHelper;
import mariculture.fishery.tile.TileFeeder;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketSyncFeeder
implements IMessage,
IMessageHandler<PacketSyncFeeder, IMessage> {
    public NBTTagCompound nbt;

    public PacketSyncFeeder() {
    }

    public PacketSyncFeeder(int x, int y, int z, ArrayList<CachedCoords> coord) {
        this.nbt = new NBTTagCompound();
        this.nbt.func_74768_a("x", x);
        this.nbt.func_74768_a("y", y);
        this.nbt.func_74768_a("z", z);
        NBTTagList list = new NBTTagList();
        for (CachedCoords c : coord) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("x", c.x);
            tag.func_74768_a("y", c.y);
            tag.func_74768_a("z", c.z);
            list.func_74742_a((NBTBase)tag);
        }
        this.nbt.func_74782_a("Coordinates", (NBTBase)list);
    }

    public void toBytes(ByteBuf buffer) {
        try {
            new PacketBuffer(buffer).func_150786_a(this.nbt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fromBytes(ByteBuf buffer) {
        try {
            this.nbt = new PacketBuffer(buffer).func_150793_b();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IMessage onMessage(PacketSyncFeeder message, MessageContext ctx) {
        World world = ClientHelper.getPlayer().field_70170_p;
        int x = message.nbt.func_74762_e("x");
        int y = message.nbt.func_74762_e("y");
        int z = message.nbt.func_74762_e("z");
        ArrayList<CachedCoords> coords = new ArrayList<CachedCoords>();
        NBTTagList tagList = message.nbt.func_150295_c("Coordinates", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            coords.add(new CachedCoords(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z")));
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileFeeder) {
            ((TileFeeder)tile).coords = coords;
        }
        return null;
    }
}

