/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.tile;

import mariculture.core.config.Machines;
import mariculture.core.helpers.PlayerHelper;
import mariculture.core.helpers.cofh.BlockHelper;
import mariculture.core.network.PacketHandler;
import mariculture.core.network.PacketParticle;
import mariculture.core.tile.TileAnvil;
import mariculture.core.tile.base.TileStorage;
import mariculture.core.util.XPRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class TileAutohammer
extends TileStorage {
    private int offset = -1;
    public boolean[] up;
    public float[] angle;

    public TileAutohammer() {
        this.inventory = new ItemStack[4];
        this.up = new boolean[4];
        this.angle = new float[4];
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public boolean onTick(int i) {
        return (this.field_145850_b.func_72820_D() + (long)this.offset) % (long)i == 0L;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        if (this.field_145850_b.field_72995_K && this.inventory[slot] == null) {
            this.angle[slot] = 0.0f;
            this.up[slot] = false;
        }
        super.func_70299_a(slot, stack);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            int i;
            if (Machines.Client.HAMMER_ANIM && this.field_145850_b.field_72995_K && this.canConsume()) {
                if (this.offset < 0) {
                    for (i = 0; i < this.angle.length; ++i) {
                        this.angle[i] = 5.0f + (float)this.field_145850_b.field_73012_v.nextInt(4);
                    }
                    this.offset = 1;
                }
                for (i = 0; i < this.angle.length; ++i) {
                    if (this.up[i]) {
                        if (this.angle[i] <= 5.0f) {
                            this.up[i] = false;
                            continue;
                        }
                        int n = i;
                        this.angle[n] = this.angle[n] - 2.0f;
                        continue;
                    }
                    if (this.angle[i] >= 56.0f) {
                        this.up[i] = true;
                        continue;
                    }
                    int n = i;
                    this.angle[n] = this.angle[n] + 5.0f;
                }
            }
            if (!this.field_145850_b.field_72995_K) {
                if (this.offset < 0) {
                    this.offset = this.field_145850_b.field_73012_v.nextInt(80);
                }
                if (this.onTick(50) && this.canConsume()) {
                    for (i = 0; i < this.inventory.length; ++i) {
                        if (this.inventory[i] == null) continue;
                        ForgeDirection dir = ForgeDirection.values()[i + 2];
                        TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d - 1, this.field_145849_e + dir.offsetZ);
                        if (!(tile instanceof TileAnvil)) continue;
                        TileAnvil anvil = (TileAnvil)tile;
                        FakePlayer player = PlayerHelper.getFakePlayer(this.field_145850_b);
                        player.func_71023_q(this.getExperience());
                        int ret = ((TileAnvil)tile).workItem((EntityPlayer)player, this.inventory[i]);
                        if (ret >= 5000) {
                            this.drainExperience(ret - 5000);
                            this.field_145850_b.func_72908_a((double)anvil.field_145851_c, (double)anvil.field_145848_d, (double)anvil.field_145849_e, "mariculture:bang", 1.0f, 1.0f);
                            PacketHandler.sendAround(new PacketParticle(PacketParticle.Particle.EXPLODE_LRG, 1, anvil.field_145851_c, (double)anvil.field_145848_d + 0.5, anvil.field_145849_e), this.field_145850_b.field_73011_w.field_76574_g, anvil.field_145851_c, tile.field_145848_d + 1, anvil.field_145849_e);
                        } else if (ret < 0) {
                            this.drainExperience(1);
                            this.field_145850_b.func_72908_a((double)anvil.field_145851_c, (double)anvil.field_145848_d, (double)anvil.field_145849_e, "mariculture:hammer", 1.0f, 1.0f);
                            PacketHandler.sendAround(new PacketParticle(PacketParticle.Particle.EXPLODE_SML, 1, anvil.field_145851_c, (double)anvil.field_145848_d + 0.5, anvil.field_145849_e), this.field_145850_b.field_73011_w.field_76574_g, anvil.field_145851_c, tile.field_145848_d + 1, anvil.field_145849_e);
                        } else if (ret != 0) {
                            this.drainExperience(ret);
                            this.field_145850_b.func_72908_a((double)anvil.field_145851_c, (double)anvil.field_145848_d, (double)anvil.field_145849_e, "mariculture:hammer", 1.0f, 1.0f);
                            PacketHandler.sendAround(new PacketParticle(PacketParticle.Particle.EXPLODE_SML, 21, anvil.field_145851_c, anvil.field_145848_d, anvil.field_145849_e), this.field_145850_b.field_73011_w.field_76574_g, anvil.field_145851_c, tile.field_145848_d + 1, anvil.field_145849_e);
                        }
                        if (ret == 0) continue;
                        if (this.inventory[i].func_96631_a(1, this.field_145850_b.field_73012_v)) {
                            this.inventory[i] = null;
                        }
                        this.func_70296_d();
                    }
                }
            }
        }
    }

    private void drainExperience(int xp) {
        TileEntity tile = BlockHelper.getAdjacentTileEntity(this, ForgeDirection.DOWN);
        if (tile instanceof IFluidHandler) {
            ((IFluidHandler)tile).drain(ForgeDirection.UP, XPRegistry.getFluidValueOfXP(((IFluidHandler)tile).drain(ForgeDirection.UP, Integer.MAX_VALUE, false), xp), true);
        }
    }

    private int getExperience() {
        FluidStack fluid;
        TileEntity tile = BlockHelper.getAdjacentTileEntity(this, ForgeDirection.DOWN);
        if (tile instanceof IFluidHandler && XPRegistry.isXP(fluid = ((IFluidHandler)tile).drain(ForgeDirection.UP, Integer.MAX_VALUE, false))) {
            return XPRegistry.getXPValueOfFluid(fluid);
        }
        return 0;
    }

    private boolean canConsume() {
        return this.getExperience() > 0;
    }

    public ItemStack[] getInventory() {
        return this.inventory;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (!this.field_145850_b.field_72995_K) {
            PacketHandler.syncInventory(this, this.inventory);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }
}

