/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.tile;

import mariculture.api.core.Environment;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.core.RecipeCasting;
import mariculture.core.network.PacketHandler;
import mariculture.core.tile.base.TileStorageTank;
import mariculture.core.util.Tank;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public abstract class TileCooling
extends TileStorageTank
implements ISidedInventory {
    public boolean canWork;
    public int freezeTick;
    private int cooling;

    public TileCooling() {
        this.inventory = new ItemStack[this.getInventorySize()];
        this.tank = new Tank(this.getTankSize());
    }

    public abstract int getInventorySize();

    public abstract int getTankSize();

    public abstract int getTime();

    public abstract RecipeCasting getResult();

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.cooling <= 0) {
                this.cooling = Math.max(1, Environment.Temperature.getCoolingSpeed(MaricultureHandlers.environment.getBiomeTemperature(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)));
            }
            if (this.canWork) {
                this.freezeTick += this.cooling;
                if (this.freezeTick >= this.getTime()) {
                    RecipeCasting result = this.getResult();
                    if (result != null) {
                        for (int i = 0; i < this.inventory.length; ++i) {
                            if (this.inventory[i] != null || this.tank.getFluidAmount() < result.fluid.amount) continue;
                            this.drain(ForgeDirection.UP, result.fluid.amount, true);
                            this.func_70299_a(i, result.output.func_77946_l());
                            if (!this.canWork) break;
                        }
                    }
                    this.freezeTick = 0;
                }
            }
        }
    }

    public boolean canWork() {
        return !this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) && this.hasRoom() && this.canFreeze();
    }

    public boolean canFreeze() {
        return this.getResult() != null;
    }

    public boolean hasRoom() {
        for (ItemStack element : this.inventory) {
            if (element != null) continue;
            return true;
        }
        return false;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (!this.field_145850_b.field_72995_K) {
            this.canWork = this.canWork();
            PacketHandler.syncInventory(this, this.inventory);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int amount = this.tank.fill(resource, doFill);
        if (doFill) {
            if (amount > 0) {
                PacketHandler.syncFluids(this, this.getFluid());
                this.freezeTick = 0;
            }
            this.canWork = this.canWork();
        }
        return amount;
    }

    @Override
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack amount = this.tank.drain(maxDrain, doDrain);
        if (doDrain) {
            if (amount != null) {
                PacketHandler.syncFluids(this, this.getFluid());
            }
            this.canWork = this.canWork();
        }
        return amount;
    }

    public abstract int[] func_94128_d(int var1);

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.freezeTick = nbt.func_74762_e("FreezeTick");
        this.cooling = nbt.func_74762_e("CoolingSpeed");
        this.canWork = nbt.func_74767_n("CanWork");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("FreezeTick", this.freezeTick);
        nbt.func_74768_a("CoolingSpeed", this.cooling);
        nbt.func_74757_a("CanWork", this.canWork);
    }
}

