/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.tile;

import java.util.ArrayList;
import mariculture.api.core.Environment;
import mariculture.api.core.FuelInfo;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.core.RecipeSmelter;
import mariculture.core.config.Machines;
import mariculture.core.gui.feature.FeatureEject;
import mariculture.core.gui.feature.FeatureNotifications;
import mariculture.core.gui.feature.FeatureRedstone;
import mariculture.core.helpers.FluidHelper;
import mariculture.core.helpers.cofh.BlockHelper;
import mariculture.core.lib.MachineSpeeds;
import mariculture.core.lib.MetalRates;
import mariculture.core.network.PacketHandler;
import mariculture.core.tile.base.TileMultiBlock;
import mariculture.core.tile.base.TileMultiMachineTank;
import mariculture.core.util.IHasNotification;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class TileCrucible
extends TileMultiMachineTank
implements IHasNotification {
    private static final int MAX_TEMP = 25000;
    private int temp;
    private boolean canFuel;
    private int cooling;
    private double melting_modifier = 1.0;
    private static final int liquid_in = 3;
    private static final int liquid_out = 4;
    private static final int[] in = new int[]{5, 6};
    private static final int fuel = 7;
    private static final int out = 8;
    private FuelHandler fuelHandler;
    private int burnHeight = 0;

    public TileCrucible() {
        this.max = MachineSpeeds.getCrucibleSpeed();
        this.inventory = new ItemStack[9];
        this.needsInit = true;
    }

    @Override
    public int[] getInputSlots() {
        return in;
    }

    public int[] func_94128_d(int side) {
        return new int[]{3, 4, 5, 6, 7, 8};
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70299_a(slot, stack);
        this.canWork = this.canWork();
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (FluidHelper.isFluidOrEmpty(stack)) {
            return slot == 3;
        }
        if (MaricultureHandlers.crucible.getFuelInfo(stack) != null) {
            return slot == 7;
        }
        return slot == 5 || slot == 6;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 8 || slot == 4;
    }

    @Override
    public FeatureEject.EjectSetting getEjectType() {
        return FeatureEject.EjectSetting.ITEMNFLUID;
    }

    @Override
    public boolean isNotificationVisible(FeatureNotifications.NotificationType type) {
        return false;
    }

    @Override
    public boolean canWork() {
        return this.hasTemperature() && this.hasItem() && this.rsAllowsWork() && this.hasRoom();
    }

    private boolean hasTemperature() {
        return this.temp > 0;
    }

    private boolean hasItem() {
        return this.inventory[in[0]] != null || this.inventory[in[1]] != null;
    }

    private boolean hasRoom() {
        return this.canMelt(0) || this.canMelt(1);
    }

    private boolean areStacksEqual(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77960_j() == stack2.func_77960_j();
    }

    @Override
    public void updateMasterMachine() {
        if (!this.field_145850_b.field_72995_K) {
            this.heatUp();
            this.coolDown();
            if (this.canWork) {
                this.processed = (int)((double)this.processed + (double)(this.speed * 50) * this.melting_modifier);
                if (this.processed >= this.max) {
                    this.processed = 0;
                    if (this.canWork()) {
                        if (this.canMelt(0)) {
                            this.melt(0);
                        }
                        if (this.canMelt(1)) {
                            this.melt(1);
                        }
                    }
                    this.canWork = this.canWork();
                }
            } else {
                this.processed = 0;
            }
            if (this.processed <= 0) {
                this.processed = 0;
            }
            if (this.onTick(100) && this.tank.getFluidAmount() > 0 && FeatureRedstone.RedstoneMode.canWork(this, this.mode) && FeatureEject.EjectSetting.canEject(this.setting, FeatureEject.EjectSetting.FLUID)) {
                this.helper.ejectFluid(new int[]{5000, MetalRates.BLOCK, 1000, MetalRates.ORE, MetalRates.INGOT, MetalRates.NUGGET, 1});
            }
        }
    }

    @Override
    public void updateSlaveMachine() {
        TileCrucible mstr;
        if (this.onTick(100) && (mstr = (TileCrucible)this.getMaster()) != null && mstr.tank.getFluidAmount() > 0 && FeatureRedstone.RedstoneMode.canWork(this, mstr.mode) && FeatureEject.EjectSetting.canEject(mstr.setting, FeatureEject.EjectSetting.FLUID)) {
            this.helper.ejectFluid(new int[]{5000, MetalRates.BLOCK, 1000, MetalRates.ORE, MetalRates.INGOT, MetalRates.NUGGET, 1});
        }
    }

    private boolean canFuel() {
        FluidStack fluid;
        if (this.fuelHandler.info != null) {
            return false;
        }
        if (!this.rsAllowsWork()) {
            return false;
        }
        if (MaricultureHandlers.crucible.getFuelInfo(this.inventory[7]) != null) {
            return true;
        }
        TileEntity tile = BlockHelper.getAdjacentTileEntity(this, ForgeDirection.DOWN);
        if (tile instanceof IFluidHandler && (fluid = ((IFluidHandler)tile).drain(ForgeDirection.UP, 10, false)) != null && fluid.getFluid() != null) {
            return MaricultureHandlers.crucible.getFuelInfo(fluid) != null;
        }
        return false;
    }

    private void heatUp() {
        if (this.fuelHandler == null) {
            this.fuelHandler = new FuelHandler();
        }
        if (this.onTick(20)) {
            this.canFuel = this.canFuel();
        }
        if (this.canFuel) {
            this.fuelHandler.set(this.getInfo());
            this.canFuel = false;
        }
        if (this.fuelHandler.info != null) {
            this.temp = Math.min(25000, this.fuelHandler.tick(this.temp, this.purity));
            if (this.temp >= 25000) {
                this.temp = 25000;
            }
        }
    }

    private void coolDown() {
        if (this.cooling <= 0) {
            this.cooling = Math.max(1, Environment.Temperature.getCoolingSpeed(MaricultureHandlers.environment.getBiomeTemperature(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)));
        }
        if (this.onTick(20)) {
            this.temp -= this.cooling;
            if (this.temp <= 0) {
                this.temp = 0;
            }
        }
    }

    public FuelInfo getInfo() {
        FuelInfo info = MaricultureHandlers.crucible.getFuelInfo(this.inventory[7]);
        if (info == null) {
            FluidStack fluid;
            TileEntity tile = BlockHelper.getAdjacentTileEntity(this, ForgeDirection.DOWN);
            if (tile instanceof IFluidHandler && (fluid = ((IFluidHandler)tile).drain(ForgeDirection.UP, 10, true)) != null) {
                return MaricultureHandlers.crucible.getFuelInfo(fluid);
            }
        } else {
            this.func_70298_a(7, 1);
        }
        return info;
    }

    private boolean canMelt(int slot) {
        boolean ret;
        int other = slot == 0 ? 1 : 0;
        RecipeSmelter recipe = MaricultureHandlers.crucible.getResult(this.inventory[in[slot]], this.inventory[in[other]], this.getTemperatureScaled(2000), MaricultureHandlers.upgrades.hasUpgrade("ethereal", this));
        if (recipe == null) {
            return false;
        }
        int fluidAmount = recipe.fluid.amount;
        FluidStack fluid = recipe.fluid.copy();
        fluid.amount = fluidAmount;
        if (this.tank.fill(fluid, false) < fluid.amount) {
            return false;
        }
        boolean bl = ret = recipe.output == null || this.setting.canEject(FeatureEject.EjectSetting.ITEM);
        if (!ret) {
            boolean bl2 = ret = this.inventory[8] == null || this.areStacksEqual(this.inventory[8], recipe.output) && this.inventory[8].field_77994_a + recipe.output.field_77994_a <= this.inventory[8].func_77976_d();
        }
        if (ret) {
            int realTemp = this.temp * 2000 / 25000;
            int max_temp = 2000 - recipe.temp;
            this.melting_modifier = 1.0 + (double)Math.min(realTemp, max_temp) * 3.333333 / 2000.0;
            return true;
        }
        return false;
    }

    private void melt(int slot) {
        int other = slot == 0 ? 1 : 0;
        RecipeSmelter recipe = MaricultureHandlers.crucible.getResult(this.inventory[in[slot]], this.inventory[in[other]], this.getTemperatureScaled(2000), MaricultureHandlers.upgrades.hasUpgrade("ethereal", this));
        if (recipe == null) {
            return;
        }
        this.func_70298_a(in[slot], recipe.input.field_77994_a);
        int fluidAmount = recipe.fluid.amount;
        FluidStack fluid = recipe.fluid.copy();
        fluid.amount = fluidAmount;
        this.tank.fill(fluid, true);
        if (recipe.output != null && recipe.chance > 0 && this.field_145850_b.field_73012_v.nextInt(recipe.chance) == 0) {
            this.helper.insertStack(recipe.output.func_77946_l(), new int[]{8});
        }
    }

    @Override
    public void setGUIData(int id, int value) {
        super.setGUIData(id, value);
        int realID = id - this.offset;
        switch (realID) {
            case 0: {
                this.temp = value;
            }
            case 1: {
                this.burnHeight = value;
            }
        }
    }

    public int getBurnTimeRemainingScaled() {
        return this.burnHeight;
    }

    @Override
    public ArrayList<Integer> getGUIData() {
        ArrayList<Integer> list = super.getGUIData();
        list.add(this.temp);
        if (this.fuelHandler.info != null) {
            this.burnHeight = 11 - this.fuelHandler.tick * 12 / ((FuelHandler)this.fuelHandler).info.ticksPer;
            list.add(this.burnHeight);
        } else {
            list.add(0);
        }
        return list;
    }

    public int getTemperatureScaled(int i) {
        return this.temp * i / 25000;
    }

    public String getRealTemperature() {
        return "" + this.temp * 2000 / 25000;
    }

    public int getFluidAmount(String name, int amount) {
        if (name.startsWith("ore")) {
            amount += this.purity * Machines.MachineSettings.PURITY;
        }
        return amount;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.temp = nbt.func_74762_e("Temperature");
        this.canFuel = nbt.func_74767_n("CanFuel");
        this.fuelHandler = new FuelHandler();
        this.fuelHandler.read(nbt);
        this.cooling = nbt.func_74762_e("CoolingSpeed");
        this.melting_modifier = nbt.func_74769_h("MeltingModifier");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("CoolingSpeed", this.cooling);
        nbt.func_74768_a("Temperature", this.temp);
        nbt.func_74780_a("MeltingModifier", this.melting_modifier);
        nbt.func_74757_a("CanFuel", this.canFuel);
        if (this.fuelHandler != null) {
            this.fuelHandler.write(nbt);
        }
    }

    @Override
    public void onBlockPlaced() {
        this.onBlockPlaced(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        PacketHandler.updateRender(this);
    }

    private void onBlockPlaced(int x, int y, int z) {
        ArrayList<TileMultiBlock.MultiPart> parts;
        TileMultiBlock.MultiPart mstr;
        if (this.isPart(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) && !this.isPart(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) && !this.isPart(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e)) {
            mstr = new TileMultiBlock.MultiPart(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            parts = new ArrayList<TileMultiBlock.MultiPart>();
            parts.add(this.setAsSlave(mstr, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e));
            this.setAsMaster(mstr, parts);
        }
        if (this.isPart(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) && !this.isPart(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) && !this.isPart(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e)) {
            mstr = new TileMultiBlock.MultiPart(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
            parts = new ArrayList();
            parts.add(this.setAsSlave(mstr, this.field_145851_c, this.field_145848_d, this.field_145849_e));
            this.setAsMaster(mstr, parts);
        }
    }

    @Override
    public boolean isPart(int x, int y, int z) {
        return this.field_145850_b.func_147439_a(x, y, z) == this.func_145838_q() && this.field_145850_b.func_72805_g(x, y, z) == 0 & !this.isPartnered(x, y, z);
    }

    private class FuelHandler {
        private int usedHeat;
        private int tick;
        private FuelInfo info;

        private FuelHandler() {
        }

        private void read(NBTTagCompound nbt) {
            if (nbt.func_74767_n("HasHandler")) {
                this.info = new FuelInfo();
                this.info.read(nbt);
            }
        }

        private void write(NBTTagCompound nbt) {
            if (this.info != null) {
                nbt.func_74757_a("HasHandler", true);
                this.info.write(nbt);
            }
        }

        private void set(FuelInfo info) {
            this.info = info;
            this.tick = 0;
            this.usedHeat = 0;
        }

        private int getMaxTempPer(int purity) {
            return this.info.maxTempPer * (purity + 1);
        }

        private int tick(int temp, int purity) {
            int realUsed = this.usedHeat * 2000 / 25000;
            int realTemp = temp * 2000 / 25000;
            ++this.tick;
            if (realUsed < this.getMaxTempPer(purity) && realTemp < this.info.maxTemp) {
                temp += TileCrucible.this.heat / 3 + 1;
                this.usedHeat += TileCrucible.this.heat / 3 + 1;
            }
            if (realUsed >= this.getMaxTempPer(purity) || this.tick >= this.info.ticksPer) {
                this.info = null;
                if (TileCrucible.this.canFuel()) {
                    TileCrucible.this.fuelHandler.set(TileCrucible.this.getInfo());
                } else {
                    TileCrucible.this.fuelHandler.set(null);
                }
            }
            return temp;
        }
    }
}

