/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.tile;

import java.util.List;
import mariculture.core.helpers.FluidHelper;
import mariculture.core.network.PacketHandler;
import mariculture.core.util.ITank;
import mariculture.core.util.Tank;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileTankBlock
extends TileEntity
implements IFluidHandler,
ITank {
    private int difference = 0;
    public Tank tank = new Tank(16000);

    public float getFluidAmountScaled() {
        return (float)this.tank.getFluid().amount / ((float)this.tank.getCapacity() * 1.01f);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean canUpdate() {
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int amount = this.tank.fill(resource, doFill);
        this.difference += amount;
        if (amount > 0 && doFill && this.difference >= 144) {
            this.difference = 0;
            PacketHandler.syncFluids(this, this.getFluid());
        }
        return amount;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack amount = this.tank.drain(maxDrain, doDrain);
        if (amount != null && doDrain) {
            PacketHandler.syncFluids(this, this.getFluid());
        }
        return amount;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drain(ForgeDirection.UNKNOWN, resource.amount, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public FluidStack getFluid(int transfer) {
        if (this.tank.getFluid() == null) {
            return null;
        }
        if (this.tank.getFluidAmount() - transfer < 0) {
            return null;
        }
        return new FluidStack(this.tank.getFluidID(), transfer);
    }

    @Override
    public String getFluidName() {
        return FluidHelper.getFluidName(this.tank.getFluid());
    }

    @Override
    public List getFluidQty(List tooltip) {
        return FluidHelper.getFluidQty(tooltip, this.tank.getFluid(), this.tank.getCapacity());
    }

    @Override
    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    @Override
    public int getTankScaled(int i) {
        int qty = this.tank.getFluidAmount();
        int max = this.tank.getCapacity();
        return max != 0 ? qty * i / max : 0;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.tank.readFromNBT(tagCompound);
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.tank.writeToNBT(tagCompound);
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    @Override
    public FluidStack getFluid(byte tank) {
        return this.getFluid();
    }

    @Override
    public void setFluid(FluidStack fluid, byte tank) {
        this.setFluid(fluid);
    }

    public double getCapacity() {
        return this.tank.getCapacity();
    }
}

