/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.tile;

import java.util.ArrayList;
import java.util.List;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.core.RecipeVat;
import mariculture.core.helpers.cofh.ItemHelper;
import mariculture.core.network.PacketHandler;
import mariculture.core.tile.base.TileMultiBlock;
import mariculture.core.tile.base.TileMultiStorage;
import mariculture.core.util.ITank;
import mariculture.core.util.Tank;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileVat
extends TileMultiStorage
implements ISidedInventory,
IFluidHandler,
ITank {
    public static int max_lrg = 30000;
    public static int max_sml = 6000;
    public Tank tank = new Tank(max_sml);
    public Tank tank2 = new Tank(max_sml);
    public Tank tank3 = new Tank(max_sml);
    public int timeNeeded;
    public int timeRemaining;
    public boolean canWork;
    private int machineTick;

    public TileVat() {
        this.inventory = new ItemStack[2];
        this.needsInit = true;
    }

    public boolean onTick(int i) {
        return this.machineTick % i == 0;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.master == null) {
            this.updateSingle();
        }
    }

    @Override
    public void updateMaster() {
        if (this.tank.getCapacity() != max_lrg) {
            this.tank.setCapacity(max_lrg);
        }
        if (this.tank2.getCapacity() != max_lrg) {
            this.tank2.setCapacity(max_lrg);
        }
        if (this.tank3.getCapacity() != max_lrg) {
            this.tank3.setCapacity(max_lrg);
        }
        ++this.machineTick;
        if (!this.isInit() && !this.field_145850_b.field_72995_K) {
            PacketHandler.syncMultiBlock(this.getMaster(), this, this.facing);
            for (TileMultiBlock.MultiPart slave : this.slaves) {
                TileEntity te = this.field_145850_b.func_147438_o(slave.xCoord, slave.yCoord, slave.zCoord);
                if (te == null || !(te instanceof TileVat)) continue;
                PacketHandler.syncMultiBlock(this.getMaster(), te, ((TileMultiBlock)te).facing);
            }
            this.setInit(true);
        }
        if (!this.field_145850_b.field_72995_K && this.canWork && this.onTick(20)) {
            ++this.timeRemaining;
        }
        if (this.field_145850_b.field_72995_K && this.canWork) {
            this.field_145850_b.func_72869_a("smoke", (double)this.field_145851_c + 0.5 + (double)this.field_145850_b.field_73012_v.nextFloat() - (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f), (double)this.field_145848_d + 0.8 + (double)this.field_145850_b.field_73012_v.nextFloat() - (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f), (double)this.field_145849_e + 0.5 + (double)this.field_145850_b.field_73012_v.nextFloat() - (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f), 0.0, 0.0, 0.0);
        }
        this.updateAll();
    }

    public void updateSingle() {
        ++this.machineTick;
        if (!this.field_145850_b.field_72995_K && this.canWork && this.onTick(30)) {
            ++this.timeRemaining;
        }
        this.updateAll();
        if (this.field_145850_b.field_72995_K && this.canWork) {
            this.field_145850_b.func_72869_a("smoke", (double)this.field_145851_c + 0.5 + (double)this.field_145850_b.field_73012_v.nextFloat() - (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f), (double)this.field_145848_d + 0.8 + (double)this.field_145850_b.field_73012_v.nextFloat() - (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f), (double)this.field_145849_e + 0.5 + (double)this.field_145850_b.field_73012_v.nextFloat() - (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f), 0.0, 0.0, 0.0);
        }
    }

    public void updateAll() {
        if (this.onTick(20)) {
            this.canWork = this.canWork();
        }
        if (this.canWork && !this.field_145850_b.field_72995_K) {
            if (this.timeNeeded == 0) {
                RecipeVat recipe = (RecipeVat)this.getResult()[0];
                if (recipe != null) {
                    this.timeNeeded = recipe.processTime;
                }
                this.timeRemaining = 0;
            }
            if (this.timeRemaining >= this.timeNeeded) {
                Object[] result = this.getResult();
                RecipeVat recipe = (RecipeVat)result[0];
                byte tankNum = (Byte)result[1];
                if (recipe != null) {
                    this.createResult(recipe, tankNum);
                }
                this.timeRemaining = 0;
                this.timeNeeded = 0;
                this.canWork = this.canWork();
            }
        }
    }

    private FluidStack drain(byte id, FluidStack input, FluidStack output, boolean doDrain) {
        int drain = input.copy().amount;
        if (input.isFluidEqual(output)) {
            drain -= output.amount;
            output = null;
        }
        if (doDrain) {
            if (id == 1) {
                this.tank.drain(drain, true);
            } else {
                this.tank2.drain(drain, true);
            }
        }
        return output;
    }

    private void createResult(RecipeVat recipe, byte tankNum) {
        FluidStack outputFluid = null;
        if (recipe.outputFluid != null) {
            outputFluid = recipe.outputFluid.copy();
        }
        if (tankNum == 1) {
            if (recipe.inputFluid1 != null) {
                outputFluid = this.drain((byte)1, recipe.inputFluid1, outputFluid, true);
            }
            if (recipe.inputFluid2 != null) {
                outputFluid = this.drain((byte)2, recipe.inputFluid2, outputFluid, true);
            }
        } else {
            if (recipe.inputFluid1 != null) {
                outputFluid = this.drain((byte)2, recipe.inputFluid1, outputFluid, true);
            }
            if (recipe.inputFluid2 != null) {
                outputFluid = this.drain((byte)1, recipe.inputFluid2, outputFluid, true);
            }
        }
        if (recipe.inputItem != null) {
            this.func_70298_a(0, recipe.inputItem instanceof ItemStack ? ((ItemStack)recipe.inputItem).field_77994_a : 1);
        }
        if (outputFluid != null && outputFluid.amount > 0) {
            this.tank3.fill(recipe.outputFluid.copy(), true);
        }
        if (recipe.outputItem != null) {
            ItemStack output = recipe.outputItem.func_77946_l();
            if (this.inventory[1] != null) {
                output.field_77994_a += this.inventory[1].field_77994_a;
            }
            this.func_70299_a(1, output);
        }
        PacketHandler.syncFluidTank(this, this.getFluid((byte)1), (byte)1);
        PacketHandler.syncFluidTank(this, this.getFluid((byte)2), (byte)2);
        PacketHandler.syncFluidTank(this, this.getFluid((byte)3), (byte)3);
    }

    public boolean canWork() {
        if (this.tank.getFluidAmount() <= 0 && this.tank2.getFluidAmount() <= 0) {
            return false;
        }
        RecipeVat res = (RecipeVat)this.getResult()[0];
        return res != null;
    }

    public Object[] getResult() {
        byte tankNum = 1;
        RecipeVat result = MaricultureHandlers.vat.getResult(this.tank.getFluid(), this.tank2.getFluid(), this.inventory[0]);
        RecipeVat recipeVat = result = result == null || !this.hasRoom(result.outputItem, result.outputFluid) ? null : result;
        if (result == null) {
            tankNum = 2;
            result = MaricultureHandlers.vat.getResult(this.tank2.getFluid(), this.tank.getFluid(), this.inventory[0]);
            result = result == null || !this.hasRoom(result.outputItem, result.outputFluid) ? null : result;
        }
        return new Object[]{result, tankNum};
    }

    private boolean hasRoom(ItemStack stack, FluidStack newFluid) {
        if (this.tank3.getFluid() != null && newFluid != null && (newFluid.fluidID != this.tank3.getFluidID() || newFluid.amount + this.tank3.getFluidAmount() > this.tank3.getCapacity())) {
            return false;
        }
        return stack == null || this.inventory[1] == null || ItemHelper.areItemStackEqualNoNull(stack, this.inventory[1]) && this.inventory[1].field_77994_a + stack.field_77994_a <= this.inventory[1].func_77976_d();
    }

    @Override
    public Class getTEClass() {
        return this.getClass();
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return slot == 0;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        if (slot == 0) {
            return side != ForgeDirection.DOWN.ordinal();
        }
        return true;
    }

    @Override
    public ItemStack func_70301_a(int slot) {
        TileVat vat;
        TileVat tileVat = vat = this.master != null ? (TileVat)this.field_145850_b.func_147438_o(this.master.xCoord, this.master.yCoord, this.master.zCoord) : this;
        if (vat == null) {
            return null;
        }
        return vat.inventory[slot];
    }

    @Override
    public ItemStack func_70304_b(int slot) {
        TileVat vat;
        TileVat tileVat = vat = this.master != null ? (TileVat)this.field_145850_b.func_147438_o(this.master.xCoord, this.master.yCoord, this.master.zCoord) : this;
        if (vat == null) {
            return null;
        }
        if (vat.inventory[slot] != null) {
            ItemStack stack = vat.inventory[slot];
            vat.inventory[slot] = null;
            return stack;
        }
        return null;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        TileVat vat;
        TileVat tileVat = vat = this.master != null ? (TileVat)this.field_145850_b.func_147438_o(this.master.xCoord, this.master.yCoord, this.master.zCoord) : this;
        if (vat == null) {
            return;
        }
        vat.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > vat.func_70297_j_()) {
            stack.field_77994_a = vat.func_70297_j_();
        }
        vat.func_70296_d();
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        TileVat vat;
        TileVat tileVat = vat = this.master != null ? (TileVat)this.field_145850_b.func_147438_o(this.master.xCoord, this.master.yCoord, this.master.zCoord) : this;
        if (vat == null) {
            return null;
        }
        if (vat.inventory[slot] != null) {
            if (vat.inventory[slot].field_77994_a <= amount) {
                ItemStack stack = vat.inventory[slot];
                vat.inventory[slot] = null;
                vat.func_70296_d();
                return stack;
            }
            ItemStack stack = vat.inventory[slot].func_77979_a(amount);
            if (vat.inventory[slot].field_77994_a == 0) {
                vat.inventory[slot] = null;
            }
            vat.func_70296_d();
            return stack;
        }
        return null;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (!this.field_145850_b.field_72995_K) {
            PacketHandler.syncInventory(this, this.inventory);
        }
    }

    @Override
    public FluidStack getFluid(int transfer) {
        TileVat vat;
        TileVat tileVat = vat = this.master != null ? (TileVat)this.field_145850_b.func_147438_o(this.master.xCoord, this.master.yCoord, this.master.zCoord) : this;
        if (vat == null) {
            return null;
        }
        if (vat.tank.getFluid() == null) {
            return null;
        }
        if (vat.tank.getFluidAmount() - transfer < 0) {
            return null;
        }
        return new FluidStack(vat.tank.getFluidID(), transfer);
    }

    @Override
    public FluidStack getFluid() {
        return this.getFluid((byte)1);
    }

    @Override
    public FluidStack getFluid(byte tank) {
        TileVat vat;
        TileVat tileVat = vat = this.master != null ? (TileVat)this.field_145850_b.func_147438_o(this.master.xCoord, this.master.yCoord, this.master.zCoord) : this;
        if (vat == null) {
            return null;
        }
        if (tank == 1) {
            return vat.tank.getFluid();
        }
        if (tank == 2) {
            return vat.tank2.getFluid();
        }
        if (tank == 3) {
            return vat.tank3.getFluid();
        }
        return null;
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.setFluid(fluid, (byte)1);
    }

    @Override
    public void setFluid(FluidStack fluid, byte tank) {
        TileVat vat;
        TileVat tileVat = vat = this.master != null ? (TileVat)this.field_145850_b.func_147438_o(this.master.xCoord, this.master.yCoord, this.master.zCoord) : this;
        if (vat == null) {
            return;
        }
        if (tank == 1) {
            vat.tank.setFluid(fluid);
        } else if (tank == 2) {
            vat.tank2.setFluid(fluid);
        } else if (tank == 3) {
            vat.tank3.setFluid(fluid);
        }
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        TileVat vat;
        TileVat tileVat = vat = this.master != null ? (TileVat)this.field_145850_b.func_147438_o(this.master.xCoord, this.master.yCoord, this.master.zCoord) : this;
        if (vat == null) {
            return null;
        }
        FluidStack ret = vat.tank3.drain(maxDrain, doDrain);
        if (ret != null) {
            if (doDrain) {
                PacketHandler.syncFluidTank(this, this.getFluid((byte)3), (byte)3);
            }
        } else {
            ret = vat.tank2.drain(maxDrain, doDrain);
            if (ret != null) {
                if (doDrain) {
                    PacketHandler.syncFluidTank(this, this.getFluid((byte)2), (byte)2);
                }
            } else {
                ret = vat.tank.drain(maxDrain, doDrain);
                if (ret != null && doDrain) {
                    PacketHandler.syncFluidTank(this, this.getFluid((byte)1), (byte)1);
                }
            }
        }
        return ret;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        TileVat vat;
        TileVat tileVat = vat = this.master != null ? (TileVat)this.field_145850_b.func_147438_o(this.master.xCoord, this.master.yCoord, this.master.zCoord) : this;
        if (vat == null) {
            return 0;
        }
        int ret = vat.tank.fill(resource, doFill, vat.tank2);
        if (ret > 0) {
            if (doFill) {
                PacketHandler.syncFluidTank(this, this.getFluid((byte)1), (byte)1);
            }
        } else {
            ret = vat.tank2.fill(resource, doFill, vat.tank);
            if (ret > 0 && doFill) {
                PacketHandler.syncFluidTank(this, this.getFluid((byte)2), (byte)2);
            }
        }
        return ret;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        TileVat vat;
        TileVat tileVat = vat = this.master != null ? (TileVat)this.field_145850_b.func_147438_o(this.master.xCoord, this.master.yCoord, this.master.zCoord) : this;
        if (vat == null) {
            return null;
        }
        return new FluidTankInfo[]{vat.tank.getInfo(), vat.tank2.getInfo(), vat.tank3.getInfo()};
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList tagList = nbt.func_150295_c("Tanks", 10);
        for (int i = 0; i < 3; ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte tank = tag.func_74771_c("Tank");
            this.getTank(i).readFromNBT(tag);
        }
        this.timeNeeded = nbt.func_74762_e("TimeNeeded");
        this.timeRemaining = nbt.func_74762_e("TimeRemaining");
        this.canWork = nbt.func_74767_n("CanWork");
    }

    public Tank getTank(int i) {
        if (i == 0) {
            return this.tank;
        }
        if (i == 1) {
            return this.tank2;
        }
        return this.tank3;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList tankList = new NBTTagList();
        for (int i = 0; i < 3; ++i) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Tank", (byte)i);
            this.getTank(i).writeToNBT(tag);
            tankList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Tanks", (NBTBase)tankList);
        nbt.func_74768_a("TimeNeeded", this.timeNeeded);
        nbt.func_74768_a("TimeRemaining", this.timeRemaining);
        nbt.func_74757_a("CanWork", this.canWork);
    }

    @Override
    public void onBlockBreak() {
        TileVat mstr;
        if (this.master != null && (mstr = (TileVat)this.field_145850_b.func_147438_o(this.master.xCoord, this.master.yCoord, this.master.zCoord)) != null) {
            mstr.tank.setCapacity(max_sml);
            if (mstr.tank.getFluidAmount() > max_sml) {
                mstr.tank.setFluidAmount(max_sml);
            }
            mstr.tank2.setCapacity(max_sml);
            if (mstr.tank2.getFluidAmount() > max_sml) {
                mstr.tank2.setFluidAmount(max_sml);
            }
            mstr.tank3.setCapacity(max_sml);
            if (mstr.tank3.getFluidAmount() > max_sml) {
                mstr.tank3.setFluidAmount(max_sml);
            }
        }
        super.onBlockBreak();
    }

    @Override
    public boolean isPartnered(int x, int y, int z) {
        TileEntity tile = this.field_145850_b.func_147438_o(x, y, z);
        return tile instanceof TileVat ? ((TileVat)tile).master != null : false;
    }

    @Override
    public boolean isPart(int x, int y, int z) {
        return this.field_145850_b.func_147438_o(x, y, z) instanceof TileVat && !this.isPartnered(x, y, z);
    }

    @Override
    public void onBlockPlaced() {
        this.onBlockPlaced(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void onBlockPlaced(int x, int y, int z) {
        ArrayList<TileMultiBlock.MultiPart> parts;
        TileMultiBlock.MultiPart mstr;
        if (this.isPart(x, y, z) && this.isPart(x + 1, y, z) && this.isPart(x, y, z + 1) && this.isPart(x + 1, y, z + 1)) {
            mstr = new TileMultiBlock.MultiPart(x, y, z);
            parts = new ArrayList<TileMultiBlock.MultiPart>();
            parts.add(this.setAsSlave(mstr, x + 1, y, z, ForgeDirection.WEST));
            parts.add(this.setAsSlave(mstr, x + 1, y, z + 1, ForgeDirection.NORTH));
            parts.add(this.setAsSlave(mstr, x, y, z + 1, ForgeDirection.EAST));
            this.setAsMaster(mstr, parts, ForgeDirection.SOUTH);
        }
        if (this.isPart(x - 1, y, z) && this.isPart(x, y, z) && this.isPart(x, y, z + 1) && this.isPart(x - 1, y, z + 1)) {
            mstr = new TileMultiBlock.MultiPart(x - 1, y, z);
            parts = new ArrayList();
            parts.add(this.setAsSlave(mstr, x, y, z, ForgeDirection.WEST));
            parts.add(this.setAsSlave(mstr, x - 1, y, z + 1, ForgeDirection.EAST));
            parts.add(this.setAsSlave(mstr, x, y, z + 1, ForgeDirection.NORTH));
            this.setAsMaster(mstr, parts, ForgeDirection.SOUTH);
        }
        if (this.isPart(x, y, z) && this.isPart(x - 1, y, z) && this.isPart(x - 1, y, z - 1) && this.isPart(x, y, z - 1)) {
            mstr = new TileMultiBlock.MultiPart(x - 1, y, z - 1);
            parts = new ArrayList();
            parts.add(this.setAsSlave(mstr, x, y, z, ForgeDirection.NORTH));
            parts.add(this.setAsSlave(mstr, x - 1, y, z, ForgeDirection.EAST));
            parts.add(this.setAsSlave(mstr, x, y, z - 1, ForgeDirection.WEST));
            this.setAsMaster(mstr, parts, ForgeDirection.SOUTH);
        }
        if (this.isPart(x, y, z) && this.isPart(x + 1, y, z) && this.isPart(x, y, z - 1) && this.isPart(x + 1, y, z - 1)) {
            mstr = new TileMultiBlock.MultiPart(x, y, z - 1);
            parts = new ArrayList();
            parts.add(this.setAsSlave(mstr, x, y, z, ForgeDirection.EAST));
            parts.add(this.setAsSlave(mstr, x + 1, y, z, ForgeDirection.NORTH));
            parts.add(this.setAsSlave(mstr, x + 1, y, z - 1, ForgeDirection.WEST));
            this.setAsMaster(mstr, parts, ForgeDirection.SOUTH);
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drain(from, resource.amount, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    @Override
    public int getTankScaled(int i) {
        return 0;
    }

    @Override
    public String getFluidName() {
        return null;
    }

    @Override
    public List getFluidQty(List tooltip) {
        return null;
    }
}

