/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.tile.base;

import java.util.ArrayList;
import java.util.Arrays;
import mariculture.api.core.IUpgradable;
import mariculture.api.core.MaricultureHandlers;
import mariculture.core.config.Machines;
import mariculture.core.gui.feature.FeatureEject;
import mariculture.core.gui.feature.FeatureRedstone;
import mariculture.core.helpers.BlockTransferHelper;
import mariculture.core.tile.base.TileMultiBlock;
import mariculture.core.tile.base.TileMultiStorage;
import mariculture.core.util.IEjectable;
import mariculture.core.util.IMachine;
import mariculture.core.util.IProgressable;
import mariculture.core.util.IRedstoneControlled;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileMultiMachine
extends TileMultiStorage
implements IUpgradable,
IMachine,
ISidedInventory,
IRedstoneControlled,
IEjectable,
IProgressable {
    protected BlockTransferHelper helper;
    private int machineTick = 0;
    protected int purity = 0;
    protected int heat = 0;
    protected int storage = 0;
    protected int speed = 0;
    protected int rf = 0;
    protected FeatureEject.EjectSetting setting;
    protected FeatureRedstone.RedstoneMode mode;
    protected int offset = 6;
    protected int max;
    protected boolean canWork;
    protected int processed = 0;
    protected int[] output;

    public TileMultiMachine() {
        this.inventory = new ItemStack[5];
        this.mode = FeatureRedstone.RedstoneMode.LOW;
        this.setting = FeatureEject.EjectSetting.NONE;
        this.output = new int[0];
    }

    public boolean onTick(int i) {
        return this.field_145850_b.func_72820_D() % (long)i == 0L;
    }

    @Override
    public ItemStack[] getInventory() {
        return this.getMasterInventory();
    }

    @Override
    public void onInventoryChange(int slot) {
        this.updateCanWork();
        if (slot < 3) {
            this.updateUpgrades();
        }
    }

    @Override
    public void updateUpgrades() {
        this.purity = MaricultureHandlers.upgrades.getData("purity", this);
        this.heat = MaricultureHandlers.upgrades.getData("temp", this);
        this.storage = MaricultureHandlers.upgrades.getData("storage", this);
        this.speed = MaricultureHandlers.upgrades.getData("speed", this);
        this.rf = MaricultureHandlers.upgrades.getData("rf", this);
    }

    @Override
    public ItemStack[] getUpgrades() {
        return new ItemStack[]{this.inventory[0], this.inventory[1], this.inventory[2]};
    }

    public boolean canWork() {
        return false;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public final void updateCanWork() {
        this.canWork = this.canWork();
    }

    public boolean rsAllowsWork() {
        if (this.getMaster() != null) {
            TileMultiMachine mstr = (TileMultiMachine)this.getMaster();
            FeatureRedstone.RedstoneMode mode = mstr.mode;
            if (mode == FeatureRedstone.RedstoneMode.DISABLED) {
                return true;
            }
            for (TileMultiBlock.MultiPart block : mstr.slaves) {
                if (mode.equals((Object)FeatureRedstone.RedstoneMode.LOW)) {
                    if (FeatureRedstone.RedstoneMode.canWork(this.field_145850_b.func_147438_o(block.xCoord, block.yCoord, block.zCoord), mode)) continue;
                    return false;
                }
                if (!mode.equals((Object)FeatureRedstone.RedstoneMode.HIGH) || !FeatureRedstone.RedstoneMode.canWork(this.field_145850_b.func_147438_o(block.xCoord, block.yCoord, block.zCoord), mode)) continue;
                return true;
            }
            return FeatureRedstone.RedstoneMode.canWork(this.getMaster(), mode);
        }
        return false;
    }

    @Override
    public void updateMaster() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.helper == null) {
                this.helper = new BlockTransferHelper(this);
                this.updateCanWork();
                this.updateUpgrades();
            }
            this.updateTheMaster();
            this.updateMasterMachine();
        }
    }

    public abstract void process();

    public void updateMasterMachine() {
        if (this.canWork) {
            this.processed += this.speed;
            if (this.processed >= this.max) {
                this.process();
                this.updateCanWork();
                this.processed = 0;
            }
        } else {
            this.processed = 0;
        }
    }

    public void updateTheMaster() {
        this.autoeject();
    }

    public void autoeject() {
        if (this.output.length > 0 && this.onTick(Machines.Ticks.ITEM_EJECT_TICK) && this.setting.canEject(FeatureEject.EjectSetting.ITEM)) {
            for (int i : this.output) {
                if (this.inventory[i] == null) continue;
                ItemStack ejecting = this.inventory[i].func_77946_l();
                this.inventory[i] = null;
                if (ejecting == null) continue;
                this.helper.insertStack(ejecting, this.output);
                this.updateCanWork();
            }
        }
    }

    @Override
    public void setGUIData(int id, int value) {
        if (this.master == null) {
            this.master = new TileMultiBlock.MultiPart(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        switch (id) {
            case 0: {
                this.mode = FeatureRedstone.RedstoneMode.values()[value];
                break;
            }
            case 1: {
                this.setting = FeatureEject.EjectSetting.values()[value];
                break;
            }
            case 2: {
                this.processed = value;
                break;
            }
            case 3: {
                if (this.master == null) break;
                this.master.xCoord = value;
                break;
            }
            case 4: {
                if (this.master == null) break;
                this.master.yCoord = value;
                break;
            }
            case 5: {
                if (this.master == null) break;
                this.master.zCoord = value;
            }
        }
    }

    @Override
    public ArrayList<Integer> getGUIData() {
        return new ArrayList<Integer>(Arrays.asList(this.mode.ordinal(), this.setting.ordinal(), this.processed, this.master != null ? this.master.xCoord : 0, this.master != null ? this.master.yCoord : 0, this.master != null ? this.master.zCoord : 0));
    }

    @Override
    public void handleButtonClick(int id) {
        if (id == -777) {
            this.setRSMode(FeatureRedstone.RedstoneMode.toggle(this.getRSMode()));
        }
        if (id == -888) {
            this.setEjectSetting(FeatureEject.EjectSetting.toggle(this.getEjectType(), this.getEjectSetting()));
        }
    }

    @Override
    public FeatureRedstone.RedstoneMode getRSMode() {
        return this.mode != null ? this.mode : FeatureRedstone.RedstoneMode.DISABLED;
    }

    @Override
    public void setRSMode(FeatureRedstone.RedstoneMode mode) {
        this.mode = mode;
        this.updateCanWork();
    }

    @Override
    public FeatureEject.EjectSetting getEjectSetting() {
        return this.setting != null ? this.setting : FeatureEject.EjectSetting.NONE;
    }

    @Override
    public void setEjectSetting(FeatureEject.EjectSetting setting) {
        this.setting = setting;
        this.updateCanWork();
    }

    @Override
    public int getProgressScaled(int scale) {
        return this.processed * scale / this.max;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.setting = FeatureEject.EjectSetting.readFromNBT(nbt);
        this.mode = FeatureRedstone.RedstoneMode.readFromNBT(nbt);
        this.purity = nbt.func_74762_e("Purity");
        this.heat = nbt.func_74762_e("Heat");
        this.storage = nbt.func_74762_e("Storage");
        this.speed = nbt.func_74762_e("Speed");
        this.rf = nbt.func_74762_e("RF");
        this.canWork = nbt.func_74767_n("CanWork");
        this.processed = nbt.func_74762_e("Processed");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        FeatureEject.EjectSetting.writeToNBT(nbt, this.setting);
        FeatureRedstone.RedstoneMode.writeToNBT(nbt, this.mode);
        nbt.func_74768_a("Purity", this.purity);
        nbt.func_74768_a("Heat", this.heat);
        nbt.func_74768_a("Storage", this.storage);
        nbt.func_74768_a("Speed", this.speed);
        nbt.func_74768_a("RF", this.rf);
        nbt.func_74757_a("CanWork", this.canWork);
        nbt.func_74768_a("Processed", this.processed);
    }
}

